/*
 * Decompiled with CFR 0.152.
 */
package act.app.data;

import act.app.App;
import act.app.AppServiceBase;
import act.conf.AppConfig;
import act.controller.meta.HandlerParamMetaInfo;
import act.data.FileBinder;
import act.data.SObjectBinder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.osgl.mvc.util.Binder;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;

public class BinderManager
extends AppServiceBase<BinderManager> {
    private Map<Object, Binder> binders = new HashMap<Object, Binder>();

    public BinderManager(App app) {
        super(app);
        this.registerBuiltInBinders(app.config());
    }

    @Override
    protected void releaseResources() {
        this.binders.clear();
    }

    public <T> BinderManager register(Class<T> targetType, Binder<T> binder) {
        this.binders.put(targetType, binder);
        return this;
    }

    public BinderManager register(HandlerParamMetaInfo paramMetaInfo, Binder binder) {
        this.binders.put(paramMetaInfo, binder);
        return this;
    }

    public Binder binder(Class<?> clazz) {
        return this.binders.get(clazz);
    }

    public Binder binder(HandlerParamMetaInfo paramMetaInfo) {
        return this.binders.get(paramMetaInfo);
    }

    private void registerBuiltInBinders(AppConfig config) {
        this.binders.put(File.class, new FileBinder());
        this.binders.put(ISObject.class, new SObjectBinder());
        this.binders.put(SObject.class, new SObjectBinder());
    }
}

