/*
 * Decompiled with CFR 0.152.
 */
package act.app.util;

import act.Act;
import act.asm.AnnotationVisitor;
import act.exception.EnvNotMatchException;
import act.sys.Env;
import act.util.ByteCodeVisitor;
import org.osgl.util.E;

public class EnvMatcher
extends ByteCodeVisitor {
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (desc.startsWith("Lact/sys/Env$")) {
            return new EnvAnnotationVisitor(av, desc);
        }
        return av;
    }

    private static class EnvAnnotationVisitor
    extends AnnotationVisitor {
        private Type type;
        private String value;
        private boolean except;

        public EnvAnnotationVisitor(AnnotationVisitor av, String desc) {
            super(327680, av);
            this.initType(desc);
        }

        public void visit(String name, Object value) {
            if ("value".equals(name)) {
                this.value = value.toString();
            } else if ("except".equals(name)) {
                this.except = Boolean.parseBoolean(value.toString());
            }
            super.visit(name, value);
        }

        public void visitEnum(String name, String desc, String value) {
            if ("value".equals(name)) {
                this.value = value;
            }
            super.visitEnum(name, desc, value);
        }

        private void initType(String desc) {
            if (desc.contains("Profile")) {
                this.type = Type.Profile;
            } else if (desc.contains("Mode")) {
                this.type = Type.Mode;
            } else if (desc.contains("Group")) {
                this.type = Type.Group;
            } else {
                throw E.unexpected((String)"Unknown Env annotation: %s", (Object[])new Object[]{desc});
            }
        }

        public void visitEnd() {
            if (!this.matches()) {
                throw new EnvNotMatchException();
            }
            super.visitEnd();
        }

        private boolean matches() {
            return this.type.matches(this);
        }

        static enum Type {
            Profile{

                @Override
                boolean matches(EnvAnnotationVisitor visitor) {
                    return Env.profileMatches(visitor.value, visitor.except);
                }
            }
            ,
            Group{

                @Override
                boolean matches(EnvAnnotationVisitor visitor) {
                    return Env.groupMatches(visitor.value, visitor.except);
                }
            }
            ,
            Mode{

                @Override
                boolean matches(EnvAnnotationVisitor visitor) {
                    return Env.modeMatches(Act.Mode.valueOf(visitor.value), visitor.except);
                }
            };


            abstract boolean matches(EnvAnnotationVisitor var1);
        }
    }
}

