/*
 * Decompiled with CFR 0.152.
 */
package act.boot;

import act.BytecodeEnhancerManager;
import act.asm.ClassReader;
import act.asm.ClassVisitor;
import act.asm.ClassWriter;
import act.boot.PluginClassProvider;
import act.boot.app.FullStackAppBootstrapClassLoader;
import act.boot.server.ServerBootstrapClassLoader;
import act.util.ActClassLoader;
import act.util.ByteCodeVisitor;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public abstract class BootstrapClassLoader
extends ClassLoader
implements PluginClassProvider,
ActClassLoader {
    public static final String FILE_SCAN_LIST = "act.scan.list";
    protected static final Logger logger = L.get(BootstrapClassLoader.class);
    private BytecodeEnhancerManager enhancerManager = new BytecodeEnhancerManager();
    protected ClassInfoRepository classInfoRepository = new ClassInfoRepository();
    protected static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return BootstrapClassLoader.class.getProtectionDomain();
        }
    });
    protected static final Set<String> protectedClasses = C.set((Object)BootstrapClassLoader.class.getName(), (Object[])new String[]{ClassInfoRepository.class.getName(), ClassNode.class.getName(), ServerBootstrapClassLoader.class.getName(), FullStackAppBootstrapClassLoader.class.getName(), ActClassLoader.class.getName(), PluginClassProvider.class.getName()});

    protected BootstrapClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public ClassInfoRepository classInfoRepository() {
        return this.classInfoRepository;
    }

    @Override
    public Class<?> loadedClass(String name) {
        ClassLoader p;
        Class<?> c = this.findLoadedClass(name);
        if (null == c && null != (p = this.getParent()) && p instanceof ActClassLoader) {
            return ((ActClassLoader)((Object)p)).loadedClass(name);
        }
        return c;
    }

    private static ClassLoader _getParent() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null == cl) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    protected Class<?> defineClassX(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        String pkgName;
        int i = name.lastIndexOf(46);
        if (i != -1 && this.getPackage(pkgName = name.substring(0, i)) == null) {
            try {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException iae) {
                throw new AssertionError((Object)("Cannot find package " + pkgName));
            }
        }
        return super.defineClass(name, b, off, len, protectionDomain);
    }

    protected Class<?> defineClass(String name, byte[] ba) {
        Class<?> c = null;
        Lang.Val cw = $.val(null);
        ByteCodeVisitor enhancer = this.enhancerManager.generalEnhancer(name, (Lang.Var<ClassWriter>)cw);
        if (null == enhancer) {
            c = this.defineClassX(name, ba, 0, ba.length, DOMAIN);
        } else {
            Exception exception = null;
            ClassWriter w = new ClassWriter(2);
            cw.set((Object)w);
            enhancer.commitDownstream();
            ClassReader r = new ClassReader(ba);
            try {
                r.accept((ClassVisitor)enhancer, 0);
                byte[] baNew = w.toByteArray();
                c = this.defineClassX(name, baNew, 0, baNew.length, DOMAIN);
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                exception = e;
            }
            if (null != exception) {
                logger.error((Throwable)exception, "Error enhancing class %s", new Object[]{name});
                throw E.unexpected((Throwable)exception);
            }
        }
        return c;
    }

    public Set<String> scanList() {
        HashSet<String> scanList = new HashSet<String>();
        try {
            Enumeration<URL> systemResources = this.getResources(FILE_SCAN_LIST);
            while (systemResources.hasMoreElements()) {
                InputStream is = systemResources.nextElement().openStream();
                String s = IO.readContentAsString((InputStream)is);
                scanList.addAll((Collection<String>)C.listOf((Object[])s.split("[\r\n]+")).filter((Lang.Function)S.F.startsWith((String)"#").negate()).filter((Lang.Function)S.F.IS_BLANK.negate()));
            }
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        return scanList;
    }
}

