/*
 * Decompiled with CFR 0.152.
 */
package act.cli.ascii_table.impl;

import act.cli.CliContext;
import act.cli.ascii_table.ASCIITableHeader;
import act.cli.ascii_table.spec.IASCIITableAware;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.osgl.$;
import org.osgl.cache.CacheService;
import org.osgl.util.Keyword;
import org.osgl.util.S;

public class CollectionASCIITableAware<T>
implements IASCIITableAware {
    private List<ASCIITableHeader> headers = null;
    private List<List<Object>> data = null;

    public CollectionASCIITableAware(List<T> objList, String ... properties) {
        this(objList, Arrays.asList(properties), Arrays.asList(properties));
    }

    public CollectionASCIITableAware(List<T> objList, List<String> properties, List<String> title) {
        if (objList != null && !objList.isEmpty() && properties != null && !properties.isEmpty()) {
            this.headers = new ArrayList<ASCIITableHeader>(properties.size());
            int titleSize = title.size();
            properties = new ArrayList<String>(properties);
            for (int i = 0; i < properties.size(); ++i) {
                int pos;
                String prop;
                String header = prop = properties.get(i);
                if (i < titleSize && null == (header = title.get(i))) {
                    header = prop;
                }
                if ((pos = header.indexOf(" as ")) > -1) {
                    header = header.substring(pos + 4).trim();
                    prop = prop.substring(0, pos).trim();
                    properties.remove(i);
                    properties.add(i, prop);
                }
                this.headers.add(new ASCIITableHeader(Keyword.of((CharSequence)String.valueOf(header)).constantName()));
            }
            this.data = new ArrayList<List<Object>>();
            Class dataClazz = Object.class;
            for (T o : objList) {
                if (null == o) continue;
                dataClazz = o.getClass();
                break;
            }
            HashMap propertyExtractorMap = new HashMap();
            CacheService cache = null;
            CliContext ctx = CliContext.current();
            if (null != ctx) {
                cache = ctx.evaluatorCache();
            }
            for (int i = 0; i < objList.size(); ++i) {
                ArrayList<Object> rowData = new ArrayList<Object>();
                for (int j = 0; j < properties.size(); ++j) {
                    rowData.add(this.getProperty(cache, dataClazz, objList.get(i), properties.get(j)));
                }
                this.data.add(rowData);
            }
        }
    }

    private Object getProperty(CacheService evaluatorCache, Class<?> dataClazz, T obj, String property) {
        if (S.eq((String)"this", (String)property)) {
            return obj;
        }
        return $.getProperty((CacheService)evaluatorCache, obj, (String)property);
    }

    private Method getMethod(Class<?> dataClazz, String methodName) {
        Method method = null;
        try {
            method = dataClazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private String capitalize(String property) {
        return property.length() == 0 ? property : property.substring(0, 1).toUpperCase() + property.substring(1).toLowerCase();
    }

    @Override
    public List<List<Object>> getData() {
        return this.data;
    }

    @Override
    public List<ASCIITableHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public String formatData(ASCIITableHeader header, int row, int col, Object data) {
        try {
            BigDecimal bd = new BigDecimal(data.toString());
            return DecimalFormat.getInstance().format(bd);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

