/*
 * Decompiled with CFR 0.152.
 */
package act.cli.builtin;

import act.cli.CliContext;
import act.cli.CliDispatcher;
import act.cli.util.CommandLineParser;
import act.handler.CliHandler;
import act.handler.CliHandlerBase;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.Ansi;
import org.osgl.Lang;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.S;

public class Help
extends CliHandlerBase {
    public static final Help INSTANCE = new Help();
    private static int maxWidth = 0;

    private Help() {
    }

    @Override
    public void handle(CliContext context) {
        List<String> args = context.arguments();
        String command = null;
        if (args.size() > 0 && this.showHelp(command = args.get(0), context)) {
            return;
        }
        CommandLineParser parser = context.commandLine();
        boolean sys = parser.getBoolean("-s", "--system");
        boolean app = parser.getBoolean("-a", "--app");
        if (!sys && !app) {
            sys = true;
            app = true;
        }
        CliDispatcher dispatcher = context.app().cliDispatcher();
        List<String> sysCommands = dispatcher.commands(true, false);
        List<String> appCommands = dispatcher.commands(false, true);
        int maxLen = sys && !app ? this.calMaxCmdLen(sysCommands) : (app && !sys ? this.calMaxCmdLen(appCommands) : this.calMaxCmdLen((List<String>)C.list(sysCommands).append(appCommands)));
        String fmt = "%-" + (maxLen + 4) + "s - %s";
        if (sys) {
            this.list(command, "@|bold System commands|@", fmt, sysCommands, dispatcher, context);
        }
        if (app) {
            if (sys) {
                context.println("", new Object[0]);
            }
            this.list(command, "@|bold Application commands|@", fmt, appCommands, dispatcher, context);
        }
    }

    private void list(String search, String label, String fmt, List<String> commands, CliDispatcher dispatcher, CliContext context) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean noSearch = S.blank((String)search);
        if (noSearch) {
            lines.add(label.toUpperCase());
            lines.add("");
        }
        for (String cmd : commands) {
            CliHandler handler = dispatcher.handler(cmd);
            Lang.T2<String, String> commandLine = handler.commandLine();
            if (!noSearch && !((String)commandLine._1).contains(search)) continue;
            lines.add(S.fmt((String)fmt, (Object[])new Object[]{cmd, commandLine._2}));
        }
        context.println(Ansi.ansi().render(S.join((String)"\n", lines)).toString(), new Object[0]);
    }

    private int calMaxCmdLen(List<String> commands) {
        int max = 0;
        for (String c : commands) {
            max = Math.max(max, c.length());
        }
        return max;
    }

    public boolean showHelp(String command, CliContext context) {
        List<String> shortCuts;
        List<Lang.T2<String, String>> options;
        CliDispatcher dispatcher = context.app().cliDispatcher();
        CliHandler handler = dispatcher.handler(command);
        if (null == handler) {
            return false;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        List<String> names = dispatcher.names(handler);
        Lang.T2<String, String> commandLine = handler.commandLine();
        lines.add("@|bold Usage|@: " + names.get(0));
        lines.add(commandLine._2);
        String summary = handler.summary();
        if (S.notBlank((String)summary)) {
            lines.add("");
            lines.add(summary);
        }
        if (!(options = handler.options()).isEmpty()) {
            lines.add("");
            lines.add("@|bold Options|@:");
            int maxLen = 0;
            for (Lang.T2<String, String> t2 : options) {
                maxLen = Math.max(maxLen, ((String)t2._1).length());
            }
            String fmt = "  %-" + (maxLen + 4) + "s %s";
            for (Lang.T2<String, String> t2 : options) {
                lines.add(S.fmt((String)fmt, (Object[])new Object[]{t2._1, t2._2}));
            }
        }
        if (names.size() > 1) {
            lines.add("");
            lines.add("@|Aliases|@: " + S.join((String)", ", (Iterable)C.list(names).tail()));
        }
        if ((shortCuts = dispatcher.shortCuts(handler)).size() > 0) {
            lines.add("");
            lines.add("@|bold Shortcuts|@: " + S.join((String)", ", shortCuts));
        }
        context.println(Ansi.ansi().render(S.join((String)"\n", lines)).toString(), new Object[0]);
        return true;
    }

    @Override
    public Lang.T2<String, String> commandLine() {
        return Osgl.T2((Object)"help [options] [command]", (Object)"show help information");
    }

    @Override
    public String summary() {
        return "display information about a command if COMMAND is specified. Otherwise the list of help topics is printed. \n Note when COMMAND is specified, OPTIONS are ignored";
    }

    @Override
    public List<Lang.T2<String, String>> options() {
        ArrayList<Lang.T2<String, String>> retList = new ArrayList<Lang.T2<String, String>>();
        retList.add(Osgl.T2((Object)"-s --system", (Object)"list system commands"));
        retList.add(Osgl.T2((Object)"-a --app", (Object)"list application commands"));
        return retList;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public static void updateMaxWidth(int width) {
        maxWidth = Math.max(maxWidth, width);
    }
}

