/*
 * Decompiled with CFR 0.152.
 */
package act.cli.view;

import act.cli.CliContext;
import act.cli.CliOverHttpContext;
import act.cli.ascii_table.impl.CollectionASCIITableAware;
import act.cli.tree.TreeNode;
import act.cli.util.CliCursor;
import act.cli.util.TableCursor;
import act.data.DataPropertyRepository;
import act.db.AdaptiveRecord;
import act.util.ActContext;
import act.util.JsonUtilConfig;
import act.util.PropertySpec;
import java.io.Flushable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;
import org.rythmengine.utils.Escape;

public enum CliView {
    TABLE{

        @Override
        public void render(Writer writer, Object result, PropertySpec.MetaInfo spec, ActContext context) {
            DataPropertyRepository repo;
            C.List outputFields;
            int pageSize;
            if (null == result) {
                return;
            }
            if (null == (spec = PropertySpec.MetaInfo.withCurrent(spec, context))) {
                spec = new PropertySpec.MetaInfo();
            }
            if (!(context instanceof CliContext)) {
                throw E.unsupport((String)"TableView support in CliContext only. You context: ", (Object[])new Object[]{context.getClass()});
            }
            CliContext cliContext = (CliContext)context;
            List dataList = this.toList(result);
            int n = pageSize = context instanceof CliOverHttpContext ? dataList.size() : context.config().cliTablePageSize();
            if (dataList.size() > pageSize) {
                TableCursor cursor = new TableCursor(dataList, pageSize, spec);
                cliContext.session().cursor(cursor);
                cursor.output(cliContext);
                return;
            }
            if (dataList.isEmpty()) {
                return;
            }
            Class componentType = Object.class;
            for (Object o : dataList) {
                if (null == o) continue;
                componentType = o.getClass();
                break;
            }
            if ((outputFields = (repo = context.app().service(DataPropertyRepository.class)).outputFields(spec, componentType, context)).isEmpty()) {
                outputFields = C.list((Object)"this as Item");
            }
            String tableString = cliContext.getTable(new CollectionASCIITableAware(dataList, (List<String>)outputFields, spec.labels((List<String>)outputFields, context)));
            int itemsFound = dataList.size();
            CliCursor cursor = cliContext.session().cursor();
            String appendix = "";
            if (null != cursor) {
                itemsFound = cursor.records();
                appendix = cursor.hasNext() ? "\nType \"it\" for more" : "";
            }
            IO.write((CharSequence)S.concat((String)tableString, (String)"Items found: ", (String)S.string((Object)itemsFound), (String)appendix), (Writer)writer);
        }
    }
    ,
    TREE{

        @Override
        public void render(Writer writer, Object result, PropertySpec.MetaInfo spec, ActContext context) {
            if (result instanceof TreeNode) {
                this.toTreeString(writer, (TreeNode)result);
            } else if (result instanceof Iterable) {
                TABLE.render(writer, result, spec, context);
            } else if (null != spec) {
                JSON.render(writer, result, spec, context);
            } else {
                IO.write((CharSequence)S.string((Object)result), (Writer)writer);
            }
        }

        private void toTreeString(Writer writer, TreeNode result) {
            this.buildTree(writer, result, "", true);
        }

        private void buildTree(Writer writer, TreeNode node, String prefix, boolean isTrail) {
            StringBuilder sb = S.newBuilder().append(prefix).append(isTrail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(node.label()).append("\n");
            IO.write((CharSequence)sb, (Writer)writer);
            List<TreeNode> children = node.children();
            int sz = children.size();
            if (sz == 0) {
                return;
            }
            String subPrefix = S.newBuilder().append(prefix).append(isTrail ? "    " : "\u2502   ").toString();
            for (int i = 0; i < sz - 1; ++i) {
                TreeNode child = children.get(i);
                this.buildTree(writer, child, subPrefix, false);
            }
            this.buildTree(writer, children.get(sz - 1), subPrefix, true);
        }
    }
    ,
    XML{

        @Override
        public void render(Writer writer, Object result, PropertySpec.MetaInfo spec, ActContext context) {
            throw E.unsupport();
        }
    }
    ,
    JSON{

        @Override
        public void render(Writer writer, Object result, PropertySpec.MetaInfo spec, ActContext context) {
            this.render(writer, result, spec, context, context instanceof CliContext);
        }

        public void render(Writer writer, Object result, PropertySpec.MetaInfo spec, ActContext context, boolean format) {
            new JsonUtilConfig.JsonWriter(result, spec, format, context).apply(writer);
        }
    }
    ,
    TO_STRING{

        @Override
        public void render(Writer writer, Object result, PropertySpec.MetaInfo filter, ActContext context) {
            if (result instanceof Iterable) {
                TABLE.render(writer, result, filter, context);
            } else if (result instanceof TreeNode) {
                TREE.render(writer, result, filter, context);
            } else if (null != filter) {
                JSON.render(writer, result, filter, context);
            } else {
                IO.write((CharSequence)S.string((Object)result), (Writer)writer);
            }
        }
    }
    ,
    CSV{

        @Override
        public void render(Writer writer, Object result, PropertySpec.MetaInfo spec, ActContext context) {
            Object firstElement;
            Iterator iterator;
            if (null == result) {
                return;
            }
            if (result instanceof Iterable) {
                iterator = ((Iterable)result).iterator();
            } else if (result instanceof Iterator) {
                iterator = (Iterator)result;
            } else if (result instanceof Enumeration) {
                final Enumeration enumeration = (Enumeration)result;
                iterator = new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    public Object next() {
                        return enumeration.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw E.unsupport();
                    }
                };
            } else {
                iterator = C.list((Object)result).iterator();
            }
            Object object = firstElement = iterator.hasNext() ? (Object)iterator.next() : null;
            if (null == firstElement) {
                return;
            }
            Class<?> componentType = firstElement.getClass();
            DataPropertyRepository repo = context.app().service(DataPropertyRepository.class);
            if (null == (spec = PropertySpec.MetaInfo.withCurrent(spec, context))) {
                spec = new PropertySpec.MetaInfo();
                spec.onValue("-not_exists");
            }
            List<String> outputFields = repo.outputFields(spec, componentType, context);
            IO.write((CharSequence)this.buildHeaderLine(outputFields, spec.labelMapping()), (Writer)writer);
            IO.write((CharSequence)$.OS.lineSeparator(), (Writer)writer);
            IO.write((CharSequence)this.buildDataLine(firstElement, outputFields), (Writer)writer);
            while (iterator.hasNext()) {
                IO.write((CharSequence)$.OS.lineSeparator(), (Writer)writer);
                IO.write((CharSequence)this.buildDataLine(iterator.next(), outputFields), (Writer)writer);
                IO.flush((Flushable)writer);
            }
        }

        private String buildDataLine(Object data, List<String> outputFields) {
            Iterator<String> itr = outputFields.iterator();
            String prop = itr.next();
            S.Buffer buf = S.buffer();
            buf.append(this.getProperty(data, prop));
            while (itr.hasNext()) {
                buf.append(",").append(this.getProperty(data, itr.next()));
            }
            return buf.toString();
        }

        private String getProperty(Object data, String prop) {
            if ("this".equals(prop)) {
                return this.escape(data);
            }
            if (data instanceof AdaptiveRecord) {
                return this.escape(S.string(((AdaptiveRecord)data).getValue(prop)));
            }
            return this.escape($.getProperty((Object)data, (String)prop));
        }

        private String buildHeaderLine(List<String> outputFields, Map<String, String> labels) {
            if (null == labels) {
                labels = new HashMap<String, String>();
            }
            Iterator<String> itr = outputFields.iterator();
            String label = this.label(itr.next(), labels);
            S.Buffer buf = S.buffer();
            buf.append(label);
            while (itr.hasNext()) {
                buf.append(",").append(this.escape(this.label(itr.next(), labels)));
            }
            return buf.toString();
        }

        private String label(String key, Map<String, String> labels) {
            String s = labels.get(key);
            return null == s ? key : s;
        }

        private String escape(Object o) {
            if (null == o) {
                return "";
            }
            String s = o.toString().trim();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                return s;
            }
            return Escape.CSV.apply(o).toString();
        }
    };


    public void render(Writer writer, Object result, PropertySpec.MetaInfo spec, ActContext context) {
        throw E.unsupport();
    }

    public final String render(Object result, PropertySpec.MetaInfo spec, ActContext context) {
        S.Buffer sb = S.buffer();
        this.render((Writer)$.convert((Object)sb).to(Writer.class), result, spec, context);
        return sb.toString();
    }

    public void print(Object result, PropertySpec.MetaInfo spec, CliContext context) {
        context.println(this.render(result, spec, context), new Object[0]);
    }

    protected List toList(Object result) {
        C.List dataList = result instanceof Iterable ? C.list((Iterable)((Iterable)result)) : (result instanceof Iterator ? C.list((Iterator)((Iterator)result)) : (result instanceof Enumeration ? C.list((Enumeration)((Enumeration)result)) : C.listOf((Object[])new Object[]{result})));
        return dataList;
    }
}

