/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.AppHolder;
import act.app.ProjectLayout;
import act.app.RouterRegexMacroLookup;
import act.app.conf.AppConfigurator;
import act.app.event.SysEventId;
import act.app.util.NamedPort;
import act.cli.CliOverHttpAuthority;
import act.conf.AppConfigKey;
import act.conf.ConfLoader;
import act.conf.Config;
import act.conf.ConfigKey;
import act.crypto.HMAC;
import act.crypto.RotateSecretHMAC;
import act.db.util.SequenceNumberGenerator;
import act.db.util._SequenceNumberGenerator;
import act.handler.UnknownHttpMethodProcessor;
import act.handler.event.ResultEvent;
import act.i18n.I18n;
import act.internal.util.StrBufRetentionLimitCalculator;
import act.security.CSRFProtector;
import act.session.CookieSessionMapper;
import act.session.DefaultSessionCodec;
import act.session.HeaderTokenSessionMapper;
import act.session.JsonWebTokenSessionCodec;
import act.session.RotationSecretProvider;
import act.session.SessionCodec;
import act.session.SessionMapper;
import act.util.ActErrorPageRender;
import act.util.ErrorTemplatePathResolver;
import act.util.IdGenerator;
import act.util.JavaVersion;
import act.util.MissingAuthenticationHandler;
import act.util.RedirectToLoginUrl;
import act.util.ReturnUnauthorized;
import act.validation.Password;
import act.validation.PasswordSpec;
import act.view.TemplatePathResolver;
import act.view.View;
import act.ws.DefaultSecureTicketCodec;
import act.ws.SecureTicketCodec;
import act.ws.UsernameSecureTicketCodec;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.cache.CacheService;
import org.osgl.cache.CacheServiceProvider;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.mvc.ErrorPageRenderer;
import org.osgl.mvc.MvcConfig;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.ListBuilder;
import org.osgl.util.N;
import org.osgl.util.S;
import org.osgl.web.util.UserAgent;
import org.rythmengine.utils.Time;

public class AppConfig<T extends AppConfigurator>
extends Config<AppConfigKey>
implements AppHolder<AppConfig<T>> {
    public static final String CONF_FILE_NAME = "app.conf";
    public static final String CSRF_TOKEN_NAME = "__csrf__";
    public static final String PORT_CLI_OVER_HTTP = "__admin__";
    private App app;
    private RouterRegexMacroLookup routerRegexMacroLookup;
    private Boolean apiDoc;
    private Boolean apiDocBuiltInHide;
    private Boolean basicAuth;
    private Boolean builtInReqHandlerEnabled;
    private Boolean cacheForOnDev;
    private Boolean cors;
    private String corsOrigin;
    private String corsHeaders;
    private String corsHeadersExpose;
    private Boolean corsOptionCheck;
    private String corsHeadersAllowed;
    private Integer corsMaxAge;
    private Boolean corsAllowCredentials;
    private String contentSecurityPolicy;
    private boolean cspSet;
    private Boolean csrf;
    private String csrfParamName;
    private CSRFProtector csrfProtector;
    private String csrfCookieName;
    private String csrfHeaderName;
    private Boolean cliEnabled;
    private int cliTablePageSz = -1;
    private int cliJSONPageSz = -1;
    private Boolean cliOverHttp;
    private CliOverHttpAuthority cliOverHttpAuthority;
    Integer cliOverHttpPort;
    String cliOverHttpTitle;
    Boolean cliOverHttpSysCmd;
    private Integer cliPort;
    private int cliSessionExpiration = -1;
    private String dspToken;
    private Provider<String> cookieDomainProvider;
    private int maxCliSession = -1;
    private Boolean enumResolvingCaseSensitive;
    private String defViewName = null;
    private View defView = null;
    private String xForwardedProtocol = null;
    private Boolean contentSuffixAware = null;
    private _SequenceNumberGenerator seqGen = null;
    private ErrorTemplatePathResolver errorTemplatePathResolver = null;
    private String headerExpiration;
    private String host = null;
    private Boolean i18nEnabled;
    private Boolean jwtEnabled;
    private HMAC jwtAlgo;
    private String jwtIssuer;
    private String localeParamName;
    private String localeCookieName;
    Integer ipEffectiveBytes;
    private IdGenerator.NodeIdProvider nodeIdProvider;
    private String startIdFile;
    private IdGenerator.StartIdProvider startIdProvider;
    private IdGenerator.SequenceProvider sequenceProvider;
    private IdGenerator.LongEncoder longEncoder;
    private String loginUrl = null;
    private String ajaxLoginUrl = null;
    private boolean urlContextInitialized;
    private String urlContext;
    private int httpMaxParams = -1;
    private int jobPoolSize = -1;
    private int httpExternalPort = -1;
    private Boolean httpExternal = null;
    private int httpExternalSecurePort = -1;
    private int httpPort = -1;
    private Boolean httpSecure = null;
    private int httpsPort = -1;
    private MissingAuthenticationHandler mah = null;
    private MissingAuthenticationHandler ajaxMah = null;
    private MissingAuthenticationHandler csrfCheckFailureHandler = null;
    private MissingAuthenticationHandler ajaxCsrfCheckFailureHandler = null;
    private Integer threadlocalBufRetentionLimit;
    private Password.Validator defPasswordValidator;
    private List<NamedPort> namedPorts = null;
    private String encoding = null;
    private String dateFmt = null;
    private String timeFmt = null;
    private String dateDateTimeFmt = null;
    private Locale locale = null;
    private String sourceVersion = null;
    private String targetVersion = null;
    private Lang.Predicate<String> APP_CLASS_TESTER = null;
    private final Lang.Predicate<String> SYSTEM_SCAN_LIST = new Lang.Predicate<String>(){

        public boolean test(String s) {
            Set<String> scanList = AppConfig.this.app().scanList();
            if (scanList.contains(s)) {
                return true;
            }
            for (String scan : scanList) {
                if (!s.matches(scan)) continue;
                return true;
            }
            return false;
        }
    };
    private Lang.Predicate<String> CONTROLLER_CLASS_TESTER = null;
    private TemplatePathResolver templatePathResolver = null;
    private String templateHome = null;
    private boolean pingPathResolved = false;
    private String pingPath = null;
    private Integer reqThrottle;
    private Boolean reqThrottleExpireScale;
    private Lang.Func0<H.Format> jsonContentTypeProvider = null;
    private Boolean renderJsonIeFix = null;
    private H.Format jsonIE;
    private Boolean renderJsonOutputCharset;
    private String serverHeader;
    private static final String DEF_SERVER_HEADER;
    private String sessionKeyUsername = null;
    private String cookiePrefix;
    private String sessionCookieName = null;
    private String flashCookieName = null;
    private Integer sessionTtl = null;
    private Boolean sessionPersistent = null;
    private Boolean sessionEncrypt = null;
    private SessionMapper sessionMapper = null;
    private SessionCodec sessionCodec = null;
    private Boolean sessionOutputExpiration;
    private String sessionHeader;
    private boolean sessionHeaderSet;
    private String sessionHeaderPrefix;
    private String sessionHeaderPayloadPrefix = null;
    private Boolean sessionSecure = null;
    private volatile String secret = null;
    private Boolean secretRotate = null;
    private Integer secretRotatePeriod;
    private volatile SecureTicketCodec secureTicketCodec;
    private String secureTicketCodecClass;
    private Boolean traceHandler;
    private Boolean traceRequest;
    private List<File> moduleBases;
    private Boolean metricEnabled;
    private CacheServiceProvider cacheServiceProvider = null;
    private String _cacheName;
    private String _cacheNameSession;
    private UnknownHttpMethodProcessor _unknownHttpMethodProcessor = null;
    private Integer resourcePreloadSizeLimit;
    private Integer uploadInMemoryCacheThreshold;
    private Boolean ssl;
    private String wsTicketKey;
    private Set<AppConfigurator> mergeTracker = C.newSet();

    public AppConfig(Map<String, ?> configuration) {
        super(configuration);
        this.routerRegexMacroLookup = new RouterRegexMacroLookup(this);
    }

    public AppConfig() {
        this(System.getProperties());
    }

    @Override
    public AppConfig<T> app(App app) {
        E.NPE((Object)app);
        this.app = app;
        AppConfigKey.onApp(app);
        return this;
    }

    public void preloadConfigurations() {
        this.jwtEnabled();
        for (Method method : AppConfig.class.getDeclaredMethods()) {
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            if (!isPublic || 0 != method.getParameterTypes().length || "preloadConfigurations".equals(method.getName())) continue;
            $.invokeVirtual((Object)this, (Method)method, (Object[])new Object[0]);
        }
        MvcConfig.renderJsonOutputCharset((boolean)this.renderJsonOutputCharset());
        Lang.Func0<H.Format> jsonContentProvider = this.jsonContentTypeProvider();
        if (null != this.jsonContentTypeProvider) {
            MvcConfig.jsonMediaTypeProvider(jsonContentProvider);
        }
        OsglConfig.setThreadLocalBufferLimit((int)this.threadLocalBufRetentionLimit());
    }

    @Override
    public App app() {
        return this.app;
    }

    public RouterRegexMacroLookup routerRegexMacroLookup() {
        return this.routerRegexMacroLookup;
    }

    @Override
    protected ConfigKey keyOf(String s) {
        return AppConfigKey.valueOfIgnoreCase(s);
    }

    protected T enableApiDoc(boolean b) {
        this.apiDoc = b;
        return this.me();
    }

    public boolean apiDocEnabled() {
        if (null == this.apiDoc) {
            this.apiDoc = this.get(AppConfigKey.API_DOC_EABLED, Act.isDev());
        }
        return this.apiDoc;
    }

    private void _mergeApiDocEnabled(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.API_DOC_EABLED)) {
            this.apiDoc = conf.apiDoc;
        }
    }

    protected T hideBuiltInEndpointsInApiDoc(boolean b) {
        this.apiDocBuiltInHide = b;
        return this.me();
    }

    public boolean isHideBuiltInEndpointsInApiDoc() {
        if (null == this.apiDocBuiltInHide) {
            this.apiDocBuiltInHide = this.get(AppConfigKey.API_DOC_HIDE_BUILT_IN_ENDPOINTS, false);
        }
        return this.apiDocBuiltInHide;
    }

    private void _mergeHideBuiltInEndpointsInApiDoc(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.API_DOC_HIDE_BUILT_IN_ENDPOINTS)) {
            this.apiDocBuiltInHide = conf.apiDocBuiltInHide;
        }
    }

    protected T enableBasicAuthentication(boolean b) {
        this.basicAuth = b;
        return this.me();
    }

    public boolean basicAuthenticationEnabled() {
        if (null == this.basicAuth) {
            this.basicAuth = this.get(AppConfigKey.BASIC_AUTHENTICATION, Act.isDev());
        }
        return this.basicAuth;
    }

    private void _mergeBasicAuthentication(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.BASIC_AUTHENTICATION)) {
            this.basicAuth = conf.basicAuth;
        }
    }

    protected T disableBuiltInReqHandler() {
        this.builtInReqHandlerEnabled = false;
        return this.me();
    }

    public boolean builtInReqHandlerEnabled() {
        if (null == this.builtInReqHandlerEnabled) {
            this.builtInReqHandlerEnabled = this.get(AppConfigKey.BUILT_IN_REQ_HANDLER_ENABLED, true);
        }
        return this.builtInReqHandlerEnabled;
    }

    private void _mergeBuiltInReqHandler(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.BUILT_IN_REQ_HANDLER_ENABLED)) {
            this.builtInReqHandlerEnabled = conf.builtInReqHandlerEnabled;
        }
    }

    protected T enableCacheForOnDevMode() {
        this.cacheForOnDev = false;
        return this.me();
    }

    public boolean cacheForOnDevMode() {
        if (null == this.cacheForOnDev) {
            this.cacheForOnDev = this.get(AppConfigKey.CACHE_FOR_ON_DEV, false);
        }
        return this.cacheForOnDev;
    }

    private void _mergeCacheForOnDev(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CACHE_FOR_ON_DEV)) {
            this.cacheForOnDev = config.cacheForOnDev;
        }
    }

    protected T enableCors(boolean b) {
        this.cors = b;
        return this.me();
    }

    public boolean corsEnabled() {
        if (null == this.cors) {
            this.cors = this.get(AppConfigKey.CORS, false);
        }
        return this.cors;
    }

    private void _mergeCors(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS)) {
            this.cors = conf.cors;
        }
    }

    protected T corsAllowOrigin(String s) {
        this.corsOrigin = s;
        return this.me();
    }

    public String corsAllowOrigin() {
        if (null == this.corsOrigin) {
            this.corsOrigin = this.get(AppConfigKey.CORS_ORIGIN, "*");
        }
        return this.corsOrigin;
    }

    private void _mergeCorsOrigin(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_ORIGIN)) {
            this.corsOrigin = conf.corsOrigin;
        }
    }

    protected T corsHeaders(String s) {
        this.corsHeaders = s;
        return this.me();
    }

    private String corsHeaders() {
        if (null == this.corsHeaders) {
            this.corsHeaders = this.get(AppConfigKey.CORS_HEADERS, "Content-Type, X-HTTP-Method-Override, X-Requested-With");
        }
        return this.corsHeaders;
    }

    private void _mergeCorsHeaders(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_HEADERS)) {
            this.corsHeaders = conf.corsHeaders;
        }
    }

    protected T corsHeadersExpose(String s) {
        this.corsHeadersExpose = s;
        return this.me();
    }

    public String corsExposeHeaders() {
        if (null == this.corsHeadersExpose) {
            this.corsHeadersExpose = this.get(AppConfigKey.CORS_HEADERS_EXPOSE, this.corsHeaders());
        }
        return this.corsHeadersExpose;
    }

    private void _mergeCorsHeadersExpose(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_HEADERS_EXPOSE)) {
            this.corsHeadersExpose = conf.corsHeadersExpose;
        }
    }

    protected T corsOptionCheck(Boolean b) {
        this.corsOptionCheck = b;
        return this.me();
    }

    public Boolean corsOptionCheck() {
        if (null == this.corsOptionCheck) {
            this.corsOptionCheck = this.get(AppConfigKey.CORS_CHECK_OPTION_METHOD, true);
        }
        return this.corsOptionCheck;
    }

    private void _mergeCorsOptionCheck(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_CHECK_OPTION_METHOD)) {
            this.corsOptionCheck = conf.corsOptionCheck;
        }
    }

    protected T corsAllowHeaders(String s) {
        this.corsHeadersExpose = s;
        return this.me();
    }

    public String corsAllowHeaders() {
        if (null == this.corsHeadersAllowed) {
            this.corsHeadersAllowed = this.get(AppConfigKey.CORS_HEADERS_ALLOWED, this.corsHeaders());
        }
        return this.corsHeadersAllowed;
    }

    private void _mergeCorsHeadersAllowed(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_HEADERS_EXPOSE)) {
            this.corsHeadersAllowed = conf.corsHeadersAllowed;
        }
    }

    protected T corsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
        return this.me();
    }

    public int corsMaxAge() {
        if (null == this.corsMaxAge) {
            this.corsMaxAge = this.getInteger(AppConfigKey.CORS_MAX_AGE, 1800);
        }
        return this.corsMaxAge;
    }

    private void _mergeCorsMaxAge(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_MAX_AGE)) {
            this.corsMaxAge = conf.corsMaxAge;
        }
    }

    protected T corsAllowCredentials(boolean b) {
        this.corsAllowCredentials = b;
        return this.me();
    }

    public boolean corsAllowCredentials() {
        if (null == this.corsAllowCredentials) {
            this.corsAllowCredentials = this.get(AppConfigKey.CORS_ALLOW_CREDENTIALS, false);
        }
        return this.corsAllowCredentials;
    }

    private void _mergeCorsAllowCredential(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_ALLOW_CREDENTIALS)) {
            this.corsAllowCredentials = conf.corsAllowCredentials;
        }
    }

    protected T contentSecurityPolicy(String policy) {
        this.contentSecurityPolicy = policy;
        this.cspSet = null != policy;
        return this.me();
    }

    public String contentSecurityPolicy() {
        if (!this.cspSet) {
            this.contentSecurityPolicy = this.get(AppConfigKey.CONTENT_SECURITY_POLICY, null);
            this.cspSet = true;
        }
        return this.contentSecurityPolicy;
    }

    private void _mergeCsp(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CONTENT_SECURITY_POLICY)) {
            this.contentSecurityPolicy = conf.contentSecurityPolicy;
            this.cspSet = null != this.contentSecurityPolicy;
        }
    }

    protected T enableCsrf(boolean b) {
        this.csrf = b;
        return this.me();
    }

    public boolean csrfEnabled() {
        if (null == this.csrf) {
            this.csrf = this.get(AppConfigKey.CSRF, false);
        }
        return this.csrf;
    }

    private void _mergeCsrf(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF)) {
            this.csrf = conf.csrf;
        }
    }

    protected T csrfParamName(String s) {
        this.csrfParamName = s;
        return this.me();
    }

    public String csrfParamName() {
        if (null == this.csrfParamName) {
            this.csrfParamName = this.get(AppConfigKey.CSRF_PARAM_NAME, CSRF_TOKEN_NAME);
        }
        return this.csrfParamName;
    }

    private void _mergeCsrfParamName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_PARAM_NAME)) {
            this.csrfParamName = conf.csrfParamName;
        }
    }

    protected T csrfProtector(CSRFProtector protector) {
        this.csrfProtector = (CSRFProtector)$.notNull((Object)protector);
        return this.me();
    }

    public CSRFProtector csrfProtector() {
        if (null == this.csrfProtector) {
            try {
                this.csrfProtector = this.get(AppConfigKey.CSRF_PROTECTOR, CSRFProtector.Predefined.HMAC);
            }
            catch (ConfigurationException e) {
                Object obj = AppConfigKey.helper.getValFromAliases(this.raw, AppConfigKey.CSRF_PROTECTOR.key(), "impl", null);
                if (null != obj) {
                    this.csrfProtector = CSRFProtector.Predefined.valueOfIgnoreCase(obj.toString());
                    if (null != this.csrfProtector) {
                        this.set(AppConfigKey.CSRF_PROTECTOR, this.csrfProtector);
                        return this.csrfProtector;
                    }
                }
                throw e;
            }
        }
        return this.csrfProtector;
    }

    private void _mergeCsrfProtector(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_PROTECTOR)) {
            this.csrfProtector = config.csrfProtector;
        }
    }

    protected T csrfCookieName(String s) {
        this.csrfCookieName = s;
        return this.me();
    }

    public String csrfCookieName() {
        if (null == this.csrfCookieName) {
            this.csrfCookieName = this.get(AppConfigKey.CSRF_COOKIE_NAME, this.cookieName("xsrf-token"));
        }
        return this.csrfCookieName;
    }

    private void _mergeCsrfCookieName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_COOKIE_NAME)) {
            this.csrfCookieName = conf.csrfCookieName;
        }
    }

    protected T csrfHeaderName(String s) {
        this.csrfHeaderName = s;
        return this.me();
    }

    public String csrfHeaderName() {
        if (null == this.csrfHeaderName) {
            this.csrfHeaderName = this.get(AppConfigKey.CSRF_HEADER_NAME, "X-Xsrf-Token");
        }
        return this.csrfHeaderName;
    }

    private void _mergeCsrfHeaderName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_HEADER_NAME)) {
            this.csrfHeaderName = conf.csrfHeaderName;
        }
    }

    protected T cliEnable(boolean enable) {
        this.cliEnabled = enable;
        return this.me();
    }

    public boolean cliEnabled() {
        if (null == this.cliEnabled) {
            this.cliEnabled = this.get(AppConfigKey.CLI_ENABLED, true);
        }
        return this.cliEnabled;
    }

    private void _mergeCliEnabled(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_ENABLED)) {
            this.cliEnabled = conf.cliEnabled;
        }
    }

    protected T cliTablePageSz(int sz) {
        E.illegalArgumentIf((sz < 1 ? 1 : 0) != 0, (String)"CLI table page size not valid: %s", (Object[])new Object[]{sz});
        this.cliTablePageSz = sz;
        return this.me();
    }

    public int cliTablePageSize() {
        if (-1 == this.cliTablePageSz) {
            this.cliTablePageSz = this.getInteger(AppConfigKey.CLI_PAGE_SIZE_TABLE, 22);
        }
        return this.cliTablePageSz;
    }

    private void _mergeCliTablePageSz(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_PAGE_SIZE_TABLE)) {
            this.cliTablePageSz = conf.cliTablePageSz;
        }
    }

    protected T cliJSONPageSz(int sz) {
        E.illegalArgumentIf((sz < 1 ? 1 : 0) != 0, (String)"CLI JSON page size not valid: %s", (Object[])new Object[]{sz});
        this.cliJSONPageSz = sz;
        return this.me();
    }

    public int cliJSONPageSize() {
        if (-1 == this.cliJSONPageSz) {
            this.cliJSONPageSz = this.getInteger(AppConfigKey.CLI_PAGE_SIZE_TABLE, 22);
        }
        return this.cliJSONPageSz;
    }

    private void _mergeCliJSONPageSz(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_PAGE_SIZE_TABLE)) {
            this.cliJSONPageSz = conf.cliJSONPageSz;
        }
    }

    protected T cliOverHttp(boolean enabled) {
        this.cliOverHttp = enabled;
        return this.me();
    }

    public boolean cliOverHttp() {
        if (null == this.cliOverHttp) {
            this.cliOverHttp = this.get(AppConfigKey.CLI_OVER_HTTP, false);
        }
        return this.cliOverHttp;
    }

    private void _mergeCliOverHttp(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP)) {
            this.cliOverHttp = config.cliOverHttp;
        }
    }

    protected T cliOverHttpAuthority(CliOverHttpAuthority authority) {
        this.cliOverHttpAuthority = authority;
        return this.me();
    }

    public CliOverHttpAuthority cliOverHttpAuthority() {
        if (null == this.cliOverHttpAuthority) {
            this.cliOverHttpAuthority = this.get(AppConfigKey.CLI_OVER_HTTP_AUTHORITY, new CliOverHttpAuthority.AllowAll());
        }
        return this.cliOverHttpAuthority;
    }

    private void _mergeCliOverHttpAuthority(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_AUTHORITY)) {
            this.cliOverHttpAuthority = config.cliOverHttpAuthority;
        }
    }

    protected T cliOverHttpPort(int port) {
        this.cliOverHttpPort = port;
        return this.me();
    }

    public int cliOverHttpPort() {
        if (null == this.cliOverHttpPort) {
            this.cliOverHttpPort = this.get(AppConfigKey.CLI_OVER_HTTP_PORT, 5462);
        }
        return this.cliOverHttpPort;
    }

    private void _mergeCliOverHttpPort(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_PORT)) {
            this.cliOverHttpPort = config.cliOverHttpPort;
        }
    }

    protected T cliOverHttpTitle(String title) {
        this.cliOverHttpTitle = title;
        return this.me();
    }

    public String cliOverHttpTitle() {
        if (null == this.cliOverHttpTitle) {
            this.cliOverHttpTitle = this.get(AppConfigKey.CLI_OVER_HTTP_TITLE, "Cli Over Http");
        }
        return this.cliOverHttpTitle;
    }

    private void _mergeCliOverHttpTitle(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_TITLE)) {
            this.cliOverHttpTitle = config.cliOverHttpTitle;
        }
    }

    protected T cliOverHttpSysCmd(boolean enabled) {
        this.cliOverHttpSysCmd = enabled;
        return this.me();
    }

    public boolean cliOverHttpSysCmdEnabled() {
        if (null == this.cliOverHttpSysCmd) {
            this.cliOverHttpSysCmd = this.get(AppConfigKey.CLI_OVER_HTTP_SYS_CMD, true);
        }
        return this.cliOverHttpSysCmd;
    }

    private void _mergeCliOverHttpSysCmd(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_SYS_CMD)) {
            this.cliOverHttpSysCmd = config.cliOverHttpSysCmd;
        }
    }

    protected T cliPort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.cliPort = port;
        return this.me();
    }

    public int cliPort() {
        if (null == this.cliPort) {
            this.cliPort = this.get(AppConfigKey.CLI_PORT, 5461);
        }
        return this.cliPort;
    }

    private void _mergeCliPort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_PORT)) {
            this.cliPort = conf.cliPort;
        }
    }

    protected T cliSessionExpiration(int expire) {
        E.illegalArgumentIf((expire < 1 ? 1 : 0) != 0, (String)"cli session expire not valid: %s", (Object[])new Object[]{expire});
        this.cliSessionExpiration = expire;
        return this.me();
    }

    public int cliSessionExpiration() {
        if (-1 == this.cliSessionExpiration) {
            this.cliSessionExpiration = this.get(AppConfigKey.CLI_SESSION_TTL, 300);
        }
        return this.cliSessionExpiration;
    }

    private void _mergeCliSessionExpiration(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_SESSION_TTL)) {
            this.cliSessionExpiration = conf.cliSessionExpiration;
        }
    }

    protected T dspToken(String tokenName) {
        this.dspToken = tokenName;
        return this.me();
    }

    public String dspToken() {
        if (null == this.dspToken) {
            this.dspToken = this.get(AppConfigKey.DOUBLE_SUBMISSION_PROTECT_TOKEN, "act_dsp_token");
        }
        return this.dspToken;
    }

    private void _mergeDspToken(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.DOUBLE_SUBMISSION_PROTECT_TOKEN)) {
            this.dspToken = conf.dspToken;
        }
    }

    protected T cookieDomain(final String domain) {
        this.cookieDomainProvider = new Provider<String>(){

            public String get() {
                return domain;
            }
        };
        return this.me();
    }

    protected T cookieDomainProvider(Provider<String> provider) {
        this.cookieDomainProvider = (Provider)$.notNull(provider);
        return this.me();
    }

    public String cookieDomain() {
        String domain = (String)this.cookieDomainProvider().get();
        return "localhost".equals(domain) ? null : domain;
    }

    private Provider<String> cookieDomainProvider() {
        if (null == this.cookieDomainProvider) {
            try {
                this.cookieDomainProvider = this.get(AppConfigKey.COOKIE_DOMAIN_PROVIDER, new Provider<String>(){

                    public String get() {
                        return AppConfig.this.host();
                    }
                });
            }
            catch (ConfigurationException e) {
                Object obj = AppConfigKey.helper.getValFromAliases(this.raw, AppConfigKey.COOKIE_DOMAIN_PROVIDER.key(), "impl", null);
                String s = obj.toString();
                if ("dynamic".equalsIgnoreCase(s) || "flexible".equalsIgnoreCase(s) || "contextual".equalsIgnoreCase(s)) {
                    this.cookieDomainProvider = new Provider<String>(){

                        public String get() {
                            H.Request req = ActionContext.current().req();
                            return req.domain();
                        }
                    };
                    return this.cookieDomainProvider;
                }
                throw e;
            }
        }
        return this.cookieDomainProvider;
    }

    private void _mergeCookieDomain(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.COOKIE_DOMAIN_PROVIDER)) {
            this.cookieDomainProvider = config.cookieDomainProvider;
        }
    }

    protected T maxCliSession(int size) {
        E.illegalArgumentIf((size < 1 ? 1 : 0) != 0, (String)"max cli session number cannot be zero or negative number: %s", (Object[])new Object[]{size});
        this.maxCliSession = size;
        return this.me();
    }

    public int maxCliSession() {
        if (-1 == this.maxCliSession) {
            this.maxCliSession = this.get(AppConfigKey.CLI_SESSION_MAX, 3);
        }
        return this.maxCliSession;
    }

    private void _mergeMaxCliSession(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_SESSION_MAX)) {
            this.maxCliSession = conf.maxCliSession;
        }
    }

    protected T enumResolvingCaseSensitive(boolean b) {
        this.enumResolvingCaseSensitive = b;
        return this.me();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enumResolvingCaseSensitive() {
        AppConfigKey appConfigKey = AppConfigKey.ENUM_RESOLVING_CASE_SENSITIVE;
        synchronized (appConfigKey) {
            if (null == this.enumResolvingCaseSensitive) {
                this.enumResolvingCaseSensitive = this.get(AppConfigKey.ENUM_RESOLVING_CASE_SENSITIVE, false);
            }
            return this.enumResolvingCaseSensitive;
        }
    }

    private void _mergeEnumResolvingCaseSensitive(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ENUM_RESOLVING_CASE_SENSITIVE)) {
            this.enumResolvingCaseSensitive = conf.enumResolvingCaseSensitive;
        }
    }

    protected T defaultView(View view) {
        E.NPE((Object)view);
        this.defView = view;
        return this.me();
    }

    public View defaultView() {
        if (null == this.defViewName) {
            this.defViewName = this.get(AppConfigKey.VIEW_DEFAULT, "rythm");
            this.defView = Act.viewManager().view(this.defViewName);
        }
        return this.defView;
    }

    private void _mergeDefaultView(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.VIEW_DEFAULT)) {
            this.defViewName = conf.defViewName;
            this.defView = conf.defView;
        }
    }

    protected T forceHttps() {
        this.xForwardedProtocol = "https";
        return this.me();
    }

    public String xForwardedProtocol() {
        if (null == this.xForwardedProtocol) {
            this.xForwardedProtocol = this.get(AppConfigKey.X_FORWARD_PROTOCOL, "http");
        }
        return this.xForwardedProtocol;
    }

    private void _mergeXForwardedProtocol(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.X_FORWARD_PROTOCOL)) {
            this.xForwardedProtocol = conf.xForwardedProtocol;
        }
    }

    protected T contentSuffixAware(boolean b) {
        this.contentSuffixAware = b;
        return this.me();
    }

    public Boolean contentSuffixAware() {
        if (null == this.contentSuffixAware) {
            this.contentSuffixAware = this.get(AppConfigKey.CONTENT_SUFFIX_AWARE, false);
        }
        return this.contentSuffixAware;
    }

    private void _mergeContentSuffixAware(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CONTENT_SUFFIX_AWARE)) {
            this.contentSuffixAware = conf.contentSuffixAware;
        }
    }

    protected T sequenceNumberGenerator(_SequenceNumberGenerator seqGen) {
        this.seqGen = seqGen;
        return this.me();
    }

    public _SequenceNumberGenerator sequenceNumberGenerator() {
        if (null == this.seqGen) {
            Provider provider = this.app().getInstance(SequenceNumberGenerator.Provider.class);
            this.seqGen = (_SequenceNumberGenerator)this.get(AppConfigKey.DB_SEQ_GENERATOR, provider.get());
        }
        return this.seqGen;
    }

    private void _mergeSequenceNumberGenerator(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.DB_SEQ_GENERATOR)) {
            this.seqGen = conf.seqGen;
        }
    }

    protected T errorTemplatePathResolver(ErrorTemplatePathResolver resolver) {
        this.errorTemplatePathResolver = resolver;
        return this.me();
    }

    public ErrorTemplatePathResolver errorTemplatePathResolver() {
        if (null == this.errorTemplatePathResolver) {
            this.errorTemplatePathResolver = this.get(AppConfigKey.RESOLVER_ERROR_TEMPLATE_PATH, new ErrorTemplatePathResolver.DefaultErrorTemplatePathResolver());
        }
        return this.errorTemplatePathResolver;
    }

    private void _mergeErrorTemplatePathResolver(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RESOLVER_ERROR_TEMPLATE_PATH)) {
            this.errorTemplatePathResolver = conf.errorTemplatePathResolver;
        }
    }

    protected T headerExpiration(String headerName) {
        this.headerExpiration = headerName.trim();
        return this.me();
    }

    public String headerExpiration() {
        if (null == this.headerExpiration) {
            this.headerExpiration = this.get(AppConfigKey.HEADER_EXPIRATION, "Expires");
        }
        return this.headerExpiration;
    }

    private void _mergeHeaderExpiration(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HEADER_EXPIRATION)) {
            this.headerExpiration = config.headerExpiration;
        }
    }

    protected T host(String hostname) {
        E.illegalArgumentIf(((hostname = hostname.trim()).length() == 0 ? 1 : 0) != 0, (String)"hostname cannot be empty");
        this.host = hostname;
        return this.me();
    }

    public String host() {
        if (null == this.host) {
            this.host = this.get(AppConfigKey.HOST, "localhost");
        }
        return this.host;
    }

    private void _mergeHost(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HOST)) {
            this.host = conf.host;
        }
    }

    protected T i18n(boolean enabled) {
        this.i18nEnabled = enabled;
        return this.me();
    }

    public boolean i18nEnabled() {
        if (null == this.i18nEnabled) {
            this.i18nEnabled = this.get(AppConfigKey.I18N, false);
        }
        return this.i18nEnabled;
    }

    private void _mergeI18nEnabled(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.I18N)) {
            this.i18nEnabled = conf.i18nEnabled;
        }
    }

    protected T jwtEnabled(boolean enabled) {
        this.jwtEnabled = enabled;
        return this.me();
    }

    public boolean jwtEnabled() {
        if (null == this.jwtEnabled) {
            this.jwtEnabled = this.get(AppConfigKey.JWT, false);
            if (this.jwtEnabled.booleanValue()) {
                if (!this.hasConfiguration(AppConfigKey.SESSION_HEADER)) {
                    this.sessionHeader("Authorization");
                }
                if (!this.hasConfiguration(AppConfigKey.SESSION_HEADER_PAYLOAD_PREFIX)) {
                    this.sessionHeaderPayloadPrefix("Bearer ");
                }
                if (!this.hasConfiguration(AppConfigKey.SESSION_MAPPER)) {
                    this.sessionMapper(new HeaderTokenSessionMapper(this));
                }
                if (!this.hasConfiguration(AppConfigKey.SESSION_CODEC)) {
                    this.sessionCodec(this.app().getInstance(JsonWebTokenSessionCodec.class));
                }
            }
        }
        return this.jwtEnabled;
    }

    private void _mergeJWT(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.JWT)) {
            this.jwtEnabled = config.jwtEnabled;
        }
    }

    protected T jwtArgo(HMAC.Algorithm algo) {
        this.jwtAlgo = new HMAC(this.secret(), algo);
        return this.me();
    }

    public HMAC jwtAlgo() {
        if (null == this.jwtAlgo) {
            String algoKey = this.get(AppConfigKey.JWT_ALGO, "SHA256");
            this.jwtAlgo = this.rotateSecret() ? new RotateSecretHMAC(algoKey, this.app.getInstance(RotationSecretProvider.class)) : new HMAC(this.secret(), algoKey);
        }
        return this.jwtAlgo;
    }

    private void _mergeJWTAlgo(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.JWT_ALGO)) {
            this.jwtAlgo = config.jwtAlgo;
        }
    }

    protected T jwtIssuer(String issuer) {
        E.illegalArgumentIf((boolean)S.blank((String)issuer), (String)"issuer cannot be empty");
        this.jwtIssuer = issuer;
        return this.me();
    }

    public String jwtIssuer() {
        if (null == this.jwtIssuer) {
            this.jwtIssuer = this.get(AppConfigKey.JWT_ISSUER, this.cookiePrefix().substring(0, this.cookiePrefix().length() - 1));
        }
        return this.jwtIssuer;
    }

    private void _mergeJwtIssuer(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.JWT_ISSUER)) {
            this.jwtIssuer = config.jwtIssuer;
        }
    }

    protected T localeParamName(String name) {
        E.illegalArgumentIf((boolean)S.blank((String)name), (String)"locale param name must not be empty");
        this.localeParamName = name;
        return this.me();
    }

    public String localeParamName() {
        if (null == this.localeParamName) {
            this.localeParamName = this.get(AppConfigKey.I18N_LOCALE_PARAM_NAME, "act_locale");
        }
        return this.localeParamName;
    }

    private void _mergeLocaleParamName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.I18N_LOCALE_PARAM_NAME)) {
            this.localeParamName = conf.localeParamName;
        }
    }

    protected T localeCookieName(String name) {
        E.illegalArgumentIf((boolean)S.blank((String)name), (String)"locale Cookie name must not be empty");
        this.localeCookieName = name;
        return this.me();
    }

    public String localeCookieName() {
        if (null == this.localeCookieName) {
            this.localeCookieName = this.get(AppConfigKey.I18N_LOCALE_COOKIE_NAME, "locale");
        }
        return this.localeCookieName;
    }

    private void _mergeLocaleCookieName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.I18N_LOCALE_COOKIE_NAME)) {
            this.localeCookieName = conf.localeCookieName;
        }
    }

    protected T ipEffectiveBytes(int n) {
        E.illegalArgumentIf((n < 1 || n > 4 ? 1 : 0) != 0, (String)"integer from 1 to 4 (inclusive) expected");
        this.ipEffectiveBytes = n;
        return this.me();
    }

    public int ipEffectiveBytes() {
        if (null == this.ipEffectiveBytes) {
            this.ipEffectiveBytes = this.getInteger(AppConfigKey.ID_GEN_NODE_ID_EFFECTIVE_IP_BYTES, 4);
        }
        return this.ipEffectiveBytes;
    }

    private void _mergeIpEffectiveBytes(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_NODE_ID_EFFECTIVE_IP_BYTES)) {
            this.ipEffectiveBytes = conf.ipEffectiveBytes;
        }
    }

    protected T nodeIdProvider(IdGenerator.NodeIdProvider provider) {
        this.nodeIdProvider = (IdGenerator.NodeIdProvider)$.NPE((Object)provider);
        return this.me();
    }

    public IdGenerator.NodeIdProvider nodeIdProvider() {
        if (null == this.nodeIdProvider) {
            this.nodeIdProvider = this.get(AppConfigKey.ID_GEN_NODE_ID_PROVIDER, new IdGenerator.NodeIdProvider.IpProvider(this.ipEffectiveBytes()));
        }
        return this.nodeIdProvider;
    }

    private void _mergeNodeIdProvider(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_NODE_ID_PROVIDER)) {
            this.nodeIdProvider = conf.nodeIdProvider;
        }
    }

    protected T startIdFile(String file) {
        E.illegalArgumentIf((boolean)S.blank((String)file));
        this.startIdFile = file;
        return this.me();
    }

    public String startIdFile() {
        if (null == this.startIdFile) {
            this.startIdFile = this.get(AppConfigKey.ID_GEN_START_ID_FILE, ".act.id-app");
        }
        return this.startIdFile;
    }

    private void _mergeStartIdFile(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_START_ID_FILE)) {
            this.startIdFile = conf.startIdFile;
        }
    }

    protected T startIdProvider(IdGenerator.StartIdProvider provider) {
        this.startIdProvider = (IdGenerator.StartIdProvider)$.NPE((Object)provider);
        return this.me();
    }

    public IdGenerator.StartIdProvider startIdProvider() {
        if (null == this.startIdProvider) {
            this.startIdProvider = this.get(AppConfigKey.ID_GEN_START_ID_PROVIDER, new IdGenerator.StartIdProvider.DefaultStartIdProvider(this.startIdFile()));
        }
        return this.startIdProvider;
    }

    private void _mergeStartIdProvider(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_START_ID_PROVIDER)) {
            this.startIdProvider = conf.startIdProvider;
        }
    }

    protected T sequenceProvider(IdGenerator.SequenceProvider provider) {
        this.sequenceProvider = (IdGenerator.SequenceProvider)$.NPE((Object)provider);
        return this.me();
    }

    public IdGenerator.SequenceProvider sequenceProvider() {
        if (null == this.sequenceProvider) {
            this.sequenceProvider = this.get(AppConfigKey.ID_GEN_SEQ_ID_PROVIDER, new IdGenerator.SequenceProvider.AtomicLongSeq());
        }
        return this.sequenceProvider;
    }

    private void _mergeSequenceProvider(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_SEQ_ID_PROVIDER)) {
            this.sequenceProvider = conf.sequenceProvider;
        }
    }

    protected T longEncoder(IdGenerator.LongEncoder longEncoder) {
        this.longEncoder = (IdGenerator.LongEncoder)$.NPE((Object)longEncoder);
        return this.me();
    }

    public IdGenerator.LongEncoder longEncoder() {
        if (null == this.longEncoder) {
            this.longEncoder = this.get(AppConfigKey.ID_GEN_LONG_ENCODER, IdGenerator.SAFE_ENCODER);
        }
        return this.longEncoder;
    }

    private void _mergeLongEncoder(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_LONG_ENCODER)) {
            this.longEncoder = conf.longEncoder;
        }
    }

    protected T loginUrl(String url) {
        E.illegalArgumentIf((!url.startsWith("/") ? 1 : 0) != 0, (String)"login URL shall start with '/'");
        this.loginUrl = url;
        return this.me();
    }

    public String loginUrl() {
        ActionContext context;
        if (null == this.loginUrl) {
            this.loginUrl = this.get(AppConfigKey.URL_LOGIN, "/login");
        }
        if (null != (context = ActionContext.current()) && context.isAjax()) {
            return this.ajaxLoginUrl();
        }
        return this.loginUrl;
    }

    private void _mergeLoginUrl(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.URL_LOGIN)) {
            this.loginUrl = conf.loginUrl;
        }
    }

    protected T ajaxLoginUrl(String url) {
        E.illegalArgumentIf((!url.startsWith("/") ? 1 : 0) != 0, (String)"login URL shall start with '/'");
        this.ajaxLoginUrl = url;
        return this.me();
    }

    public String ajaxLoginUrl() {
        if (null == this.ajaxLoginUrl) {
            this.ajaxLoginUrl = this.get(AppConfigKey.URL_LOGIN_AJAX, this.loginUrl());
        }
        return this.ajaxLoginUrl;
    }

    private void _mergeAjaxLoginUrl(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.URL_LOGIN_AJAX)) {
            this.ajaxLoginUrl = conf.ajaxLoginUrl;
        }
    }

    protected T urlContext(String context) {
        this.urlContext = context;
        this.urlContextInitialized = S.notBlank((String)context);
        return this.me();
    }

    public String urlContext() {
        if (!this.urlContextInitialized) {
            this.urlContext = this.get(AppConfigKey.URL_CONTEXT, null);
            if (null != this.urlContext) {
                this.urlContext = this.urlContext.trim();
                if (this.urlContext.length() == 0) {
                    this.urlContext = null;
                } else {
                    while (this.urlContext.endsWith("/")) {
                        this.urlContext = this.urlContext.substring(0, this.urlContext.length() - 1);
                    }
                    if (this.urlContext.length() == 0) {
                        this.urlContext = null;
                    } else if (!this.urlContext.startsWith("/")) {
                        this.urlContext = S.concat((String)"/", (String)this.urlContext);
                    }
                }
                if (null != this.urlContext && this.urlContext.contains(" ")) {
                    throw E.invalidConfiguration((String)"url context shall not contains white space", (Object[])new Object[0]);
                }
            }
            this.urlContextInitialized = true;
        }
        return this.urlContext;
    }

    private void _mergeUrlContext(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.URL_CONTEXT)) {
            this.urlContext = conf.urlContext;
            this.urlContextInitialized = conf.urlContextInitialized;
        }
    }

    protected T httpMaxParams(int max) {
        E.illegalArgumentIf((max < 0 ? 1 : 0) != 0, (String)"max params cannot be negative number: %s", (Object[])new Object[]{max});
        this.httpMaxParams = max;
        return this.me();
    }

    public int httpMaxParams() {
        if (-1 == this.httpMaxParams) {
            this.httpMaxParams = this.getInteger(AppConfigKey.HTTP_MAX_PARAMS, 128);
            if (this.httpMaxParams < 0) {
                throw new ConfigurationException("http.params.max setting cannot be negative number. Found: %s", new Object[]{this.httpMaxParams});
            }
        }
        return this.httpMaxParams;
    }

    private void _mergeHttpMaxParams(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_MAX_PARAMS)) {
            this.httpMaxParams = conf.httpMaxParams;
        }
    }

    protected T jobPoolSize(int size) {
        E.illegalArgumentIf((size < 1 ? 1 : 0) != 0, (String)"job pool size cannot be zero or negative number: %s", (Object[])new Object[]{size});
        this.jobPoolSize = size;
        return this.me();
    }

    public int jobPoolSize() {
        if (-1 == this.jobPoolSize) {
            this.jobPoolSize = this.getInteger(AppConfigKey.JOB_POOL_SIZE, 10);
        }
        return this.jobPoolSize;
    }

    private void _mergeJobPoolSize(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.JOB_POOL_SIZE)) {
            this.jobPoolSize = conf.jobPoolSize;
        }
    }

    protected T httpExternalPort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.httpExternalPort = port;
        return this.me();
    }

    public int httpExternalPort() {
        if (-1 == this.httpExternalPort) {
            this.httpExternalPort = this.get(AppConfigKey.HTTP_EXTERNAL_PORT, this.httpExternal() ? 80 : this.httpPort());
        }
        return this.httpExternalPort;
    }

    private void _mergeHttpExternalPort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_EXTERNAL_PORT)) {
            this.httpExternalPort = conf.httpExternalPort();
        }
    }

    protected T httpExternal(boolean setting) {
        this.httpExternal = setting;
        return this.me();
    }

    public boolean httpExternal() {
        if (null == this.httpExternal) {
            this.httpExternal = this.get(AppConfigKey.HTTP_EXTERNAL_SERVER, Act.isProd());
        }
        return this.httpExternal;
    }

    private void _mergeHttpExternal(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_EXTERNAL_SERVER)) {
            this.httpExternal = conf.httpExternal;
        }
    }

    protected T httpExternalSecurePort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.httpExternalSecurePort = port;
        return this.me();
    }

    public int httpExternalSecurePort() {
        if (-1 == this.httpExternalSecurePort) {
            this.httpExternalSecurePort = this.get(AppConfigKey.HTTP_EXTERNAL_SECURE_PORT, this.httpExternal() ? 443 : this.httpPort());
        }
        return this.httpExternalSecurePort;
    }

    private void _mergeHttpExternalSecurePort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_EXTERNAL_PORT)) {
            this.httpExternalSecurePort = conf.httpExternalSecurePort;
        }
    }

    protected T httpPort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.httpPort = port;
        return this.me();
    }

    public int httpPort() {
        if (-1 == this.httpPort) {
            this.httpPort = this.get(AppConfigKey.HTTP_PORT, 5460);
        }
        return this.httpPort;
    }

    private void _mergeHttpPort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_PORT)) {
            this.httpPort = conf.httpPort;
        }
    }

    protected T httpSecure(boolean secure) {
        this.httpSecure = secure;
        return this.me();
    }

    public boolean httpSecure() {
        if (null == this.httpSecure) {
            this.httpSecure = this.get(AppConfigKey.HTTP_SECURE, !Act.isDev() && S.neq((String)Act.profile(), (String)"dev", (int)4096));
        }
        return this.httpSecure;
    }

    private void _mergeHttpSecure(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_SECURE)) {
            this.httpSecure = conf.httpSecure;
        }
    }

    protected T httpsPort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.httpsPort = port;
        return this.me();
    }

    public int httpsPort() {
        if (-1 == this.httpsPort) {
            this.httpsPort = this.get(AppConfigKey.HTTPS_PORT, 5443);
        }
        return this.httpsPort;
    }

    private void _mergeHttpsPort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTPS_PORT)) {
            this.httpsPort = conf.httpsPort;
        }
    }

    protected T missingAuthenticationHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.mah = handler;
        return this.me();
    }

    public MissingAuthenticationHandler missingAuthenticationHandler() {
        if (null == this.mah) {
            RedirectToLoginUrl redirectToLoginUrl = this.app.getInstance(RedirectToLoginUrl.class);
            RedirectToLoginUrl defHandler = redirectToLoginUrl.hasLoginUrl() ? redirectToLoginUrl : (MissingAuthenticationHandler)this.app.getInstance(ReturnUnauthorized.class);
            this.mah = this.get(AppConfigKey.HANDLER_MISSING_AUTHENTICATION, defHandler);
        }
        return this.mah;
    }

    private void _mergeMissingAuthenticationHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_MISSING_AUTHENTICATION)) {
            this.mah = config.mah;
        }
    }

    protected T ajaxMissingAuthenticationHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.ajaxMah = handler;
        return this.me();
    }

    public MissingAuthenticationHandler ajaxMissingAuthenticationHandler() {
        if (null == this.ajaxMah) {
            this.ajaxMah = this.get(AppConfigKey.HANDLER_MISSING_AUTHENTICATION_AJAX, this.missingAuthenticationHandler());
        }
        return this.ajaxMah;
    }

    private void _mergeAjaxMissingAuthenticationHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_MISSING_AUTHENTICATION_AJAX)) {
            this.ajaxMah = config.ajaxMah;
        }
    }

    protected T csrfCheckFailureHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.csrfCheckFailureHandler = handler;
        return this.me();
    }

    public MissingAuthenticationHandler csrfCheckFailureHandler() {
        if (null == this.csrfCheckFailureHandler) {
            this.csrfCheckFailureHandler = this.get(AppConfigKey.HANDLER_CSRF_CHECK_FAILURE, this.missingAuthenticationHandler());
        }
        return this.csrfCheckFailureHandler;
    }

    private void _mergeCsrfCheckFailureHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_CSRF_CHECK_FAILURE)) {
            this.csrfCheckFailureHandler = config.csrfCheckFailureHandler;
        }
    }

    protected T ajaxCsrfCheckFailureHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.ajaxCsrfCheckFailureHandler = handler;
        return this.me();
    }

    public MissingAuthenticationHandler ajaxCsrfCheckFailureHandler() {
        if (null == this.ajaxCsrfCheckFailureHandler) {
            this.ajaxCsrfCheckFailureHandler = this.get(AppConfigKey.HANDLER_AJAX_CSRF_CHECK_FAILURE, this.csrfCheckFailureHandler());
        }
        return this.ajaxCsrfCheckFailureHandler;
    }

    private void _mergeAjaxCsrfCheckFailureHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_AJAX_CSRF_CHECK_FAILURE)) {
            this.csrfCheckFailureHandler = config.csrfCheckFailureHandler;
        }
    }

    protected T threadLocalBufRetentionLimit(int limit) {
        this.threadlocalBufRetentionLimit = limit;
        return this.me();
    }

    public int threadLocalBufRetentionLimit() {
        if (null == this.threadlocalBufRetentionLimit) {
            StrBufRetentionLimitCalculator calc = new StrBufRetentionLimitCalculator();
            this.threadlocalBufRetentionLimit = this.get(AppConfigKey.OSGL_THREADLOCAL_BUF_LIMIT, 1024 * calc.calculate());
        }
        return this.threadlocalBufRetentionLimit;
    }

    private void _mergeStrBufRetentionLimit(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.OSGL_THREADLOCAL_BUF_LIMIT)) {
            this.threadlocalBufRetentionLimit = config.threadlocalBufRetentionLimit;
        }
    }

    protected T defPasswordValidator(Password.Validator validator) {
        this.defPasswordValidator = (Password.Validator)$.notNull((Object)validator);
        return this.me();
    }

    protected T defPasswordSpec(String spec) {
        this._defPasswordSpec(spec);
        return this.me();
    }

    public Password.Validator defPasswordValidator() {
        if (null == this.defPasswordValidator) {
            String s = this.get(AppConfigKey.PASSWORD_DEF_SPEC, Act.isDev() ? "a[3,]" : "aA0[6,]");
            this._defPasswordSpec(s);
        }
        return this.defPasswordValidator;
    }

    private void _defPasswordSpec(String spec) {
        try {
            this.defPasswordValidator = PasswordSpec.parse(spec);
        }
        catch (IllegalArgumentException e) {
            try {
                this.defPasswordValidator = (Password.Validator)this.app.getInstance(spec);
            }
            catch (Exception e2) {
                throw new ConfigurationException("Password spec unrecognized: " + spec);
            }
        }
    }

    protected T namedPorts(NamedPort ... namedPorts) {
        this.namedPorts = C.listOf((Object[])namedPorts);
        return this.me();
    }

    public List<NamedPort> namedPorts() {
        if (null == this.namedPorts) {
            String s = this.get(AppConfigKey.NAMED_PORTS, null);
            if (null == s) {
                this.namedPorts = this.cliOverHttp() ? C.list((Object)new NamedPort(PORT_CLI_OVER_HTTP, this.cliOverHttpPort())) : C.list();
            } else {
                String[] sa = s.split("[,;]+");
                ListBuilder builder = ListBuilder.create();
                for (String s0 : sa) {
                    String[] sa0 = s0.split(":");
                    E.invalidConfigurationIf((2 != sa0.length ? 1 : 0) != 0, (String)"Unknown named port configuration: %s", (Object[])new Object[]{s});
                    String name = sa0[0].trim();
                    String val = sa0[1].trim();
                    NamedPort port = new NamedPort(name, Integer.parseInt(val));
                    if (builder.contains((Object)port)) {
                        throw E.invalidConfiguration((String)"port[%s] already configured", (Object[])new Object[]{name});
                    }
                    builder.add((Object)port);
                }
                if (this.cliOverHttp()) {
                    builder.add((Object)new NamedPort(PORT_CLI_OVER_HTTP, this.cliOverHttpPort()));
                }
                this.namedPorts = builder.toList();
            }
        }
        return this.namedPorts;
    }

    public NamedPort namedPort(String portId) {
        for (NamedPort np : this.namedPorts()) {
            if (!np.name().equalsIgnoreCase(portId)) continue;
            return np;
        }
        return null;
    }

    private void _mergePorts(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.NAMED_PORTS)) {
            this.namedPorts = config.namedPorts;
        }
    }

    protected T encoding(String encoding) {
        E.illegalArgumentIf(((encoding = encoding.trim()).length() == 0 ? 1 : 0) != 0, (String)"encoding cannot be empty");
        this.encoding = encoding;
        return this.me();
    }

    public String encoding() {
        if (null == this.encoding) {
            this.encoding = this.get(AppConfigKey.ENCODING, StandardCharsets.UTF_8.name());
        }
        return this.encoding;
    }

    private void _mergeEncoding(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ENCODING)) {
            this.encoding = conf.encoding;
        }
    }

    protected T dateFormat(String fmt) {
        E.illegalArgumentIf((boolean)S.blank((String)fmt), (String)"Date format cannot be empty");
        this.dateFmt = fmt;
        return this.me();
    }

    public String dateFormat() {
        if (null == this.dateFmt) {
            this.dateFmt = this.get(AppConfigKey.FORMAT_DATE, ((SimpleDateFormat)DateFormat.getDateInstance()).toPattern());
        }
        return this.dateFmt;
    }

    private void _mergeDateFmt(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.FORMAT_DATE)) {
            this.dateFmt = conf.dateFmt;
        }
    }

    protected T timeFormat(String fmt) {
        E.illegalArgumentIf((boolean)S.blank((String)fmt), (String)"Time format cannot be empty");
        this.timeFmt = fmt;
        return this.me();
    }

    public String timeFormat() {
        if (null == this.timeFmt) {
            this.timeFmt = this.get(AppConfigKey.FORMAT_TIME, ((SimpleDateFormat)DateFormat.getTimeInstance()).toPattern());
        }
        return this.timeFmt;
    }

    private void _mergeTimeFmt(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.FORMAT_TIME)) {
            this.timeFmt = conf.timeFmt;
        }
    }

    protected T dateTimeFormat(String fmt) {
        E.illegalArgumentIf((boolean)S.blank((String)fmt), (String)"Date time format cannot be empty");
        this.dateDateTimeFmt = fmt;
        return this.me();
    }

    public String dateTimeFormat() {
        if (null == this.dateDateTimeFmt) {
            this.dateDateTimeFmt = this.get(AppConfigKey.FORMAT_DATE_TIME, ((SimpleDateFormat)DateFormat.getDateTimeInstance()).toPattern());
        }
        return this.dateDateTimeFmt;
    }

    private void _mergeDateTimeFmt(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.FORMAT_DATE_TIME)) {
            this.dateDateTimeFmt = conf.dateDateTimeFmt;
        }
    }

    protected T locale(Locale locale) {
        E.NPE((Object)locale);
        this.locale = locale;
        return this.me();
    }

    public Locale locale() {
        if (null == this.locale) {
            this.locale = this.get(AppConfigKey.LOCALE, Locale.getDefault());
        }
        return this.locale;
    }

    private void _mergeLocale(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.LOCALE)) {
            this.locale = conf.locale;
        }
    }

    protected T sourceVersion(JavaVersion version) {
        this.sourceVersion = ((FastStr)FastStr.of((String)version.name()).substr(1)).replace('_', '.').toString();
        return this.me();
    }

    public String sourceVersion() {
        if (null == this.sourceVersion) {
            this.sourceVersion = this.get(AppConfigKey.SOURCE_VERSION, "1." + $.JAVA_VERSION);
            if (this.sourceVersion.startsWith("1.")) {
                this.sourceVersion = this.sourceVersion.substring(0, 3);
            }
        }
        return this.sourceVersion;
    }

    private void _mergeSourceVersion(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.SOURCE_VERSION)) {
            this.sourceVersion = conf.sourceVersion;
        }
    }

    protected T targetVersion(JavaVersion version) {
        this.targetVersion = ((FastStr)FastStr.of((String)version.name()).substr(1)).replace('_', '.').toString();
        return this.me();
    }

    public String targetVersion() {
        if (null == this.targetVersion) {
            this.targetVersion = this.get(AppConfigKey.TARGET_VERSION, "1." + $.JAVA_VERSION);
            if (this.targetVersion.startsWith("1.")) {
                this.targetVersion = this.targetVersion.substring(0, 3);
            }
        }
        return this.targetVersion;
    }

    private void _mergeTargetVersion(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.TARGET_VERSION)) {
            this.targetVersion = conf.targetVersion;
        }
    }

    public Lang.Predicate<String> appClassTester() {
        if (null == this.APP_CLASS_TESTER) {
            String[] sp;
            int len;
            String scanPackage = this.get(AppConfigKey.SCAN_PACKAGE, null);
            this.APP_CLASS_TESTER = S.isBlank((String)scanPackage) ? this.SYSTEM_SCAN_LIST : (1 == (len = (sp = scanPackage.trim().split("[\\s,;:]+")).length) ? S.F.startsWith((String)sp[0]).or(new Lang.Function[]{this.SYSTEM_SCAN_LIST}) : new Lang.Predicate<String>(){

                public boolean test(String className) {
                    for (int i = 0; i < len; ++i) {
                        if (!className.startsWith(sp[i])) continue;
                        return true;
                    }
                    return false;
                }
            }.or(new Lang.Function[]{this.SYSTEM_SCAN_LIST}));
        }
        return this.APP_CLASS_TESTER;
    }

    public boolean needEnhancement(String className) {
        return this.appClassTester().test((Object)className) || this.controllerNameTester().test((Object)className);
    }

    private Lang.Predicate<String> controllerNameTester() {
        if (null == this.CONTROLLER_CLASS_TESTER) {
            Lang.Predicate f2 = Lang.F.no();
            this.CONTROLLER_CLASS_TESTER = f2.or(new Lang.Function[]{this.app().router().f.IS_CONTROLLER});
        }
        return this.CONTROLLER_CLASS_TESTER;
    }

    protected T templatePathResolver(TemplatePathResolver resolver) {
        E.NPE((Object)resolver);
        this.templatePathResolver = resolver;
        return this.me();
    }

    public TemplatePathResolver templatePathResolver() {
        if (null == this.templatePathResolver) {
            this.templatePathResolver = this.get(AppConfigKey.RESOLVER_TEMPLATE_PATH, new TemplatePathResolver());
        }
        return this.templatePathResolver;
    }

    private void _mergeTemplatePathResolver(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RESOLVER_TEMPLATE_PATH)) {
            this.templatePathResolver = conf.templatePathResolver;
        }
    }

    protected T templateHome(String home) {
        E.illegalArgumentIf(((home = home.trim()).length() == 0 ? 1 : 0) != 0, (String)"template home cannot be empty");
        this.templateHome = home;
        return this.me();
    }

    public String templateHome() {
        if (null == this.templateHome) {
            this.templateHome = this.get(AppConfigKey.TEMPLATE_HOME, "default");
        }
        return this.templateHome;
    }

    private void _mergeTemplateHome(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.TEMPLATE_HOME)) {
            this.templateHome = conf.templateHome;
        }
    }

    protected T pingPath(String path) {
        this.pingPathResolved = true;
        this.pingPath = path.trim();
        return this.me();
    }

    public String pingPath() {
        if (!this.pingPathResolved) {
            this.pingPath = this.get(AppConfigKey.PING_PATH, null);
            this.pingPathResolved = true;
        }
        return this.pingPath;
    }

    private void _mergePingPath(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.PING_PATH)) {
            this.pingPath = config.pingPath;
            this.pingPathResolved = config.pingPathResolved;
        }
    }

    protected T requestThrottle(int throttle) {
        E.illegalArgumentIf((throttle < 1 ? 1 : 0) != 0, (String)"request throttle must be positive integer");
        this.reqThrottle = throttle;
        return this.me();
    }

    public int requestThrottle() {
        if (null == this.reqThrottle) {
            this.reqThrottle = this.get(AppConfigKey.REQUEST_THROTTLE, 2);
        }
        return this.reqThrottle;
    }

    private void _mergeReqThrottle(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.REQUEST_THROTTLE)) {
            this.reqThrottle = config.reqThrottle;
        }
    }

    protected T requestThrottleExpireScale(boolean enabled) {
        this.reqThrottleExpireScale = enabled;
        return this.me();
    }

    public boolean requestThrottleExpireScale() {
        if (null == this.reqThrottleExpireScale) {
            this.reqThrottleExpireScale = this.get(AppConfigKey.REQUEST_THROTTLE_EXPIRE_SCALE, false);
        }
        return this.reqThrottleExpireScale;
    }

    private void _mergeReqThrottleExpireScale(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.REQUEST_THROTTLE_EXPIRE_SCALE)) {
            this.reqThrottleExpireScale = config.reqThrottleExpireScale;
        }
    }

    protected T renderJsonContentTypeIE(String contentType) {
        this.setRenderJsonContenTypeIE(contentType);
        return this.me();
    }

    private void setRenderJsonContenTypeIE(String contentType) {
        if (H.Format.JSON.contentType().equalsIgnoreCase(contentType)) {
            this.renderJsonIeFix = false;
            return;
        }
        this.renderJsonIeFix = true;
        this.jsonIE = H.Format.of((String)"json_ie", (String)contentType);
        this.jsonContentTypeProvider = new Lang.Func0<H.Format>(){

            public H.Format apply() throws NotAppliedException, Lang.Break {
                UserAgent ua;
                ActionContext context = ActionContext.current();
                if (null != context && (ua = context.userAgent()).isIE()) {
                    return AppConfig.this.jsonIE;
                }
                return H.Format.JSON;
            }
        };
    }

    public Lang.Func0<H.Format> jsonContentTypeProvider() {
        if (null == this.renderJsonIeFix) {
            String contentType = this.get(AppConfigKey.RENDER_JSON_CONTENT_TYPE_IE, null);
            if (null != contentType) {
                this.setRenderJsonContenTypeIE(contentType);
            } else {
                this.renderJsonIeFix = false;
            }
        }
        return this.renderJsonIeFix != false ? this.jsonContentTypeProvider : null;
    }

    private void _mergeRenderJsonContentTypeIE(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RENDER_JSON_CONTENT_TYPE_IE)) {
            this.jsonContentTypeProvider = conf.jsonContentTypeProvider;
            this.renderJsonIeFix = conf.renderJsonIeFix;
            this.jsonIE = conf.jsonIE;
        }
    }

    protected T renderJsonOutputCharset(boolean outputCharset) {
        this.renderJsonOutputCharset = outputCharset;
        return this.me();
    }

    public boolean renderJsonOutputCharset() {
        if (null == this.renderJsonOutputCharset) {
            this.renderJsonOutputCharset = this.get(AppConfigKey.RENDER_JSON_OUTPUT_CHARSET, false);
        }
        return this.renderJsonOutputCharset;
    }

    private void _mergeRenderJsonOutputCharset(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.RENDER_JSON_OUTPUT_CHARSET)) {
            this.renderJsonOutputCharset = config.renderJsonOutputCharset;
        }
    }

    protected T serverHeader(String header) {
        this.serverHeader = header;
        return this.me();
    }

    public String serverHeader() {
        if (null == this.serverHeader) {
            this.serverHeader = this.get(AppConfigKey.SERVER_HEADER, DEF_SERVER_HEADER);
        }
        return this.serverHeader;
    }

    private void _mergeServerHeader(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SERVER_HEADER)) {
            this.serverHeader = config.serverHeader;
        }
    }

    protected T sessionKeyUsername(String name) {
        E.illegalArgumentIf(((name = name.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"session cookie name cannot be blank");
        this.sessionKeyUsername = name;
        return this.me();
    }

    public String sessionKeyUsername() {
        if (null == this.sessionKeyUsername) {
            this.sessionKeyUsername = this.get(AppConfigKey.SESSION_KEY_USERNAME, "username");
        }
        return this.sessionKeyUsername;
    }

    private void _mergeSessionKeyUsername(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_KEY_USERNAME)) {
            this.sessionKeyUsername = config.sessionKeyUsername;
        }
    }

    protected T cookiePrefix(String prefix) {
        E.illegalArgumentIf(((prefix = prefix.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"cookie prefix cannot be blank");
        this.cookiePrefix = prefix;
        return this.me();
    }

    private String cookiePrefix() {
        if (null == this.cookiePrefix) {
            this.cookiePrefix = this.get(AppConfigKey.COOKIE_PREFIX, S.concat((String)this.app().shortId(), (String)"-"));
            this.cookiePrefix = this.cookiePrefix.trim().toLowerCase();
            this.set(AppConfigKey.COOKIE_PREFIX, this.cookiePrefix);
        }
        return this.cookiePrefix;
    }

    private void _mergeCookiePrefix(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.COOKIE_PREFIX)) {
            this.cookiePrefix = config.cookiePrefix;
        }
    }

    protected T sessionCookieName(String name) {
        E.illegalArgumentIf(((name = name.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"session cookie name cannot be blank");
        E.illegalArgumentIf((boolean)S.eq((String)name, (String)this.flashCookieName), (String)"session cookie name cannot be the same with flash cookie name");
        this.sessionCookieName = name;
        return this.me();
    }

    public String sessionCookieName() {
        if (null == this.sessionCookieName) {
            this.sessionCookieName = this.cookieName("session");
        }
        return this.sessionCookieName;
    }

    private void _mergeSessionCookieName(AppConfig config) {
        if (null != config.sessionCookieName) {
            this.sessionCookieName = config.sessionCookieName;
        }
    }

    protected T flashCookieName(String name) {
        E.illegalArgumentIf(((name = name.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"flash cookie name cannot be blank");
        E.illegalArgumentIf((boolean)S.eq((String)name, (String)this.sessionCookieName), (String)"flash cookie name cannot be the same with session cookie name");
        this.flashCookieName = name;
        return this.me();
    }

    public String flashCookieName() {
        if (null == this.flashCookieName) {
            this.flashCookieName = this.cookieName("flash");
        }
        return this.flashCookieName;
    }

    private void _mergeFlashCookieName(AppConfig config) {
        if (null != config.flashCookieName) {
            this.flashCookieName = config.flashCookieName;
        }
    }

    protected T sessionTtl(int seconds) {
        this.sessionTtl = seconds;
        return this.me();
    }

    public int sessionTtl() {
        if (null == this.sessionTtl) {
            this.sessionTtl = this.get(AppConfigKey.SESSION_TTL, 1800);
        }
        return this.sessionTtl;
    }

    private void _mergeSessionTtl(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_TTL)) {
            this.sessionTtl = conf.sessionTtl;
        }
    }

    protected T sessionPersistent(boolean persistenSession) {
        this.sessionPersistent = persistenSession;
        return this.me();
    }

    public boolean persistSession() {
        if (null == this.sessionPersistent) {
            this.sessionPersistent = this.get(AppConfigKey.SESSION_PERSISTENT_ENABLED, false);
        }
        return this.sessionPersistent;
    }

    private void _mergeSessionPersistent(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_PERSISTENT_ENABLED)) {
            this.sessionPersistent = config.sessionPersistent;
        }
    }

    protected T sessionEncrypt(boolean encryptSession) {
        this.sessionEncrypt = encryptSession;
        return this.me();
    }

    public boolean encryptSession() {
        if (null == this.sessionEncrypt) {
            this.sessionEncrypt = this.get(AppConfigKey.SESSION_ENCRYPT_ENABLED, false);
        }
        return this.sessionEncrypt;
    }

    private void _mergeSessionEncrpt(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_ENCRYPT_ENABLED)) {
            this.sessionEncrypt = config.sessionEncrypt;
        }
    }

    protected void sessionMapper(SessionMapper sessionMapper) {
        this.sessionMapper = sessionMapper;
    }

    public SessionMapper sessionMapper() {
        if (null == this.sessionMapper) {
            this.sessionMapper = this.get(AppConfigKey.SESSION_MAPPER, this.app().getInstance(CookieSessionMapper.class));
        }
        return this.sessionMapper;
    }

    private void _mergeSessionMapper(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_MAPPER)) {
            this.sessionMapper = config.sessionMapper;
        }
    }

    protected void sessionCodec(SessionCodec codec) {
        this.sessionCodec = (SessionCodec)$.notNull((Object)codec);
    }

    public SessionCodec sessionCodec() {
        if (null == this.sessionCodec) {
            this.sessionCodec = this.get(AppConfigKey.SESSION_CODEC, this.app.getInstance(DefaultSessionCodec.class));
        }
        return this.sessionCodec;
    }

    private void _mergeSessionCodec(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_CODEC)) {
            this.sessionCodec = config.sessionCodec;
        }
    }

    protected T sessionOutputExpiration(boolean enabled) {
        this.sessionOutputExpiration = enabled;
        return this.me();
    }

    public boolean sessionOutputExpiration() {
        if (null == this.sessionOutputExpiration) {
            this.sessionOutputExpiration = this.get(AppConfigKey.SESSION_OUTPUT_EXPIRATION, true);
        }
        return this.sessionOutputExpiration;
    }

    protected T sessionHeader(String header) {
        this.sessionHeader = header;
        this.sessionHeaderSet = true;
        return this.me();
    }

    public String sessionHeader() {
        if (!this.sessionHeaderSet) {
            this.sessionHeader = this.get(AppConfigKey.SESSION_HEADER, null);
            this.sessionHeaderSet = true;
        }
        return this.sessionHeader;
    }

    private void _mergeSessionHeader(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_HEADER)) {
            this.sessionHeader = conf.sessionHeader;
            this.sessionHeaderSet = conf.sessionHeaderSet;
        }
    }

    protected T sessionHeaderPrefix(String prefix) {
        this.sessionHeaderPrefix = prefix;
        return this.me();
    }

    public String sessionHeaderPrefix() {
        if (null == this.sessionHeaderPrefix) {
            this.sessionHeaderPrefix = this.get(AppConfigKey.SESSION_HEADER_PREFIX, "X-Act-");
        }
        return this.sessionHeaderPrefix;
    }

    protected void sessionHeaderPayloadPrefix(String prefix) {
        this.sessionHeaderPayloadPrefix = prefix;
    }

    public String sessionHeaderPayloadPrefix() {
        if (null == this.sessionHeaderPayloadPrefix) {
            this.sessionHeaderPayloadPrefix = this.get(AppConfigKey.SESSION_HEADER_PAYLOAD_PREFIX, "");
        }
        return this.sessionHeaderPayloadPrefix;
    }

    private void _mergeSessionHeaderPayloadPrefix(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_HEADER_PAYLOAD_PREFIX)) {
            this.sessionHeaderPayloadPrefix = config.sessionHeaderPayloadPrefix;
        }
    }

    protected T sessionSecure(boolean secure) {
        this.sessionSecure = secure;
        return this.me();
    }

    public boolean sessionSecure() {
        if (null == this.sessionSecure) {
            this.sessionSecure = this.get(AppConfigKey.SESSION_SECURE, this.httpSecure());
        }
        return this.sessionSecure;
    }

    private void _mergeSessionSecure(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_SECURE)) {
            this.sessionSecure = config.sessionSecure;
        }
    }

    protected T secret(String secret) {
        E.illegalArgumentIf((boolean)S.blank((String)secret));
        this.secret = secret;
        return this.me();
    }

    public String secret() {
        if (null == this.secret) {
            this.secret = this.get(AppConfigKey.SECRET, "myawesomeapp");
            if ("myawesomeapp".equals(this.secret)) {
                this.logger.warn("Application secret key not set! You are in the dangerous zone!!!");
            }
        }
        return this.secret;
    }

    private void _mergeSecret(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SECRET)) {
            this.secret = config.secret;
        }
    }

    protected T secretRotate(boolean enabled) {
        this.secretRotate = enabled;
        return this.me();
    }

    public boolean rotateSecret() {
        if (null == this.secretRotate) {
            this.secretRotate = this.get(AppConfigKey.SECRET_ROTATE, false);
        }
        return this.secretRotate;
    }

    private void _mergeSecretRotate(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SECRET_ROTATE)) {
            this.secretRotate = config.secretRotate;
        }
    }

    protected T secretRotatePeroid(int period) {
        E.illegalArgumentIf((period < 1 ? 1 : 0) != 0, (String)"minimum secret.rotate.period is 1 (minute)");
        this.secretRotatePeriod = period;
        return this.me();
    }

    public int secretRotatePeriod() {
        if (null == this.secretRotatePeriod) {
            int minutes;
            boolean validSetting = true;
            String s = this.get(AppConfigKey.SECRET_ROTATE_PERIOD, "30");
            if (!N.isInt((String)s)) {
                int seconds = Time.parseDuration((String)s);
                int reminder = seconds % 60;
                if (0 != reminder) {
                    validSetting = false;
                    seconds += 60 - reminder;
                }
                minutes = seconds / 60;
            } else {
                minutes = Integer.parseInt(s);
            }
            if (minutes <= 0) {
                validSetting = false;
                minutes = 30;
            }
            this.secretRotatePeriod = RotationSecretProvider.roundToPeriod(minutes);
            boolean bl = validSetting = validSetting && this.secretRotatePeriod == minutes;
            if (!validSetting) {
                this.warn("invalid secret.rotate.period setting found: %s, system automatically set it to: %s", s, this.secretRotatePeriod);
            }
        }
        return this.secretRotatePeriod;
    }

    private void _mergeSecretRotatePeriod(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SECRET_ROTATE_PERIOD)) {
            this.secretRotatePeriod = config.secretRotatePeriod;
        }
    }

    protected T secureTicketCodec(String secureTicketCodecClass) {
        this.secureTicketCodecClass = (String)$.notNull((Object)secureTicketCodecClass);
        return this.me();
    }

    protected T secureTicketCodec(SecureTicketCodec codec) {
        this.secureTicketCodec = (SecureTicketCodec)$.notNull((Object)codec);
        return this.me();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureTicketCodec secureTicketCodec() {
        if (null != this.secureTicketCodec) {
            return this.secureTicketCodec;
        }
        AppConfig appConfig = this;
        synchronized (appConfig) {
            if (null != this.secureTicketCodec) {
                return this.secureTicketCodec;
            }
            if (null == this.secureTicketCodecClass) {
                this.secureTicketCodecClass = this.get(AppConfigKey.SECURE_TICKET_CODEC, null);
                if (null == this.secureTicketCodecClass) {
                    this.secureTicketCodec = this.app().getInstance(DefaultSecureTicketCodec.class);
                    return this.secureTicketCodec;
                }
                if ("username".equalsIgnoreCase(this.secureTicketCodecClass)) {
                    this.secureTicketCodec = this.app().getInstance(UsernameSecureTicketCodec.class);
                    return this.secureTicketCodec;
                }
                this.secureTicketCodec = (SecureTicketCodec)this.app().getInstance(this.secureTicketCodecClass);
            }
        }
        return this.secureTicketCodec;
    }

    private void _mergeSecureTicketCodec(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SECURE_TICKET_CODEC)) {
            this.secureTicketCodec = config.secureTicketCodec;
            this.secureTicketCodecClass = config.secureTicketCodecClass;
        }
    }

    protected T traceHandler(boolean enabled) {
        this.traceHandler = enabled;
        return this.me();
    }

    public boolean traceHandler() {
        if (null == this.traceHandler) {
            this.traceHandler = this.get(AppConfigKey.TRACE_HANDLER_ENABLED, false);
        }
        return this.traceHandler;
    }

    private void _mergeTraceHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.TRACE_HANDLER_ENABLED)) {
            this.traceHandler = config.traceHandler;
        }
    }

    protected T traceRequests(boolean enabled) {
        this.traceRequest = enabled;
        return this.me();
    }

    public boolean traceRequests() {
        if (null == this.traceRequest) {
            this.traceRequest = this.get(AppConfigKey.TRACE_REQUEST_ENABLED, false);
        }
        return this.traceRequest;
    }

    private void _mergeTraceRequests(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.TRACE_REQUEST_ENABLED)) {
            this.traceRequest = config.traceRequest;
        }
    }

    public List<File> moduleBases() {
        if (null == this.moduleBases) {
            String v = this.get(AppConfigKey.MODULES, null);
            this.moduleBases = this.processModules(v);
        }
        return this.moduleBases;
    }

    private List<File> processModules(String v) {
        if (S.blank((String)v)) {
            return C.list();
        }
        ArrayList<File> files = new ArrayList<File>();
        File base = this.app.base();
        for (String s : v.trim().split("[;:]+")) {
            File file = (s = s.trim()).startsWith("/") || s.startsWith("\\") ? new File(s) : ProjectLayout.Utils.file(base, s);
            if (!file.isDirectory()) {
                this.logger.warn("Cannot locate extra source dir: %s", new Object[]{s});
                continue;
            }
            files.add(file);
        }
        return C.list(files);
    }

    protected T metricEnable(boolean enable) {
        this.metricEnabled = enable;
        return this.me();
    }

    public boolean metricEnabled() {
        if (null == this.metricEnabled) {
            this.metricEnabled = this.get(AppConfigKey.METRIC_ENABLED, true);
        }
        return this.metricEnabled;
    }

    private void _mergeMetricEnabled(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.METRIC_ENABLED)) {
            this.metricEnabled = conf.metricEnabled;
        }
    }

    public boolean possibleControllerClass(String className) {
        return this.appClassTester().test((Object)className);
    }

    protected T cacheService(CacheServiceProvider provider) {
        E.NPE((Object)provider);
        this.cacheServiceProvider = provider;
        return this.me();
    }

    protected T cacheService(Class<? extends CacheServiceProvider> provider) {
        this.cacheServiceProvider = (CacheServiceProvider)$.newInstance(provider);
        return this.me();
    }

    public CacheService cacheService(String name) {
        if (null == this.cacheServiceProvider) {
            CacheServiceProvider.Impl.setClassLoader((ClassLoader)this.app().classLoader());
            try {
                this.cacheServiceProvider = this.get(AppConfigKey.CACHE_IMPL, null);
            }
            catch (ConfigurationException e) {
                Object obj = AppConfigKey.helper.getValFromAliases(this.raw, AppConfigKey.CACHE_IMPL.toString(), "impl", null);
                this.cacheServiceProvider = CacheServiceProvider.Impl.valueOfIgnoreCase((String)obj.toString());
                if (null != this.cacheServiceProvider) {
                    this.set(AppConfigKey.CACHE_IMPL, this.cacheServiceProvider);
                    return this.cacheServiceProvider.get(name);
                }
                throw e;
            }
            if (null == this.cacheServiceProvider) {
                this.cacheServiceProvider = CacheServiceProvider.Impl.Auto;
            }
        }
        return this.cacheServiceProvider.get(name);
    }

    private void _mergeCacheServiceProvider(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CACHE_IMPL)) {
            this.cacheServiceProvider = config.cacheServiceProvider;
        }
    }

    protected T cacheName(String name) {
        this._cacheName = name;
        return this.me();
    }

    public String cacheName() {
        if (null == this._cacheName) {
            this._cacheName = this.get(AppConfigKey.CACHE_NAME, "_act_app_");
        }
        return this._cacheName;
    }

    private void _mergeCacheName(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CACHE_NAME)) {
            this._cacheName = config._cacheName;
        }
    }

    protected T cacheNameSession(String name) {
        this._cacheNameSession = name;
        return this.me();
    }

    public String cacheNameSession() {
        if (null == this._cacheNameSession) {
            this._cacheNameSession = this.get(AppConfigKey.CACHE_NAME_SESSION, this.cacheName());
        }
        return this._cacheNameSession;
    }

    protected T unknownHttpMethodProcessor(UnknownHttpMethodProcessor handler) {
        this._unknownHttpMethodProcessor = (UnknownHttpMethodProcessor)$.notNull((Object)handler);
        return this.me();
    }

    public UnknownHttpMethodProcessor unknownHttpMethodProcessor() {
        if (null == this._unknownHttpMethodProcessor) {
            this._unknownHttpMethodProcessor = this.get(AppConfigKey.HANDLER_UNKNOWN_HTTP_METHOD, UnknownHttpMethodProcessor.METHOD_NOT_ALLOWED);
        }
        return this._unknownHttpMethodProcessor;
    }

    private void _mergeUnknownHttpMethodHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_UNKNOWN_HTTP_METHOD)) {
            this._unknownHttpMethodProcessor = config._unknownHttpMethodProcessor;
        }
    }

    protected T resourcePreloadSizeLimit(int limit) {
        this.resourcePreloadSizeLimit = limit;
        return this.me();
    }

    public int resourcePreloadSizeLimit() {
        if (null == this.resourcePreloadSizeLimit) {
            this.resourcePreloadSizeLimit = this.get(AppConfigKey.RESOURCE_PRELOAD_SIZE_LIMIT, 10240);
            if (this.resourcePreloadSizeLimit <= 0) {
                this.logger.warn("resource.preload.size.limit is set to zero or below, resource preload is disabled!");
            }
        }
        return this.resourcePreloadSizeLimit;
    }

    private void _mergeResourcePreloadSizeLimit(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RESOURCE_PRELOAD_SIZE_LIMIT)) {
            this.resourcePreloadSizeLimit = conf.resourcePreloadSizeLimit;
        }
    }

    protected T uploadInMemoryCacheThreshold(int l) {
        this.uploadInMemoryCacheThreshold = l;
        return this.me();
    }

    public int uploadInMemoryCacheThreshold() {
        if (null == this.uploadInMemoryCacheThreshold) {
            this.uploadInMemoryCacheThreshold = this.get(AppConfigKey.UPLOAD_IN_MEMORY_CACHE_THRESHOLD, 10240);
        }
        return this.uploadInMemoryCacheThreshold;
    }

    private void _mergeUploadInMemoryCacheThreshold(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.UPLOAD_IN_MEMORY_CACHE_THRESHOLD)) {
            this.uploadInMemoryCacheThreshold = config.uploadInMemoryCacheThreshold;
        }
    }

    protected T supportSsl(boolean b) {
        this.ssl = b;
        return this.me();
    }

    public boolean supportSsl() {
        if (null == this.ssl) {
            this.ssl = this.get(AppConfigKey.SSL, false);
        }
        return this.ssl;
    }

    private void _mergeSslSupport(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SSL)) {
            this.ssl = config.ssl;
        }
    }

    protected T wsTicketeKey(String wsTicketKey) {
        this.wsTicketKey = wsTicketKey;
        return this.me();
    }

    public String wsTicketKey() {
        if (null == this.wsTicketKey) {
            this.wsTicketKey = this.get(AppConfigKey.WS_KEY_TICKET, "ws_ticket");
        }
        return this.wsTicketKey;
    }

    private void _mergeWsTicketKey(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.WS_KEY_TICKET)) {
            this.wsTicketKey = config.wsTicketKey;
        }
    }

    public void loadJarProperties(Map<String, Properties> jarProperties) {
        Properties p0 = jarProperties.remove("common");
        Properties p1 = jarProperties.remove(ConfLoader.confSetName());
        if (null != p1) {
            if (null != p0) {
                p0.putAll((Map<?, ?>)p1);
            } else {
                p0 = p1;
            }
        }
        if (null != p0) {
            this.loadJarProperties(p0);
        }
    }

    private void loadJarProperties(Properties p) {
        Enumeration<?> keys = p.propertyNames();
        while (keys.hasMoreElements()) {
            String key = S.string(keys.nextElement());
            if (this.raw.containsKey(key)) continue;
            this.raw.put(key, p.getProperty(key));
        }
    }

    public void _merge(AppConfigurator conf) {
        this.app.emit(SysEventId.CONFIG_PREMERGE);
        if (this.mergeTracker.contains(conf)) {
            return;
        }
        this.mergeTracker.add(conf);
        for (Method method : AppConfig.class.getDeclaredMethods()) {
            boolean isPrivate = Modifier.isPrivate(method.getModifiers());
            if (!isPrivate || !method.getName().startsWith("_merge")) continue;
            method.setAccessible(true);
            $.invokeVirtual((Object)this, (Method)method, (Object[])new Object[]{conf});
        }
        Set<String> keys = conf.propKeys();
        if (!keys.isEmpty()) {
            for (String k : keys) {
                if (this.raw.containsKey(k)) continue;
                this.raw.put(k, conf.propVal(k));
            }
        }
    }

    @Override
    protected void releaseResources() {
        this.app = null;
        super.releaseResources();
    }

    protected T me() {
        return (T)((AppConfigurator)$.cast((Object)this));
    }

    private String cookieName(String suffix) {
        return S.concat((String)this.cookiePrefix(), (String)suffix);
    }

    static {
        MvcConfig.registerAlarmListener((String)"ALARM_BIG_CONTENT_ENCOUNTERED", (Lang.Func0)new Lang.Func0(){

            public Object apply() throws NotAppliedException, Lang.Break {
                ActionContext ctx = ActionContext.current();
                if (null != ctx) {
                    ctx.setLargeResponseHint();
                }
                return null;
            }
        });
        MvcConfig.errorPageRenderer((ErrorPageRenderer)new ActErrorPageRender());
        MvcConfig.beforeCommitResultHandler(ResultEvent.BEFORE_COMMIT_HANDLER);
        MvcConfig.afterCommitResultHandler(ResultEvent.AFTER_COMMIT_HANDLER);
        MvcConfig.messageTranslater((Lang.Function)new Lang.Transformer<String, String>(){

            public String transform(String message) {
                if (Act.appConfig().i18nEnabled()) {
                    String translated = I18n.i18n(message, new Object[0]);
                    if (message == translated) {
                        message = translated = I18n.i18n(MvcConfig.class, message, new Object[0]);
                    }
                    return message;
                }
                return message;
            }
        });
        DEF_SERVER_HEADER = "act/" + Act.VERSION.getProjectVersion();
    }
}

