/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.Act;
import act.app.ProjectLayout;
import act.conf.AppConfigKey;
import act.conf.Config;
import act.util.LogSupport;
import act.util.SysProps;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.osgl.util.S;

public abstract class ConfLoader<T extends Config>
extends LogSupport {
    public T load() {
        Map<Object, Object> rawConf = new HashMap<Object, Object>();
        Properties sysProps = System.getProperties();
        rawConf.putAll(sysProps);
        rawConf = ConfLoader.processConf(rawConf);
        return this.create(rawConf);
    }

    public T load(File resourceRoot) {
        Map<Object, Object> rawConf = null == resourceRoot ? new HashMap() : this.loadConfFromDisk(resourceRoot);
        Properties sysProps = System.getProperties();
        rawConf.putAll(sysProps);
        rawConf = ConfLoader.processConf(rawConf);
        return this.create(rawConf);
    }

    public static String common() {
        String common = SysProps.get("commonConfTag");
        if (S.blank((String)common)) {
            common = "common";
        }
        return common;
    }

    public static String confSetName() {
        String profile = SysProps.get(AppConfigKey.PROFILE.key());
        if (S.blank((String)profile)) {
            profile = Act.mode().name().toLowerCase();
        }
        return profile;
    }

    protected abstract T create(Map<String, ?> var1);

    protected abstract String confFileName();

    private Map loadConfFromDisk(File conf) {
        if (conf.isDirectory()) {
            return this.loadConfFromDir(conf);
        }
        if (conf.getName().endsWith(".jar")) {
            return this.loadConfFromJar(conf);
        }
        return this.loadConfFromFile(conf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map loadConfFromJar(File jarFile) {
        boolean traceEnabled = this.isTraceEnabled();
        if (traceEnabled) {
            this.trace("loading app conf from jar file: %s", jarFile);
        }
        TreeMap<String, JarEntry> map = new TreeMap<String, JarEntry>(new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                boolean path1IsRoot = path1.contains("/");
                boolean path2IsRoot = path2.contains("/");
                if (path1IsRoot && path2IsRoot) {
                    return path1.compareTo(path2);
                }
                if (path1IsRoot) {
                    return -1;
                }
                if (path2IsRoot) {
                    return 1;
                }
                if (path1.startsWith("conf/")) {
                    path1 = path1.substring(5);
                    path2 = path2.substring(5);
                    return this.compare(path1, path2);
                }
                boolean path1IsCommon = path1.startsWith("common/");
                boolean path2IsCommon = path2.startsWith("common/");
                if (path1IsCommon && path2IsCommon) {
                    return path1.compareTo(path2);
                }
                if (path1IsCommon) {
                    return -1;
                }
                if (path2IsCommon) {
                    return 1;
                }
                return path1.compareTo(path2);
            }
        });
        try (JarFile jar = new JarFile(jarFile);){
            String profile = Act.profile();
            for (JarEntry entry : C.enumerable(jar.entries())) {
                String name = entry.getName();
                if (!this.isAppProperties(name, profile)) continue;
                if (traceEnabled) {
                    this.trace("found jar entry for app properties: %s", name);
                }
                map.put(name, entry);
            }
            HashMap<Object, Object> conf = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Properties p = new Properties();
                try {
                    if (traceEnabled) {
                        this.trace("loading app properties from jar entry: %s", entry.getKey());
                    }
                    p.load(jar.getInputStream((ZipEntry)entry.getValue()));
                    conf.putAll(p);
                }
                catch (IOException e) {
                    this.logger.warn("Error loading %s from jar file: %s", new Object[]{entry.getKey(), jarFile});
                }
            }
            HashMap<Object, Object> hashMap = conf;
            return hashMap;
        }
        catch (IOException e) {
            this.warn(e, "error opening jar file: %s", jarFile);
            return new HashMap();
        }
    }

    private boolean isAppProperties(String name, String profile) {
        if (!name.endsWith(".properties")) {
            return false;
        }
        if (name.startsWith("conf/")) {
            String name0 = name.substring(5);
            if (!name0.contains("/") || name0.startsWith("common")) {
                return true;
            }
            return !S.blank((String)profile) && name0.startsWith(profile + "/");
        }
        return !name.contains("/") && !name.startsWith("act") && !name.startsWith("build.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadConfFromFile(File conf) {
        if (this.isTraceEnabled()) {
            this.trace("loading app conf from file: %s", conf);
        }
        if (!conf.canRead()) {
            this.logger.warn("Cannot read conf file[%s]", new Object[]{conf.getAbsolutePath()});
            return new HashMap();
        }
        InputStream is = IO.is((File)conf);
        Properties p = new Properties();
        try {
            p.load(is);
            Properties properties = p;
            return properties;
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Error loading %s", new Object[]{this.confFileName()});
        }
        finally {
            IO.close((Closeable)is);
        }
        return new HashMap();
    }

    private static Map<String, Object> processConf(Map<String, ?> conf) {
        HashMap<String, Object> m = new HashMap<String, Object>(conf.size());
        for (String s : conf.keySet()) {
            Object o = conf.get(s);
            if (s.startsWith("act.")) {
                s = s.substring(4);
            }
            m.put(s, o);
        }
        return m;
    }

    private Map loadConfFromDir(File resourceDir) {
        if (!resourceDir.exists()) {
            this.logger.warn("Cannot read conf dir[%s]", new Object[]{resourceDir.getAbsolutePath()});
            return new HashMap();
        }
        HashMap map = new HashMap();
        map.putAll(this.loadConfFromDir_(resourceDir));
        File confDir = ProjectLayout.Utils.file(resourceDir, "/conf");
        map.putAll(this.loadConfFromDir_(confDir));
        String common = ConfLoader.common();
        File commonConfDir = new File(confDir, common);
        if (commonConfDir.isDirectory()) {
            map.putAll(this.loadConfFromDir_(commonConfDir));
        }
        String profile = ConfLoader.confSetName();
        this.logger.debug("Loading conf profile: %s", new Object[]{profile});
        File taggedConfDir = new File(confDir, profile);
        if (taggedConfDir.exists() && taggedConfDir.isDirectory()) {
            map.putAll(this.loadConfFromDir_(taggedConfDir));
        }
        return map;
    }

    private Map loadConfFromDir_(File confDir) {
        File[] confFiles = confDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties") || name.endsWith(".conf");
            }
        });
        if (null == confFiles) {
            return C.Map((Object[])new Object[0]);
        }
        HashMap map = new HashMap();
        int n = confFiles.length;
        for (int i = 0; i < n; ++i) {
            map.putAll(this.loadConfFromFile(confFiles[i]));
        }
        return map;
    }
}

