/*
 * Decompiled with CFR 0.152.
 */
package act.controller;

import act.ActResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.osgl.util.Charsets;

public class WriterCache
extends Writer {
    private StringWriter tee = new StringWriter();
    private Writer out;
    private ByteBuffer buffer;

    public WriterCache(Writer out) {
        this.out = out;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.tee.write(cbuf, off, len);
        this.out.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        byte[] ba = this.tee.toString().getBytes(Charsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocateDirect(ba.length);
        buffer.put(ba);
        buffer.flip();
        this.buffer = buffer;
        this.out.close();
    }

    void apply(ActResponse resp) {
        resp.writeContent(this.buffer.duplicate());
    }
}

