/*
 * Decompiled with CFR 0.152.
 */
package act.controller.builtin;

import act.app.ActionContext;
import act.cli.CliDispatcher;
import act.cli.CliOverHttpAuthority;
import act.cli.CliOverHttpContext;
import act.conf.AppConfig;
import act.controller.Controller;
import act.handler.CliHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.osgl.http.H;
import org.osgl.mvc.annotation.Before;
import org.osgl.mvc.annotation.GetAction;
import org.osgl.mvc.annotation.PostAction;
import org.osgl.mvc.result.Result;

@Controller(port={"__admin__"})
public class CliOverHttp {
    private static final int MRU_LIMIT = 8;
    @Inject
    CliDispatcher dispatcher;
    @Inject
    H.Session session;
    @Inject
    AppConfig config;

    @Before
    public void before(AppConfig config) {
        CliOverHttpAuthority authority = config.cliOverHttpAuthority();
        authority.authorize();
    }

    @GetAction
    public Result home(AppConfig config) {
        String title = config.cliOverHttpTitle();
        boolean showSysCmd = config.cliOverHttpSysCmdEnabled();
        return Controller.Util.render(this.dispatcher, this.mru(), title, showSysCmd);
    }

    @GetAction(value={"cmd"})
    public Result cmdPanel(String cmd) {
        CliHandler handler = this.handler(cmd);
        return Controller.Util.render(handler, this.dispatcher, cmd);
    }

    @PostAction(value={"cmd"})
    public Result run(String cmd, ActionContext context) throws IOException {
        CliHandler handler = this.handler(cmd);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CliOverHttpContext cliContext = new CliOverHttpContext(context, os);
        handler.handle(cliContext);
        cliContext.flush();
        String txt = new String(os.toByteArray(), "UTF-8");
        txt = txt.replace("^J", "\n");
        return Controller.Util.text(txt, new Object[0]);
    }

    private List<String> mru() {
        ArrayList<String> mru = (ArrayList<String>)this.session.cached("cli_over_http_mru");
        if (null == mru) {
            mru = new ArrayList<String>();
        }
        this.session.cache("cli_over_http_mru", mru, this.config.sessionTtl());
        return mru;
    }

    private void addToMru(String cmd) {
        List<String> mru = this.mru();
        mru.remove(cmd);
        mru.add(0, cmd);
        if (mru.size() > 8) {
            mru.remove(mru.size() - 1);
        }
    }

    private CliHandler handler(String cmd) {
        CliHandler handler = this.dispatcher.handler(cmd);
        Controller.Util.notFoundIfNull(handler);
        return handler;
    }
}

