/*
 * Decompiled with CFR 0.152.
 */
package act.controller.bytecode;

import act.Act;
import act.app.App;
import act.app.AppByteCodeScannerBase;
import act.app.AppClassLoader;
import act.app.event.SysEventId;
import act.asm.AnnotationVisitor;
import act.asm.AsmException;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import act.asm.signature.SignatureReader;
import act.asm.signature.SignatureVisitor;
import act.controller.Controller;
import act.controller.annotation.Port;
import act.controller.annotation.TemplateContext;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.BindAnnoInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.ControllerClassMetaInfoManager;
import act.controller.meta.HandlerMethodMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.controller.meta.InterceptorType;
import act.controller.meta.ParamAnnoInfo;
import act.controller.meta.ParamAnnoInfoTrait;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.route.RouteSource;
import act.route.Router;
import act.sys.Env;
import act.sys.meta.EnvAnnotationVisitor;
import act.util.AsmType;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.util.ClassNode;
import act.util.GeneralAnnoInfo;
import act.util.Global;
import act.util.PropertySpec;
import act.util.Virtual;
import act.ws.WsEndpoint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.mvc.annotation.With;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.ListBuilder;
import org.osgl.util.S;

public class ControllerByteCodeScanner
extends AppByteCodeScannerBase {
    private Router router;
    private ControllerClassMetaInfo classInfo;
    private volatile ControllerClassMetaInfoManager classInfoBase;
    private Lang.Var<Boolean> envMatches = $.var((Object)true);
    private EnvAnnotationVisitor eav;

    @Override
    protected boolean shouldScan(String className) {
        boolean possibleController = this.config().possibleControllerClass(className);
        this.classInfo = new ControllerClassMetaInfo().possibleController(possibleController);
        return possibleController;
    }

    @Override
    protected void onAppSet() {
        this.router = this.app().router();
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
        if (this.classInfo.isController()) {
            this.classInfoBase().registerControllerMetaInfo(this.classInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControllerClassMetaInfoManager classInfoBase() {
        if (null == this.classInfoBase) {
            ControllerByteCodeScanner controllerByteCodeScanner = this;
            synchronized (controllerByteCodeScanner) {
                if (null == this.classInfoBase) {
                    this.classInfoBase = this.app().classLoader().controllerClassMetaInfoManager();
                }
            }
        }
        return this.classInfoBase;
    }

    private static class RouteRegister
    implements Runnable {
        List<Router> routers;
        List<String> paths;
        String methodName;
        ControllerClassMetaInfo classInfo;
        List<H.Method> httpMethods;
        Lang.Var<Boolean> isVirtual;
        boolean noRegister;
        Lang.Var<Boolean> envMatched;

        RouteRegister(Lang.Var<Boolean> envMatched, List<H.Method> methods, List<String> paths, String methodName, List<Router> routers, ControllerClassMetaInfo classInfo, boolean noRegister, Lang.Var<Boolean> isVirtual) {
            this.routers = routers;
            this.paths = paths;
            this.methodName = methodName;
            this.classInfo = classInfo;
            this.httpMethods = methods;
            this.noRegister = noRegister;
            this.isVirtual = isVirtual;
            this.envMatched = envMatched;
        }

        @Override
        public void run() {
            if (!((Boolean)this.envMatched.get()).booleanValue()) {
                return;
            }
            final HashSet<String> contexts = new HashSet<String>();
            if (!this.noRegister) {
                String contextPath = this.classInfo.urlContext();
                String className = this.classInfo.className();
                String action = "__ws_endpoint__" == this.methodName ? this.methodName : S.concat((String)className, (String)".", (String)this.methodName);
                this.registerOnContext(contextPath, action);
                contexts.add(contextPath);
            }
            if (!((Boolean)this.isVirtual.get()).booleanValue()) {
                return;
            }
            App app = Act.app();
            final AppClassLoader classLoader = app.classLoader();
            ClassNode node = classLoader.classInfoRepository().node(this.classInfo.className());
            node.visitSubTree(new Lang.Visitor<ClassNode>(){

                public void visit(ClassNode classNode) throws Lang.Break {
                    String subClassContextPath;
                    String className = classNode.name();
                    ControllerClassMetaInfo subClassInfo = classLoader.controllerClassMetaInfo(className);
                    if (null != subClassInfo && null != (subClassContextPath = subClassInfo.urlContext())) {
                        if (!contexts.contains(subClassContextPath)) {
                            RouteRegister.this.registerOnContext(subClassContextPath, S.builder((String)subClassInfo.className()).append(".").append(RouteRegister.this.methodName).toString());
                            contexts.add(subClassContextPath);
                        } else {
                            throw E.invalidConfiguration((String)"the context path of Sub controller %s has already been registered: %s", (Object[])new Object[]{className, subClassContextPath});
                        }
                    }
                }
            }, true, true);
        }

        private void registerOnContext(String ctxPath, String action) {
            S.Buffer sb = S.newBuffer();
            if (this.paths.isEmpty()) {
                this.paths.add("");
            }
            for (Router r : this.routers) {
                for (String urlPath : this.paths) {
                    if (!(urlPath.startsWith("/") || S.blank((String)ctxPath) || "/".equals(ctxPath))) {
                        if (ctxPath.endsWith("/")) {
                            ctxPath = ctxPath.substring(0, ctxPath.length() - 1);
                        }
                        sb.setLength(0);
                        sb.append(ctxPath);
                        if (!urlPath.startsWith("/")) {
                            sb.append("/");
                        }
                        sb.append(urlPath);
                        urlPath = sb.toString();
                    }
                    for (H.Method m : this.httpMethods) {
                        try {
                            r.addMapping(m, (CharSequence)urlPath, action, RouteSource.ACTION_ANNOTATION);
                        }
                        catch (RuntimeException e) {
                            logger.error((Throwable)e, "add router mapping failed: \n\tmethod[%s]\n\turl path: %s\n\taction: %s", new Object[]{m, urlPath, action});
                        }
                    }
                }
            }
        }
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private String[] ports = new String[0];
        private Set<String> methodNames = new HashSet<String>();

        private _ByteCodeVisitor() {
        }

        private void checkMethodName(String methodName) {
            if (this.methodNames.contains(methodName)) {
                throw AsmException.of((String)"Duplicate action/interceptor method name found: %s", (Object[])new Object[]{methodName});
            }
            this.methodNames.add(methodName);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            logger.trace("Scanning %s", new Object[]{name});
            ControllerByteCodeScanner.this.classInfo.className(name);
            String className = name.replace('/', '.');
            if (ControllerByteCodeScanner.this.router.possibleController(className)) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
            }
            Type superType = Type.getObjectType((String)superName);
            ControllerByteCodeScanner.this.classInfo.superType(superType);
            if (_ByteCodeVisitor.isAbstract(access)) {
                ControllerByteCodeScanner.this.classInfo.setAbstract();
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            Class c = AsmType.classForDesc(desc);
            if (Controller.class == c) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
                return new ControllerAnnotationVisitor(av);
            }
            if (ControllerClassMetaInfo.isUrlContextAnnotation(c)) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
                return new ClassUrlContextAnnotationVisitor(av, ControllerClassMetaInfo.isUrlContextAnnotationSupportInheritance(c));
            }
            if (TemplateContext.class == c) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
                return new TemplateContextAnnotationVisitor(av);
            }
            if (Port.class == c) {
                return new PortAnnotationVisitor(av);
            }
            if (With.class == c) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
                return new ClassWithAnnotationVisitor(av);
            }
            if (WsEndpoint.class == c) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
                return new WsEndpointAnnotationVisitor(av);
            }
            if (Env.isEnvAnnoDescriptor(desc)) {
                ControllerByteCodeScanner.this.eav = new EnvAnnotationVisitor(av, desc);
                return ControllerByteCodeScanner.this.eav;
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (!ControllerByteCodeScanner.this.classInfo.possibleController() || !this.isEligibleMethod(access, name)) {
                return mv;
            }
            String className = ControllerByteCodeScanner.this.classInfo.className();
            boolean isRoutedMethod = ControllerByteCodeScanner.this.router.isActionMethod(className, name);
            return new ActionMethodVisitor(isRoutedMethod, mv, access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            if (null != ControllerByteCodeScanner.this.eav && !ControllerByteCodeScanner.this.eav.matched()) {
                ControllerByteCodeScanner.this.envMatches.set((Object)false);
            }
        }

        private boolean isEligibleMethod(int access, String name) {
            return !_ByteCodeVisitor.isAbstract(access) && !_ByteCodeVisitor.isConstructor(name);
        }

        private List<Router> routers() {
            ArrayList<Router> routers = new ArrayList<Router>();
            if (null == this.ports || this.ports.length == 0) {
                routers.add(ControllerByteCodeScanner.this.app().router());
            } else {
                App app = ControllerByteCodeScanner.this.app();
                for (String portName : this.ports) {
                    Router r = app.router(portName);
                    if (null == r) {
                        if (S.eq((String)"__admin__", (String)portName)) {
                            return routers;
                        }
                        throw E.invalidConfiguration((String)"Cannot find configuration for named port[%s]", (Object[])new Object[]{portName});
                    }
                    routers.add(r);
                }
            }
            return routers;
        }

        static /* synthetic */ String[] access$802(_ByteCodeVisitor x0, String[] x1) {
            x0.ports = x1;
            return x1;
        }

        private class ActionMethodVisitor
        extends MethodVisitor
        implements Opcodes {
            private String methodName;
            private int access;
            private String desc;
            private String signature;
            private boolean isStatic;
            private boolean requireScan;
            private boolean disableJsonCircularRefDetect;
            private HandlerMethodMetaInfo methodInfo;
            private PropertySpec.MetaInfo propSpec;
            List<String> paths;
            private Map<Integer, List<ParamAnnoInfoTrait>> paramAnnoInfoList;
            private Map<Integer, List<GeneralAnnoInfo>> genericParamAnnoInfoList;
            private BitSet contextInfo;
            private Lang.Var<Boolean> isVirtual;
            private HandlerWithAnnotationVisitor withAnnotationVisitor;
            private Lang.Var<Boolean> isGlobal;
            private List<InterceptorAnnotationVisitor> interceptorAnnotationVisitors;
            private EnvAnnotationVisitor eav;
            private Lang.Var<Boolean> envMatched;

            ActionMethodVisitor(boolean isRoutedMethod, MethodVisitor mv, int access, String methodName, String desc, String signature, String[] exceptions) {
                super(327680, mv);
                this.paths = new ArrayList<String>();
                this.paramAnnoInfoList = new HashMap<Integer, List<ParamAnnoInfoTrait>>();
                this.genericParamAnnoInfoList = new HashMap<Integer, List<GeneralAnnoInfo>>();
                this.contextInfo = new BitSet();
                this.isVirtual = $.var((Object)false);
                this.isGlobal = $.var((Object)false);
                this.interceptorAnnotationVisitors = new ArrayList<InterceptorAnnotationVisitor>();
                this.envMatched = $.var((Object)true);
                this.access = access;
                this.methodName = methodName;
                this.desc = desc;
                this.signature = signature;
                this.isStatic = ByteCodeVisitor.isStatic(access);
                if (ControllerByteCodeScanner.this.classInfo.isAbstract()) {
                    this.isVirtual.set((Object)true);
                }
                if (isRoutedMethod) {
                    this.markRequireScan();
                }
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                Type type = Type.getType((String)desc);
                Class c = AsmType.classForType(type);
                if (Virtual.class.getName().equals(c.getName())) {
                    this.isVirtual.set((Object)true);
                    return av;
                }
                if (Global.class.getName().equals(c.getName())) {
                    this.isGlobal.set((Object)true);
                    return av;
                }
                if (Type.getType(With.class).getDescriptor().equals(desc)) {
                    ControllerByteCodeScanner.this.classInfo.isController(true);
                    this.withAnnotationVisitor = new HandlerWithAnnotationVisitor(av);
                    return this.withAnnotationVisitor;
                }
                if (Env.isEnvAnnoDescriptor(desc)) {
                    this.eav = new EnvAnnotationVisitor(av, desc);
                    return this.eav;
                }
                if (ControllerClassMetaInfo.isActionAnnotation(c)) {
                    _ByteCodeVisitor.this.checkMethodName(this.methodName);
                    this.markRequireScan();
                    this.methodInfo = new ActionMethodMetaInfo(ControllerByteCodeScanner.this.classInfo);
                    ControllerByteCodeScanner.this.classInfo.addAction((ActionMethodMetaInfo)this.methodInfo);
                    if (null != this.propSpec) {
                        this.methodInfo.propertySpec(this.propSpec);
                    }
                    return new ActionAnnotationVisitor(av, ControllerClassMetaInfo.lookupHttpMethod(c), ControllerClassMetaInfo.isActionUtilAnnotation(c), this.isStatic, ControllerClassMetaInfo.noDefPath(c));
                }
                if (ControllerClassMetaInfo.isUrlContextAnnotation(c)) {
                    return new MethodUrlContextAnnotationVisitor(av, ControllerClassMetaInfo.isUrlContextAnnotationSupportAbsolutePath(c));
                }
                if (ControllerClassMetaInfo.isInterceptorAnnotation(c)) {
                    _ByteCodeVisitor.this.checkMethodName(this.methodName);
                    this.markRequireScan();
                    InterceptorAnnotationVisitor visitor = new InterceptorAnnotationVisitor(av, c);
                    this.methodInfo = visitor.info;
                    if (null != this.propSpec) {
                        this.methodInfo.propertySpec(this.propSpec);
                    }
                    this.interceptorAnnotationVisitors.add(visitor);
                    return visitor;
                }
                if ($.eq((Object)AsmTypes.PROPERTY_SPEC.asmType(), (Object)type)) {
                    this.propSpec = new PropertySpec.MetaInfo();
                    if (null != this.methodInfo) {
                        this.methodInfo.propertySpec(this.propSpec);
                    }
                    return new AnnotationVisitor(327680, av){

                        public AnnotationVisitor visitArray(String name) {
                            AnnotationVisitor av0 = super.visitArray(name);
                            if (S.eq((String)"value", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        ActionMethodVisitor.this.propSpec.onValue(S.string((Object)value));
                                        super.visit(name, value);
                                    }
                                };
                            }
                            if (S.eq((String)"cli", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        ActionMethodVisitor.this.propSpec.onCli(S.string((Object)value));
                                        super.visit(name, value);
                                    }
                                };
                            }
                            if (S.eq((String)"http", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        ActionMethodVisitor.this.propSpec.onHttp(S.string((Object)value));
                                        super.visit(name, value);
                                    }
                                };
                            }
                            return av0;
                        }
                    };
                }
                return av;
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                AnnotationVisitor av = super.visitParameterAnnotation(parameter, desc, visible);
                Type type = Type.getType((String)desc);
                if ($.eq((Object)type, (Object)AsmTypes.PARAM.asmType())) {
                    return new ParamAnnotationVisitor(av, parameter);
                }
                if ($.eq((Object)type, (Object)AsmTypes.BIND.asmType())) {
                    return new BindAnnotationVisitor(av, parameter);
                }
                if ($.eq((Object)type, (Object)AsmTypes.CONTEXT.asmType())) {
                    this.contextInfo.set(parameter);
                    return av;
                }
                GeneralAnnoInfo info = new GeneralAnnoInfo(type);
                List<GeneralAnnoInfo> list = this.genericParamAnnoInfoList.get(parameter);
                if (null == list) {
                    list = new ArrayList<GeneralAnnoInfo>();
                    this.genericParamAnnoInfoList.put(parameter, list);
                }
                list.add(info);
                return new GeneralAnnoInfo.Visitor(av, info);
            }

            public void visitEnd() {
                if (!this.requireScan()) {
                    super.visitEnd();
                    return;
                }
                if (null != this.eav && !this.eav.matched()) {
                    this.envMatched.set((Object)false);
                }
                if (((Boolean)this.isGlobal.get()).booleanValue()) {
                    for (InterceptorAnnotationVisitor visitor : this.interceptorAnnotationVisitors) {
                        visitor.registerGlobalInterceptor();
                    }
                }
                ControllerByteCodeScanner.this.classInfo.isController(true);
                if (null == this.methodInfo) {
                    ActionMethodMetaInfo action = new ActionMethodMetaInfo(ControllerByteCodeScanner.this.classInfo);
                    this.methodInfo = action;
                    ControllerByteCodeScanner.this.classInfo.addAction(action);
                }
                if (null != this.withAnnotationVisitor && this.methodInfo instanceof ActionMethodMetaInfo) {
                    ActionMethodMetaInfo actionInfo = (ActionMethodMetaInfo)$.cast((Object)this.methodInfo);
                    actionInfo.addWith(this.withAnnotationVisitor.withArray);
                }
                final HandlerMethodMetaInfo info = this.methodInfo;
                info.name(this.methodName);
                boolean isStatic = AsmTypes.isStatic(this.access);
                if (isStatic) {
                    info.invokeStaticMethod();
                } else {
                    info.invokeInstanceMethod();
                }
                info.returnType(Type.getReturnType((String)this.desc));
                Type[] argTypes = Type.getArgumentTypes((String)this.desc);
                boolean ctxByParam = false;
                for (int i = 0; i < argTypes.length; ++i) {
                    List<GeneralAnnoInfo> list;
                    List<ParamAnnoInfoTrait> paraAnnoList;
                    Type type = argTypes[i];
                    if (AsmTypes.ACTION_CONTEXT.asmType().equals((Object)type)) {
                        ctxByParam = true;
                        info.appContextViaParam(i);
                    }
                    HandlerParamMetaInfo param = new HandlerParamMetaInfo().type(type);
                    if (this.contextInfo.get(i)) {
                        param.setContext();
                    }
                    if (null != (paraAnnoList = this.paramAnnoInfoList.get(i))) {
                        for (ParamAnnoInfoTrait trait : paraAnnoList) {
                            trait.attachTo(param);
                        }
                    }
                    if (null != (list = this.genericParamAnnoInfoList.get(i))) {
                        param.addGeneralAnnotations(list);
                    }
                    info.addParam(param);
                }
                if (!ctxByParam) {
                    if (ControllerByteCodeScanner.this.classInfo.hasCtxField() && !isStatic) {
                        info.appContextViaField(ControllerByteCodeScanner.this.classInfo.ctxField());
                    } else {
                        info.appContextViaLocalStorage();
                    }
                }
                if (null != this.signature) {
                    SignatureReader sr = new SignatureReader(this.signature);
                    final Lang.Var id = new Lang.Var((Object)-1);
                    sr.accept(new SignatureVisitor(327680){
                        boolean startParsing;

                        public SignatureVisitor visitParameterType() {
                            id.set((Object)((Integer)id.get() + 1));
                            return this;
                        }

                        public SignatureVisitor visitTypeArgument(char wildcard) {
                            if (wildcard == '=') {
                                this.startParsing = true;
                            }
                            return this;
                        }

                        public void visitClassType(String name) {
                            if (this.startParsing) {
                                Type type = Type.getObjectType((String)name);
                                int n = (Integer)id.get();
                                if (n < 0) {
                                    info.returnComponentType(type);
                                } else {
                                    info.param(n).componentType(type);
                                }
                            }
                            this.startParsing = false;
                        }
                    });
                }
                super.visitEnd();
            }

            private void markRequireScan() {
                this.requireScan = true;
            }

            private boolean requireScan() {
                return this.requireScan;
            }

            private class BindAnnotationVisitor
            extends ParamAnnotationVisitorBase<BindAnnoInfo> {
                public BindAnnotationVisitor(AnnotationVisitor av, int index) {
                    super(av, index);
                }

                @Override
                protected BindAnnoInfo createAnnotationInfo(int index) {
                    return new BindAnnoInfo(index);
                }

                public void visit(String name, Object value) {
                    if ("model".endsWith(name)) {
                        ((BindAnnoInfo)this.info).model((String)value);
                    }
                    super.visit(name, value);
                }

                public AnnotationVisitor visitArray(String name) {
                    AnnotationVisitor av = super.visitArray(name);
                    if ("value".equals(name)) {
                        return new AnnotationVisitor(327680, av){

                            public void visit(String name, Object value) {
                                Type type = (Type)value;
                                Class c = $.classForName((String)type.getClassName(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                                ((BindAnnoInfo)BindAnnotationVisitor.this.info).binder(c);
                                super.visit(name, value);
                            }
                        };
                    }
                    return av;
                }
            }

            private class ParamAnnotationVisitor
            extends ParamAnnotationVisitorBase<ParamAnnoInfo> {
                public ParamAnnotationVisitor(AnnotationVisitor av, int index) {
                    super(av, index);
                }

                @Override
                protected ParamAnnoInfo createAnnotationInfo(int index) {
                    return new ParamAnnoInfo(index);
                }

                public void visit(String name, Object value) {
                    if (S.eq((String)"value", (String)name)) {
                        ((ParamAnnoInfo)this.info).bindName((String)value);
                    } else if (S.eq((String)"defVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(String.class, value);
                    } else if (S.eq((String)"defIntVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Integer.class, value);
                    } else if (S.eq((String)"defBooleanVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Boolean.class, value);
                    } else if (S.eq((String)"defLongVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Long.class, value);
                    } else if (S.eq((String)"defDoubleVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Double.class, value);
                    } else if (S.eq((String)"defFloatVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Float.class, value);
                    } else if (S.eq((String)"defCharVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Character.class, value);
                    } else if (S.eq((String)"defByteVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Byte.class, name);
                    }
                    super.visit(name, value);
                }

                private <T> T c(Object v) {
                    return (T)$.cast((Object)v);
                }
            }

            private abstract class ParamAnnotationVisitorBase<T extends ParamAnnoInfoTrait>
            extends AnnotationVisitor
            implements Opcodes {
                protected int index;
                protected T info;

                public ParamAnnotationVisitorBase(AnnotationVisitor av, int index) {
                    super(327680, av);
                    this.index = index;
                    this.info = this.createAnnotationInfo(index);
                }

                public void visitEnd() {
                    ArrayList<T> traits = (ArrayList<T>)ActionMethodVisitor.this.paramAnnoInfoList.get(this.index);
                    if (null == traits) {
                        traits = new ArrayList<T>();
                        ActionMethodVisitor.this.paramAnnoInfoList.put(this.index, traits);
                    } else {
                        for (ParamAnnoInfoTrait trait : traits) {
                            if (this.info.compatibleWith(trait)) continue;
                            throw E.unexpected((String)this.info.compatibilityErrorMessage(trait), (Object[])new Object[0]);
                        }
                    }
                    traits.add(this.info);
                    super.visitEnd();
                }

                protected abstract T createAnnotationInfo(int var1);
            }

            private class ActionAnnotationVisitor
            extends AnnotationVisitor
            implements Opcodes {
                List<H.Method> httpMethods;
                List<String> paths;
                boolean isUtil;
                boolean isStatic;
                boolean noDefPath;

                public ActionAnnotationVisitor(AnnotationVisitor av, H.Method method, boolean isUtil, boolean staticMethod, boolean noDefPath) {
                    super(327680, av);
                    this.httpMethods = new ArrayList<H.Method>();
                    this.paths = new ArrayList<String>();
                    if (null != method) {
                        this.httpMethods.add(method);
                    }
                    this.isUtil = isUtil;
                    this.isStatic = staticMethod;
                    this.noDefPath = noDefPath;
                }

                public AnnotationVisitor visitArray(String name) {
                    AnnotationVisitor av = super.visitArray(name);
                    if ("value".equals(name)) {
                        return new AnnotationVisitor(327680, av){

                            public void visit(String name, Object value) {
                                ActionAnnotationVisitor.this.paths.add((String)value);
                                super.visit(name, value);
                            }
                        };
                    }
                    if ("methods".equals(name)) {
                        return new AnnotationVisitor(327680, av){

                            public void visitEnum(String name, String desc, String value) {
                                String enumClass = Type.getType((String)desc).getClassName();
                                if (H.Method.class.getName().equals(enumClass)) {
                                    H.Method method = H.Method.valueOf((String)value);
                                    ActionAnnotationVisitor.this.httpMethods.add(method);
                                }
                                super.visitEnum(name, desc, value);
                            }
                        };
                    }
                    return av;
                }

                public void visitEnd() {
                    super.visitEnd();
                    if (this.isUtil) {
                        return;
                    }
                    if (this.httpMethods.isEmpty()) {
                        this.httpMethods.addAll(H.Method.actionMethods());
                    }
                    List routers = _ByteCodeVisitor.this.routers();
                    if (!this.noDefPath && this.paths.isEmpty()) {
                        this.paths.add("");
                    }
                    ControllerByteCodeScanner.this.app().jobManager().on(SysEventId.APP_CODE_SCANNED, (Runnable)new RouteRegister((Lang.Var<Boolean>)ActionMethodVisitor.this.envMatched, this.httpMethods, this.paths, ActionMethodVisitor.this.methodName, routers, ControllerByteCodeScanner.this.classInfo, ControllerByteCodeScanner.this.classInfo.isAbstract() && !this.isStatic, (Lang.Var<Boolean>)ActionMethodVisitor.this.isVirtual));
                }
            }

            private class MethodUrlContextAnnotationVisitor
            extends AnnotationVisitor {
                private final boolean supportAbsolutePath;

                MethodUrlContextAnnotationVisitor(AnnotationVisitor av, boolean supportAbsolutePath) {
                    super(327680, av);
                    this.supportAbsolutePath = supportAbsolutePath;
                }

                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        String pathComponent = value.toString();
                        if (!this.supportAbsolutePath && pathComponent.startsWith("/")) {
                            pathComponent = pathComponent.substring(1);
                        }
                        ActionMethodVisitor.this.paths.add(pathComponent);
                    }
                    super.visit(name, value);
                }
            }

            private class InterceptorAnnotationVisitor
            extends AnnotationVisitor
            implements Opcodes {
                private InterceptorMethodMetaInfo info;
                private InterceptorType interceptorType;

                public InterceptorAnnotationVisitor(AnnotationVisitor av, Class<? extends Annotation> annoCls) {
                    super(327680, av);
                    this.interceptorType = InterceptorType.of(annoCls);
                    this.info = this.interceptorType.createMetaInfo(ControllerByteCodeScanner.this.classInfo);
                    ControllerByteCodeScanner.this.classInfo.addInterceptor(this.info, annoCls);
                }

                public void visit(String name, Object value) {
                    if ("priority".equals(name)) {
                        this.info.priority((Integer)value);
                    }
                    super.visit(name, value);
                }

                public AnnotationVisitor visitArray(String name) {
                    if ("only".equals(name)) {
                        return new OnlyValueVisitor(this.av);
                    }
                    if ("except".equals(name)) {
                        return new ExceptValueVisitor(this.av);
                    }
                    if ("value".equals(name) && this.info instanceof CatchMethodMetaInfo) {
                        return new CatchValueVisitor(this.av);
                    }
                    return super.visitArray(name);
                }

                void registerGlobalInterceptor() {
                    RequestHandlerProxy.registerGlobalInterceptor(this.info, this.interceptorType);
                }

                private class CatchValueVisitor
                extends AnnotationVisitor {
                    List<String> exceptions;

                    public CatchValueVisitor(AnnotationVisitor av) {
                        super(327680, av);
                        this.exceptions = new ArrayList<String>();
                    }

                    public void visit(String name, Object value) {
                        this.exceptions.add(((Type)value).getClassName());
                        super.visit(name, value);
                    }

                    public void visitEnd() {
                        CatchMethodMetaInfo ci = (CatchMethodMetaInfo)InterceptorAnnotationVisitor.this.info;
                        ci.exceptionClasses(this.exceptions);
                        super.visitEnd();
                    }
                }

                private class ExceptValueVisitor
                extends StringArrayVisitor {
                    public ExceptValueVisitor(AnnotationVisitor av) {
                        super(av);
                    }

                    public void visitEnd() {
                        Object[] sa = new String[this.strings.size()];
                        sa = (String[])this.strings.toArray(sa);
                        InterceptorAnnotationVisitor.this.info.addExcept((String[])sa);
                        super.visitEnd();
                    }
                }

                private class OnlyValueVisitor
                extends StringArrayVisitor {
                    public OnlyValueVisitor(AnnotationVisitor av) {
                        super(av);
                    }

                    public void visitEnd() {
                        Object[] sa = new String[this.strings.size()];
                        sa = (String[])this.strings.toArray(sa);
                        InterceptorAnnotationVisitor.this.info.addOnly((String[])sa);
                        super.visitEnd();
                    }
                }
            }

            private class HandlerWithAnnotationVisitor
            extends AnnotationVisitor {
                private String[] withArray;

                public HandlerWithAnnotationVisitor(AnnotationVisitor av) {
                    super(327680, av);
                }

                public AnnotationVisitor visitArray(String name) {
                    AnnotationVisitor av = super.visitArray(name);
                    if ("value".equals(name)) {
                        return new StringArrayVisitor(av){

                            public void visitEnd() {
                                Object[] sa = new String[this.strings.size()];
                                sa = (String[])this.strings.toArray(sa);
                                HandlerWithAnnotationVisitor.access$1202(HandlerWithAnnotationVisitor.this, (String[])sa);
                                super.visitEnd();
                            }
                        };
                    }
                    return av;
                }

                static /* synthetic */ String[] access$1202(HandlerWithAnnotationVisitor x0, String[] x1) {
                    x0.withArray = x1;
                    return x1;
                }
            }
        }

        private class PortAnnotationVisitor
        extends AnnotationVisitor {
            PortAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if ("value".equals(name)) {
                    return new StringArrayVisitor(av){

                        public void visitEnd() {
                            _ByteCodeVisitor.access$802(_ByteCodeVisitor.this, new String[this.strings.size()]);
                            _ByteCodeVisitor.access$802(_ByteCodeVisitor.this, (String[])this.strings.toArray((Object[])_ByteCodeVisitor.this.ports));
                            super.visitEnd();
                        }
                    };
                }
                return av;
            }
        }

        private class TemplateContextAnnotationVisitor
        extends AnnotationVisitor {
            TemplateContextAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public void visit(String name, Object value) {
                if ("value".equals(name)) {
                    ControllerByteCodeScanner.this.classInfo.templateContext(value.toString());
                }
                super.visit(name, value);
            }
        }

        private class ClassUrlContextAnnotationVisitor
        extends AnnotationVisitor {
            private final boolean supportInheritance;

            ClassUrlContextAnnotationVisitor(AnnotationVisitor av, boolean supportInheritance) {
                super(327680, av);
                this.supportInheritance = supportInheritance;
            }

            public void visit(String name, Object value) {
                if ("value".equals(name)) {
                    String pathComponent = value.toString();
                    if (!this.supportInheritance && !pathComponent.startsWith("/")) {
                        pathComponent = "/" + pathComponent;
                    }
                    ControllerByteCodeScanner.this.classInfo.urlContext(pathComponent);
                }
                super.visit(name, value);
            }
        }

        private class ControllerAnnotationVisitor
        extends AnnotationVisitor {
            ControllerAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public void visit(String name, Object value) {
                if ("value".equals(name)) {
                    ControllerByteCodeScanner.this.classInfo.urlContext(value.toString());
                }
                super.visit(name, value);
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if ("port".equals(name)) {
                    return new StringArrayVisitor(av){

                        public void visitEnd() {
                            _ByteCodeVisitor.access$802(_ByteCodeVisitor.this, new String[this.strings.size()]);
                            _ByteCodeVisitor.access$802(_ByteCodeVisitor.this, (String[])this.strings.toArray((Object[])_ByteCodeVisitor.this.ports));
                            super.visitEnd();
                        }
                    };
                }
                return av;
            }
        }

        private class ClassWithAnnotationVisitor
        extends AnnotationVisitor {
            public ClassWithAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if ("value".equals(name)) {
                    return new StringArrayVisitor(av){

                        public void visitEnd() {
                            Object[] sa = new String[this.strings.size()];
                            sa = (String[])this.strings.toArray(sa);
                            ControllerByteCodeScanner.this.classInfo.addWith((String[])sa);
                            super.visitEnd();
                        }
                    };
                }
                return av;
            }
        }

        private class WsEndpointAnnotationVisitor
        extends AnnotationVisitor {
            WsEndpointAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if ("value".equals(name)) {
                    return new StringArrayVisitor(av){

                        public void visitEnd() {
                            List routers = _ByteCodeVisitor.this.routers();
                            if (this.strings.isEmpty()) {
                                this.strings.add((Object)"");
                            }
                            ControllerByteCodeScanner.this.app().jobManager().on(SysEventId.APP_CODE_SCANNED, (Runnable)new RouteRegister((Lang.Var<Boolean>)ControllerByteCodeScanner.this.envMatches, (List<H.Method>)C.list((Object)H.Method.GET), (List<String>)this.strings, "__ws_endpoint__", routers, ControllerByteCodeScanner.this.classInfo, false, (Lang.Var<Boolean>)$.var((Object)false)));
                            super.visitEnd();
                        }
                    };
                }
                return super.visitArray(name);
            }
        }

        private class StringArrayVisitor
        extends AnnotationVisitor {
            protected ListBuilder<String> strings;

            public StringArrayVisitor(AnnotationVisitor av) {
                super(327680, av);
                this.strings = ListBuilder.create();
            }

            public void visit(String name, Object value) {
                this.strings.add((Object)value.toString());
                super.visit(name, value);
            }
        }
    }
}

