/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppClassLoader;
import act.app.event.SysEventId;
import act.asm.Type;
import act.controller.meta.ControllerClassMetaInfo;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class ControllerClassMetaInfoManager
extends DestroyableBase {
    private Map<String, ControllerClassMetaInfo> controllers = new HashMap<String, ControllerClassMetaInfo>();

    @Inject
    public ControllerClassMetaInfoManager(App app) {
        app.jobManager().on(SysEventId.APP_CODE_SCANNED, new Runnable(){

            @Override
            public void run() {
                ControllerClassMetaInfoManager.this.buildControllerHierarchies();
            }
        });
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.controllers.values(), ApplicationScoped.class);
        this.controllers.clear();
        super.releaseResources();
    }

    public void registerControllerMetaInfo(ControllerClassMetaInfo metaInfo) {
        String className = Type.getObjectType((String)metaInfo.className()).getClassName();
        this.controllers.put(className, metaInfo);
        this.trace("Controller meta info registered for: %s", className);
    }

    public ControllerClassMetaInfo controllerMetaInfo(String className) {
        return this.controllers.get(className);
    }

    public void mergeActionMetaInfo(App app) {
        for (ControllerClassMetaInfo info : this.controllers.values()) {
            info.merge(this, app);
        }
    }

    public void buildControllerHierarchies() {
        AppClassLoader cl = Act.app().classLoader();
        ControllerClassMetaInfoManager manager = cl.controllerClassMetaInfoManager();
        ClassInfoRepository repo = cl.classInfoRepository();
        for (ControllerClassMetaInfo info : manager.controllers.values()) {
            ControllerClassMetaInfoManager.buildSuperClassMetaInfo(info, manager, repo);
        }
    }

    private static void buildSuperClassMetaInfo(ControllerClassMetaInfo info, ControllerClassMetaInfoManager manager, ClassInfoRepository repo) {
        String className = info.className();
        ClassNode node = repo.node(className);
        if (null == node) {
            return;
        }
        String OBJECT = Object.class.getName();
        for (ClassNode parent = node.parent(); null != parent && !OBJECT.equals(parent.name()); parent = parent.parent()) {
            ControllerClassMetaInfo parentInfo = manager.controllerMetaInfo(parent.name());
            if (null == parentInfo) continue;
            info.parent(parentInfo);
            break;
        }
    }
}

