/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.App;
import act.app.AppServiceBase;
import act.data.OutputFieldsCache;
import act.util.ActContext;
import act.util.PropertySpec;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.rythmengine.utils.S;

public class DataPropertyRepository
extends AppServiceBase<DataPropertyRepository> {
    private static final Logger LOGGER = LogManager.get(DataPropertyRepository.class);
    private Set<Class> terminators;
    private Set<String> extendedTerminators;
    private Map<String, List<String>> repo = new HashMap<String, List<String>>();
    private OutputFieldsCache outputFieldsCache = new OutputFieldsCache();

    public DataPropertyRepository(App app) {
        super(app, true);
        this._init();
    }

    @Override
    protected void releaseResources() {
        this.extendedTerminators.clear();
        this.terminators.clear();
        this.repo.clear();
    }

    public synchronized List<String> propertyListOf(Class<?> c) {
        String cn = c.getName();
        List<String> ls = this.repo.get(cn);
        if (ls != null) {
            return ls;
        }
        ls = this.buildPropertyList(c);
        this.repo.put(cn, ls);
        return ls;
    }

    public List<String> outputFields(PropertySpec.MetaInfo spec, Class<?> componentClass, ActContext context) {
        return this.outputFieldsCache.getOutputFields(spec, componentClass, context);
    }

    private List<String> buildPropertyList(Class c) {
        Method[] ma = c.getMethods();
        String context = "";
        ArrayList<String> retLst = new ArrayList<String>();
        for (Method m : ma) {
            this.buildPropertyPath(context, m, retLst);
        }
        return retLst;
    }

    private void buildPropertyPath(String context, Method m, List<String> repo) {
        if (m.getParameterTypes().length > 0) {
            return;
        }
        String name = m.getName();
        if ("getClass".equals(name)) {
            return;
        }
        String propName = "";
        if (name.startsWith("get")) {
            propName = DataPropertyRepository.getPropName(name);
        } else if (name.startsWith("is")) {
            propName = DataPropertyRepository.isPropName(name);
        }
        if (S.isEmpty((String)propName)) {
            return;
        }
        Class<?> c = m.getReturnType();
        if (Class.class.equals(c)) {
            return;
        }
        if (c.isArray()) {
            Class<?> componentType = c.getComponentType();
            List<String> retTypeProperties = this.propertyListOf(componentType);
            context = context + propName + ".";
            for (String s : retTypeProperties) {
                repo.add(context + s);
            }
            return;
        }
        if ($.isSimpleType(c)) {
            repo.add(context + propName);
            return;
        }
        if (Iterable.class.isAssignableFrom(c)) {
            Type t = m.getGenericReturnType();
            if (t instanceof ParameterizedType) {
                Type[] ta;
                ParameterizedType pt = (ParameterizedType)t;
                for (Type t0 : ta = pt.getActualTypeArguments()) {
                    Class c0 = (Class)t0;
                    List<String> retTypeProperties = this.propertyListOf(c0);
                    context = context + propName + ".";
                    for (String s : retTypeProperties) {
                        repo.add(context + s);
                    }
                }
            }
            return;
        }
        if (this.terminators.contains(c) || this.extendedTerminators.contains(c.getName())) {
            repo.add(context + propName);
            return;
        }
        List<String> retTypeProperties = this.propertyListOf(c);
        context = context + propName + ".";
        for (String s : retTypeProperties) {
            repo.add(context + s);
        }
    }

    private static String getPropName(String name) {
        return S.lowerFirst((Object)name.substring(3));
    }

    private static String isPropName(String name) {
        return S.lowerFirst((Object)name.substring(2));
    }

    private void _init() {
        C.Set s = C.newSet();
        s.add(BigDecimal.class);
        s.add(BigInteger.class);
        s.add(java.util.Date.class);
        s.add(Date.class);
        s.add(Calendar.class);
        s.add(DateTime.class);
        s.add(Instant.class);
        s.add(LocalDate.class);
        s.add(LocalDateTime.class);
        s.add(LocalTime.class);
        this.terminators = s;
        C.Set s0 = C.newSet();
        for (Class c : s) {
            s0.add(c.getName());
        }
        s0.add("java.time.Instant");
        s0.add("java.time.LocalTime");
        s0.add("java.time.LocalDate");
        s0.add("java.time.LocalDateTime");
        s0.add("org.bson.types.ObjectId");
        this.extendedTerminators = s0;
    }
}

