/*
 * Decompiled with CFR 0.152.
 */
package act.db;

import act.app.security.SecurityContext;
import act.db.Dao;
import act.inject.param.NoBind;
import act.util.ActContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.Generics;

@NoBind
public abstract class DaoBase<ID_TYPE, MODEL_TYPE, QUERY_TYPE extends Dao.Query<MODEL_TYPE, QUERY_TYPE>>
implements Dao<ID_TYPE, MODEL_TYPE, QUERY_TYPE> {
    private ActContext appCtx;
    private SecurityContext secCtx;
    private boolean destroyed;
    protected Type modelType;
    protected Class<MODEL_TYPE> modelClass;
    protected Type idType;
    protected Class<ID_TYPE> idClass;
    protected Type queryType;
    protected Class<QUERY_TYPE> queryClass;

    public DaoBase() {
        this.exploreTypes();
    }

    public DaoBase(Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType) {
        this.idType = (Type)$.notNull(idType);
        this.idClass = Generics.classOf(idType);
        this.modelType = (Type)$.notNull(modelType);
        this.modelClass = Generics.classOf(modelType);
    }

    @Override
    public void setAppContext(ActContext context) {
        this.appCtx = context;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.releaseResources();
        this.appCtx = null;
        this.secCtx = null;
    }

    @Override
    public Class<ID_TYPE> idType() {
        return this.idClass;
    }

    @Override
    public Class<MODEL_TYPE> modelType() {
        return this.modelClass;
    }

    @Override
    public Class<QUERY_TYPE> queryType() {
        return this.queryClass;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.secCtx = context;
    }

    protected void releaseResources() {
    }

    @Override
    public Class<? extends Annotation> scope() {
        return ApplicationScoped.class;
    }

    protected final ActContext appContext() {
        return this.appCtx;
    }

    protected final SecurityContext securityContext() {
        return this.secCtx;
    }

    @Override
    public Iterable<MODEL_TYPE> findBy(String fields, Object ... values) throws IllegalArgumentException {
        return this.q(fields, values).fetch();
    }

    @Override
    public MODEL_TYPE findOneBy(String fields, Object ... values) throws IllegalArgumentException {
        return this.q(fields, values).first();
    }

    @Override
    public Iterable<MODEL_TYPE> findAll() {
        return this.q().fetch();
    }

    @Override
    public List<MODEL_TYPE> findAllAsList() {
        return C.newList(this.findAll());
    }

    @Override
    public long count() {
        return this.q().count();
    }

    @Override
    public long countBy(String fields, Object ... values) throws IllegalArgumentException {
        return this.q(fields, values).count();
    }

    private void exploreTypes() {
        List types = Generics.typeParamImplementations(this.getClass(), DaoBase.class);
        int sz = types.size();
        if (sz < 1) {
            return;
        }
        if (sz > 2) {
            this.queryType = (Type)types.get(2);
            this.queryClass = Generics.classOf((Type)this.queryType);
        }
        if (sz > 1) {
            this.modelType = (Type)types.get(1);
            this.modelClass = Generics.classOf((Type)this.modelType);
        }
        this.idType = (Type)types.get(0);
        this.idClass = Generics.classOf((Type)this.idType);
    }
}

