/*
 * Decompiled with CFR 0.152.
 */
package act.db;

import act.app.App;
import act.app.DbServiceManager;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.db.DbService;
import act.db.Model;
import act.util.AppByteCodeEnhancer;
import act.util.ClassNode;
import org.osgl.Lang;
import org.osgl.util.S;

public class EntityClassEnhancer
extends AppByteCodeEnhancer<EntityClassEnhancer> {
    private String classDesc;
    private boolean isModel;
    private boolean daoMethodFound;
    private boolean daoClsMethodFound;
    private boolean isEntityClass;
    private DbServiceManager dbm;

    public EntityClassEnhancer() {
        super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate());
    }

    @Override
    protected Class<EntityClassEnhancer> subClass() {
        return EntityClassEnhancer.class;
    }

    @Override
    protected void reset() {
        this.classDesc = null;
        this.daoClsMethodFound = false;
        this.daoMethodFound = false;
        this.isEntityClass = false;
        super.reset();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classDesc = "L" + name + ";";
        String className = Type.getType((String)this.classDesc).getClassName();
        ClassNode node = this.app.classLoader().classInfoRepository().node(className);
        this.isModel = node != null && node.hasInterface(Model.class.getName());
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isModel) {
            Type type = Type.getType((String)desc);
            for (DbService dbService : this.dbm().registeredServices()) {
                if (!type.equals((Object)Type.getType(dbService.entityAnnotationType()))) continue;
                this.isEntityClass = true;
            }
        }
        return super.visitAnnotation(desc, visible);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isEntityClass && "dao".equals(name)) {
            if ("()Lact/db/Dao;".equals(desc)) {
                this.daoMethodFound = true;
                logger.warn("dao() method already defined in the model class");
            }
            if ("(Ljava/lang/Class;)Lact/db/Dao;".equals(desc)) {
                this.daoClsMethodFound = true;
                logger.warn("dao(Class) method already defined in the model class");
            }
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        if (this.isEntityClass) {
            MethodVisitor mv;
            if (!this.daoMethodFound) {
                mv = super.visitMethod(9, "dao", "()Lact/db/Dao;", "<ID_TYPE:Ljava/lang/Object;MODEL_TYPE:Lact/db/ModelBase<TID_TYPE;TMODEL_TYPE;>;QUERY_TYPE::Lact/db/Dao$Query<TMODEL_TYPE;TQUERY_TYPE;>;DAO_TYPE::Lact/db/Dao<TID_TYPE;TMODEL_TYPE;TQUERY_TYPE;TDAO_TYPE;>;>()TDAO_TYPE;", null);
                mv.visitCode();
                mv.visitMethodInsn(184, "act/app/App", "instance", "()Lact/app/App;", false);
                mv.visitMethodInsn(182, "act/app/App", "dbServiceManager", "()Lact/app/DbServiceManager;", false);
                mv.visitLdcInsn((Object)Type.getType((String)this.classDesc));
                mv.visitMethodInsn(182, "act/app/DbServiceManager", "dao", "(Ljava/lang/Class;)Lact/db/Dao;", false);
                mv.visitInsn(176);
                mv.visitMaxs(2, 0);
                mv.visitEnd();
            }
            if (!this.daoClsMethodFound) {
                mv = super.visitMethod(9, "dao", "(Ljava/lang/Class;)Lact/db/Dao;", "<T::Lact/db/Dao;>(Ljava/lang/Class<TT;>;)TT;", null);
                mv.visitCode();
                mv.visitMethodInsn(184, "act/app/App", "instance", "()Lact/app/App;", false);
                mv.visitMethodInsn(182, "act/app/App", "dbServiceManager", "()Lact/app/DbServiceManager;", false);
                mv.visitLdcInsn((Object)Type.getType((String)this.classDesc));
                mv.visitMethodInsn(182, "act/app/DbServiceManager", "dao", "(Ljava/lang/Class;)Lact/db/Dao;", false);
                mv.visitInsn(176);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
        }
        super.visitEnd();
    }

    private synchronized DbServiceManager dbm() {
        if (null == this.dbm) {
            this.dbm = App.instance().dbServiceManager();
        }
        return this.dbm;
    }
}

