/*
 * Decompiled with CFR 0.152.
 */
package act.db;

import act.app.App;
import act.app.AppServiceBase;
import act.db.DB;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EntityClassRepository
extends AppServiceBase<EntityClassRepository> {
    private ConcurrentMap<String, Set<Class>> modelClasses = new ConcurrentHashMap<String, Set<Class>>();
    private String defaultAlias;
    private Set<Class> defaultModelClasses = new HashSet<Class>();

    public EntityClassRepository(App app) {
        super(app);
        this.modelClasses.put("default", this.defaultModelClasses);
    }

    public void registerModelClass(Class<?> modelClass) {
        DB db = modelClass.getAnnotation(DB.class);
        String dbId = null == db ? "default" : db.value();
        this.registerModelClass(dbId, modelClass);
    }

    public void setDefaultAlias(String defaultAlias) {
        this.defaultAlias = defaultAlias;
        this.modelClasses.put(defaultAlias, this.defaultModelClasses);
    }

    private void registerModelClass(String dbId, Class<?> modelClass) {
        HashSet newSet;
        HashSet set;
        HashSet hashSet = set = "default".equals(dbId) || this.defaultAlias.equalsIgnoreCase(dbId) ? this.defaultModelClasses : (HashSet)this.modelClasses.get(dbId);
        if (null == set && null == (set = (Set)this.modelClasses.putIfAbsent(dbId, newSet = new HashSet()))) {
            set = newSet;
        }
        set.add(modelClass);
    }

    public Set<Class> modelClasses(String dbId) {
        return (Set)this.modelClasses.get(dbId);
    }

    @Override
    protected void releaseResources() {
        this.modelClasses.clear();
        this.defaultModelClasses.clear();
    }

    public static void init(App app) {
        new EntityClassRepository(app);
    }
}

