/*
 * Decompiled with CFR 0.152.
 */
package act.db.meta;

import act.db.meta.EntityFieldMetaInfo;
import act.db.meta.EntityMetaInfoRepo;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.S;

public class EntityClassMetaInfo {
    private String className;
    private String entityName;
    private boolean hasEntityListeners;
    private EntityFieldMetaInfo idField;
    private EntityFieldMetaInfo createdAtField;
    private EntityFieldMetaInfo lastModifiedAtField;
    private Map<String, EntityFieldMetaInfo> fields = new HashMap<String, EntityFieldMetaInfo>();

    public String className() {
        return this.className;
    }

    public void className(String className) {
        this.className = className;
        this.entityName = S.afterLast((String)className, (String)(className.contains("?") ? "?" : "."));
    }

    public String entityName() {
        return this.entityName;
    }

    public void entityName(String entityName) {
        this.entityName = entityName;
    }

    public void foundEntityListenersAnnotation() {
        this.hasEntityListeners = true;
    }

    public EntityFieldMetaInfo fieldInfo(String fieldName) {
        return this.fields.get(fieldName);
    }

    public EntityFieldMetaInfo createdAtField() {
        return this.createdAtField;
    }

    public EntityFieldMetaInfo lastModifiedAtField() {
        return this.lastModifiedAtField;
    }

    public EntityFieldMetaInfo idField() {
        return this.idField;
    }

    public EntityFieldMetaInfo getOrCreateFieldInfo(String fieldName) {
        EntityFieldMetaInfo fieldInfo = this.fields.get(fieldName);
        if (null == fieldInfo) {
            fieldInfo = new EntityFieldMetaInfo(this);
            fieldInfo.className(this.className);
            fieldInfo.fieldName(fieldName);
            this.fields.put(fieldName, fieldInfo);
        }
        return fieldInfo;
    }

    public boolean hasEntityListeners() {
        return this.hasEntityListeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityClassMetaInfo that = (EntityClassMetaInfo)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.entityName, that.entityName) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return $.hc((Object)this.className, (Object)this.entityName, this.fields);
    }

    public String toString() {
        return "EntityClassMetaInfo{className='" + this.className + '\'' + '}';
    }

    void mergeFromMappedSuperClasses(ClassInfoRepository classRepo, EntityMetaInfoRepo entityRepo) {
        ClassNode node = classRepo.node(this.getClass().getName());
        ClassNode parent = node.parent();
        if (null != parent) {
            this.mergeFrom(parent, entityRepo);
        }
    }

    void clear() {
        this.fields.clear();
        this.hasEntityListeners = false;
    }

    void createdAtField(EntityFieldMetaInfo fieldInfo) {
        E.illegalStateIf((null != this.createdAtField ? 1 : 0) != 0, (String)"createdAt field already set");
        this.createdAtField = (EntityFieldMetaInfo)$.notNull((Object)fieldInfo);
    }

    void lastModifiedAtField(EntityFieldMetaInfo fieldInfo) {
        E.illegalArgumentIf((null != this.lastModifiedAtField ? 1 : 0) != 0, (String)"lastModifiedAt field already set");
        this.lastModifiedAtField = (EntityFieldMetaInfo)$.notNull((Object)fieldInfo);
    }

    void idField(EntityFieldMetaInfo fieldInfo) {
        E.illegalArgumentIf((null != this.idField ? 1 : 0) != 0, (String)"ID field already set");
        this.idField = (EntityFieldMetaInfo)$.notNull((Object)fieldInfo);
    }

    private void mergeFrom(ClassNode parent, EntityMetaInfoRepo repo) {
        EntityClassMetaInfo parentInfo = repo.classMetaInfo(parent.name());
        if (null != parentInfo) {
            if (null != this.idField) {
                this.idField = parentInfo.idField;
            }
            if (null != this.createdAtField) {
                this.createdAtField = parentInfo.createdAtField;
            }
            if (null != this.lastModifiedAtField) {
                this.lastModifiedAtField = parentInfo.lastModifiedAtField;
            }
            for (Map.Entry<String, EntityFieldMetaInfo> entry : parentInfo.fields.entrySet()) {
                if (this.fields.containsKey(entry.getKey())) continue;
                this.fields.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != (parent = parent.parent())) {
            this.mergeFrom(parent, repo);
        }
    }
}

