/*
 * Decompiled with CFR 0.152.
 */
package act.db.meta;

import act.app.App;
import act.app.AppServiceBase;
import act.db.meta.EntityClassMetaInfo;
import act.db.meta.EntityFieldMetaInfo;
import act.db.meta.MasterEntityMetaInfoRepo;
import act.util.Stateless;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.osgl.inject.NamedProvider;

public class EntityMetaInfoRepo
extends AppServiceBase<EntityMetaInfoRepo> {
    Map<String, EntityClassMetaInfo> lookup = new HashMap<String, EntityClassMetaInfo>();
    Map<Class, EntityClassMetaInfo> lookup2 = new HashMap<Class, EntityClassMetaInfo>();

    EntityMetaInfoRepo(App app) {
        super(app);
    }

    public void registerEntityOrMappedSuperClass(String className) {
        this.getOrCreate(className);
    }

    public void registerEntityName(String className, String entityName) {
        EntityClassMetaInfo info = this.getOrCreate(className);
        info.entityName(entityName);
    }

    public void markEntityListenersFound(String className) {
        EntityClassMetaInfo info = this.getOrCreate(className);
        info.foundEntityListenersAnnotation();
    }

    public void registerCreatedField(String className, String fieldName) {
        EntityClassMetaInfo info = this.getOrCreate(className);
        info.getOrCreateFieldInfo(fieldName).trait(EntityFieldMetaInfo.Trait.CREATED);
    }

    public void registerLastModifiedField(String className, String fieldName) {
        EntityClassMetaInfo info = this.getOrCreate(className);
        info.getOrCreateFieldInfo(fieldName).trait(EntityFieldMetaInfo.Trait.LAST_MODIFIED);
    }

    public void registerIdField(String className, String fieldName) {
        EntityClassMetaInfo info = this.getOrCreate(className);
        info.getOrCreateFieldInfo(fieldName).trait(EntityFieldMetaInfo.Trait.ID);
    }

    public void registerColumnName(String className, String fieldName, String columnName) {
        EntityClassMetaInfo info = this.getOrCreate(className);
        info.getOrCreateFieldInfo(fieldName).columnName(columnName);
    }

    public boolean isRegistered(String className) {
        return this.lookup.containsKey(className);
    }

    public Set<Class> entityClasses() {
        return this.lookup2.keySet();
    }

    public EntityClassMetaInfo classMetaInfo(Class<?> entityClass) {
        return this.lookup2.get(entityClass);
    }

    public EntityClassMetaInfo classMetaInfo(String className) {
        return this.lookup.get(className);
    }

    @Override
    protected void releaseResources() {
        for (EntityClassMetaInfo classInfo : this.lookup.values()) {
            classInfo.clear();
        }
        this.lookup.clear();
    }

    void register(Class<?> entityClass, EntityClassMetaInfo info) {
        this.lookup2.put(entityClass, info);
        this.lookup.put(entityClass.getName(), info);
    }

    private EntityClassMetaInfo getOrCreate(String className) {
        EntityClassMetaInfo info = this.lookup.get(className);
        if (null == info) {
            info = new EntityClassMetaInfo();
            info.className(className);
            this.lookup.put(className, info);
        }
        return info;
    }

    @Stateless
    public static class Provider
    implements javax.inject.Provider<EntityMetaInfoRepo>,
    NamedProvider<EntityMetaInfoRepo> {
        @Inject
        private MasterEntityMetaInfoRepo masterRepo;

        public EntityMetaInfoRepo get() {
            return this.get("default");
        }

        public EntityMetaInfoRepo get(String s) {
            return this.masterRepo.forDb(s);
        }
    }
}

