/*
 * Decompiled with CFR 0.152.
 */
package act.event;

import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.event.SysEvent;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.event.ActEvent;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.event.OnceEventListener;
import act.event.OnceEventListenerBase;
import act.event.SimpleEventListener;
import act.inject.DependencyInjectionBinder;
import act.job.JobManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@ApplicationScoped
public class EventBus
extends AppServiceBase<EventBus> {
    private static final Logger LOGGER = LogManager.get(EventBus.class);
    private boolean once;
    private final SysEvent[] sysEventLookup;
    private final List[] sysEventListeners;
    private final List[] asyncSysEventListeners;
    private final ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> actEventListeners;
    private final ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> asyncActEventListeners;
    private final ConcurrentMap<Key, List<SimpleEventListener>> adhocEventListeners;
    private final ConcurrentMap<Key, List<SimpleEventListener>> asyncAdhocEventListeners;
    private final Set<Class<?>> classesWithAdhocListeners = new HashSet();
    private final Set<Enum> enumsWithAdhocListeners = new HashSet<Enum>();
    private final Set<String> stringsWithAdhocListeners = new HashSet<String>();
    private final Set<Class<? extends EventObject>> eventsWithActListeners = new HashSet<Class<? extends EventObject>>();
    private EventBus onceBus;

    private EventBus(App app, boolean once) {
        super(app, true);
        this.sysEventLookup = this.initSysEventLookup(app);
        this.sysEventListeners = this.initAppListenerArray();
        this.asyncSysEventListeners = this.initAppListenerArray();
        this.actEventListeners = new ConcurrentHashMap<Class<? extends EventObject>, List<ActEventListener>>();
        this.asyncActEventListeners = new ConcurrentHashMap<Class<? extends EventObject>, List<ActEventListener>>();
        this.adhocEventListeners = new ConcurrentHashMap<Key, List<SimpleEventListener>>();
        this.asyncAdhocEventListeners = new ConcurrentHashMap<Key, List<SimpleEventListener>>();
        this.loadDefaultEventListeners();
        if (!once) {
            this.onceBus = new EventBus(app, true);
            this.onceBus.once = true;
        }
    }

    @Inject
    public EventBus(App app) {
        this(app, false);
    }

    @Override
    protected void releaseResources() {
        if (null != this.onceBus) {
            this.onceBus.releaseResources();
        }
        this.releaseSysEventListeners(this.sysEventListeners);
        this.releaseSysEventListeners(this.asyncSysEventListeners);
        this.releaseActEventListeners(this.actEventListeners);
        this.releaseActEventListeners(this.asyncActEventListeners);
        this.releaseAdhocEventListeners(this.adhocEventListeners);
        this.releaseAdhocEventListeners(this.asyncAdhocEventListeners);
    }

    @Override
    protected void trace(String msg, Object ... args) {
        msg = S.fmt((String)msg, (Object[])args);
        if (this.once) {
            msg = S.builder((String)"[once]").append(msg).toString();
        }
        super.trace(msg, new Object[0]);
    }

    public synchronized EventBus bind(SysEventId sysEventId, SysEventListener<?> sysEventListener) {
        boolean async = EventBus.isAsync(sysEventListener.getClass());
        return this._bind(async ? this.asyncSysEventListeners : this.sysEventListeners, sysEventId, sysEventListener);
    }

    public EventBus bind(Class<? extends EventObject> eventType, ActEventListener eventListener) {
        boolean async = EventBus.isAsync(eventListener.getClass()) || EventBus.isAsync(eventType);
        return this._bind(async ? this.asyncActEventListeners : this.actEventListeners, eventType, eventListener, 0);
    }

    public EventBus bind(Class<? extends EventObject> eventType, ActEventListener eventListener, int ttl) {
        boolean async = EventBus.isAsync(eventListener.getClass()) || EventBus.isAsync(eventType);
        return this._bind(async ? this.asyncActEventListeners : this.actEventListeners, eventType, eventListener, ttl);
    }

    public EventBus bind(Object event, SimpleEventListener eventListener) {
        return this._bind(event, eventListener, eventListener.isAsync() || EventBus._isAsync(event));
    }

    public synchronized EventBus bindAsync(SysEventId sysEventId, SysEventListener sysEventListener) {
        return this._bind(this.asyncSysEventListeners, sysEventId, sysEventListener);
    }

    public EventBus bindAsync(Class<? extends EventObject> eventType, ActEventListener eventListener) {
        return this._bind(this.asyncActEventListeners, eventType, eventListener, 0);
    }

    public EventBus bindAsync(Class<? extends EventObject> eventType, ActEventListener eventListener, int ttl) {
        return this._bind(this.asyncActEventListeners, eventType, eventListener, ttl);
    }

    public EventBus bindAsync(Object event, SimpleEventListener eventListener) {
        return this._bind(event, eventListener, true);
    }

    public synchronized EventBus bindSync(SysEventId sysEventId, SysEventListener sysEventListener) {
        return this._bind(this.sysEventListeners, sysEventId, sysEventListener);
    }

    public EventBus bindSync(Class<? extends EventObject> eventType, ActEventListener eventListener) {
        return this._bind(this.actEventListeners, eventType, eventListener, 0);
    }

    public EventBus bindSync(Class<? extends EventObject> eventType, ActEventListener eventListener, int ttl) {
        return this._bind(this.actEventListeners, eventType, eventListener, ttl);
    }

    public synchronized EventBus emit(SysEventId eventId) {
        if (this.isDestroyed()) {
            return this;
        }
        if (null != this.onceBus) {
            this.onceBus.emit(eventId);
        }
        return this._emit(true, false, eventId);
    }

    public EventBus emit(Enum<?> event, Object ... args) {
        return this._emitWithOnceBus(this.eventContext(event, args));
    }

    public EventBus emit(String event, Object ... args) {
        return this._emitWithOnceBus(this.eventContext(event, args));
    }

    public EventBus emit(EventObject event, Object ... args) {
        return this._emitWithOnceBus(this.eventContext(event, args));
    }

    public EventBus emit(ActEvent event, Object ... args) {
        return this._emitWithOnceBus(this.eventContext(event, args));
    }

    public synchronized EventBus emitAsync(SysEventId eventId) {
        if (this.isDestroyed()) {
            return this;
        }
        if (null != this.onceBus) {
            this.onceBus.emit(eventId);
        }
        return this._emit(true, true, eventId);
    }

    public EventBus emitAsync(Enum<?> event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextAsync(event, args));
    }

    public EventBus emitAsync(String event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextAsync(event, args));
    }

    public EventBus emitAsync(EventObject event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextAsync(event, args));
    }

    public EventBus emitAsync(ActEvent event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextAsync(event, args));
    }

    public synchronized EventBus emitSync(SysEventId eventId) {
        if (this.isDestroyed()) {
            return this;
        }
        if (null != this.onceBus) {
            this.onceBus.emit(eventId);
        }
        return this._emit(false, false, eventId);
    }

    public EventBus emitSync(Enum<?> event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextSync(event, args));
    }

    public EventBus emitSync(String event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextSync(event, args));
    }

    public EventBus emitSync(EventObject event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextSync(event, args));
    }

    public EventBus emitSync(ActEvent event, Object ... args) {
        return this._emitWithOnceBus(this.eventContextSync(event, args));
    }

    public EventBus trigger(SysEventId eventId) {
        return this.emit(eventId);
    }

    public synchronized EventBus once(Class<? extends EventObject> eventType, OnceEventListenerBase listener) {
        if (null != this.onceBus) {
            this.onceBus.bind(eventType, listener);
        } else {
            this.bind(eventType, listener);
        }
        return this;
    }

    public EventBus trigger(Enum<?> event, Object ... args) {
        return this.emit(event, args);
    }

    public EventBus trigger(String event, Object ... args) {
        return this.emit(event, args);
    }

    public EventBus trigger(EventObject event, Object ... args) {
        return this.emit(event, args);
    }

    public EventBus trigger(ActEvent event, Object ... args) {
        return this.emit(event, args);
    }

    public EventBus triggerAsync(SysEventId eventId) {
        return this.emitAsync(eventId);
    }

    public EventBus triggerAsync(Enum<?> event, Object ... args) {
        return this.emitAsync(event, args);
    }

    public EventBus triggerAsync(String event, Object ... args) {
        return this.emitAsync(event, args);
    }

    public EventBus triggerAsync(EventObject event, Object ... args) {
        return this.emitAsync(event, args);
    }

    public EventBus triggerAsync(ActEvent event, Object ... args) {
        return this.emitAsync(event, args);
    }

    public EventBus triggerSync(SysEventId eventId) {
        return this.emitSync(eventId);
    }

    public EventBus triggerSync(Enum<?> event, Object ... args) {
        return this.emitSync(event, args);
    }

    public EventBus triggerSync(String event, Object ... args) {
        return this.emitSync(event, args);
    }

    public EventBus triggerSync(EventObject event, Object ... args) {
        return this.emitSync(event, args);
    }

    public EventBus triggerSync(ActEvent event, Object ... args) {
        return this.emitSync(event, args);
    }

    private EventBus _bind(List[] listeners, SysEventId sysEventId, SysEventListener<?> l) {
        if (this.callNowIfEmitted(sysEventId, l)) {
            return this;
        }
        List list = listeners[sysEventId.ordinal()];
        if (!list.contains(l)) {
            list.add(l);
        }
        return this;
    }

    private synchronized EventBus _bind(final ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> listeners, final Class<? extends EventObject> eventType, final ActEventListener listener, int ttl) {
        ArrayList<ActEventListener> newList;
        this.eventsWithActListeners.add(eventType);
        ArrayList<ActEventListener> list = (ArrayList<ActEventListener>)listeners.get(eventType);
        if (null == list && null == (list = (List)listeners.putIfAbsent(eventType, newList = new ArrayList<ActEventListener>()))) {
            list = newList;
        }
        if (!list.contains(listener)) {
            list.add(listener);
            if (ttl > 0) {
                this.app().jobManager().delay(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        EventBus eventBus = EventBus.this;
                        synchronized (eventBus) {
                            EventBus.this._unbind(listeners, eventType, listener);
                        }
                    }
                }, (long)ttl, TimeUnit.SECONDS);
            }
        }
        return this;
    }

    private EventBus _bind(Object event, final SimpleEventListener eventListener, boolean async) {
        Key key = new Key(event, eventListener);
        if (key.idType == Key.IdType.CLASS) {
            Class type = (Class)$.cast((Object)key.id);
            if (EventObject.class.isAssignableFrom(type) && 1 == key.argTypes.length) {
                Class eventType = (Class)$.cast((Object)type);
                ActEventListenerBase actEventListener = new ActEventListenerBase(){

                    @Override
                    public void on(EventObject event) {
                        eventListener.invoke(event);
                    }
                };
                if (async) {
                    this.bindAsync(eventType, actEventListener);
                } else {
                    this.bindSync(eventType, actEventListener);
                }
                return this;
            }
            this.classesWithAdhocListeners.add(type);
        } else if (key.idType == Key.IdType.ENUM) {
            this.enumsWithAdhocListeners.add((Enum)event);
        } else {
            this.stringsWithAdhocListeners.add((String)event);
        }
        return this._bind(async ? this.asyncAdhocEventListeners : this.adhocEventListeners, key, eventListener);
    }

    private EventBus _bind(ConcurrentMap<Key, List<SimpleEventListener>> listeners, Key key, SimpleEventListener eventListener) {
        ArrayList<SimpleEventListener> newList;
        ArrayList<SimpleEventListener> list = (ArrayList<SimpleEventListener>)listeners.get(key);
        if (null == list && null == (list = (List)listeners.putIfAbsent(key, newList = new ArrayList<SimpleEventListener>()))) {
            list = newList;
        }
        if (!list.contains(eventListener)) {
            list.add(eventListener);
        }
        return this;
    }

    private List<Key> _emit(boolean asyncForAsync, boolean asyncForSync, List<Key> keys, Object event, Object ... args) {
        if (keys.isEmpty()) {
            return keys;
        }
        if (this.isTraceEnabled()) {
            String s = " ";
            if (asyncForAsync && asyncForSync) {
                s = "asynchronously";
            } else if (!asyncForAsync && !asyncForSync) {
                s = "synchronously";
            }
            this.trace("emitting event with parameters %s: %s %s", s, event, $.toString2((Object)args));
        }
        for (Key key : keys) {
            this._emit(key, this.asyncAdhocEventListeners, asyncForAsync);
            this._emit(key, this.adhocEventListeners, asyncForSync);
        }
        return keys;
    }

    private EventBus _emit(boolean asyncForAsync, boolean asyncForSync, SysEventId eventId) {
        if (this.isTraceEnabled()) {
            String s = " ";
            if (asyncForAsync && asyncForSync) {
                s = "asynchronously";
            } else if (!asyncForAsync && !asyncForSync) {
                s = "synchronously";
            }
            this.trace("emitting system event[%s] %s", new Object[]{eventId, s});
        }
        SysEvent event = this.lookUpSysEvent(eventId);
        this.callOn(event, this.asyncSysEventListeners, true);
        this.callOn(event, this.sysEventListeners, false);
        return this;
    }

    private void _emit(Key key, ConcurrentMap<Key, List<SimpleEventListener>> listeners, boolean async) {
        List list = (List)listeners.get(key);
        if (null == list) {
            return;
        }
        final Object[] args = key.args;
        JobManager jobManager = async ? this.app().jobManager() : null;
        for (final SimpleEventListener listener : list) {
            if (async) {
                jobManager.now(new Runnable(){

                    @Override
                    public void run() {
                        EventBus.this.callOn(listener, args);
                    }
                });
                continue;
            }
            this.callOn(listener, args);
        }
    }

    private EventBus _emitWithOnceBus(StringEventContext context) {
        if (this.isDestroyed()) {
            return this;
        }
        if (null != this.onceBus) {
            this.onceBus._emitWithOnceBus(context);
        }
        if (context.shouldCallAdhocEventListeners(this)) {
            this._emit(context.asyncForAsync, context.asyncForSync, context.keys(this), context.event, context.args);
        }
        return this;
    }

    private EventBus _emitWithOnceBus(EnumEventContext context) {
        if (this.isDestroyed()) {
            return this;
        }
        if (null != this.onceBus) {
            this.onceBus._emitWithOnceBus(context);
        }
        if (context.shouldCallAdhocEventListeners(this)) {
            this._emit(context.asyncForAsync, context.asyncForSync, context.keys(this), context.event, context.args);
        }
        return this;
    }

    private EventBus _emitWithOnceBus(EventObjectContext<? extends EventObject> context) {
        if (this.isDestroyed()) {
            return this;
        }
        if (null != this.onceBus) {
            this.onceBus._emitWithOnceBus(context);
        }
        if (context.shouldCallActEventListeners(this)) {
            this.callOn(context.eventType(), (EventObject)context.event, this.asyncActEventListeners, context.asyncForAsync);
            this.callOn(context.eventType(), (EventObject)context.event, this.actEventListeners, context.asyncForSync);
        }
        if (context.shouldCallAdhocEventListeners(this)) {
            this._emit(context.asyncForAsync, context.asyncForSync, context.keys(this), context.event, context.args);
        }
        return this;
    }

    private synchronized EventBus _unbind(Map<Class<? extends EventObject>, List<ActEventListener>> listeners, Class<? extends EventObject> c, ActEventListener l) {
        List<ActEventListener> list = listeners.get(c);
        if (null != list) {
            list.remove(l);
        }
        return this;
    }

    private void callOn(SimpleEventListener l, Object[] args) {
        l.invoke(args);
    }

    private boolean callOn(EventObject e, ActEventListener l) {
        try {
            if (l instanceof OnceEventListener) {
                return ((OnceEventListener)((Object)l)).tryHandle(e);
            }
            l.on(e);
            return true;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw E.unexpected((Throwable)x, (String)x.getMessage(), (Object[])new Object[0]);
        }
    }

    private <T extends EventObject> void callOn(final T event, List<? extends ActEventListener> listeners, boolean async) {
        if (null == listeners) {
            return;
        }
        JobManager jobManager = null;
        if (async) {
            jobManager = this.app().jobManager();
        }
        C.Set toBeRemoved = C.newSet();
        for (final ActEventListener actEventListener : listeners) {
            if (!async) {
                boolean result = this.callOn(event, actEventListener);
                if (!result || !this.once) continue;
                toBeRemoved.add(actEventListener);
                continue;
            }
            jobManager.now(new Runnable(){

                @Override
                public void run() {
                    EventBus.this.callOn(event, actEventListener);
                }
            });
        }
        if (this.once && !toBeRemoved.isEmpty()) {
            listeners.removeAll((Collection<?>)toBeRemoved);
        }
    }

    private void callOn(SysEvent event, List[] sysEventListeners, boolean async) {
        List ll = sysEventListeners[event.id()];
        this.callOn(event, ll, async);
    }

    private <EVT extends EventObject> void callOn(Class<? extends EventObject> eventType, EVT event, Map<Class<? extends EventObject>, List<ActEventListener>> listeners, boolean async) {
        List<ActEventListener> list = listeners.get(eventType);
        this.callOn(event, list, async);
    }

    private boolean callNowIfEmitted(SysEventId sysEventId, SysEventListener l) {
        if (this.app().eventEmitted(sysEventId)) {
            try {
                l.on(this.lookUpSysEvent(sysEventId));
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e, "error calling event handler");
            }
            return true;
        }
        return false;
    }

    private ActEventContext eventContext(ActEvent<?> event, Object ... args) {
        return new ActEventContext(event, args);
    }

    private EventObjectContext eventContext(EventObject event, Object ... args) {
        return new EventObjectContext<EventObject>(event, args);
    }

    private StringEventContext eventContext(String event, Object ... args) {
        return new StringEventContext(event, args);
    }

    private EnumEventContext eventContext(Enum event, Object ... args) {
        return new EnumEventContext(event, args);
    }

    private ActEventContext eventContextAsync(ActEvent<?> event, Object ... args) {
        return new ActEventContext(true, true, event, args);
    }

    private EventObjectContext eventContextAsync(EventObject event, Object ... args) {
        return new EventObjectContext<EventObject>(true, true, event, args);
    }

    private StringEventContext eventContextAsync(String event, Object ... args) {
        return new StringEventContext(true, true, event, args);
    }

    private EnumEventContext eventContextAsync(Enum event, Object ... args) {
        return new EnumEventContext(true, true, event, args);
    }

    private ActEventContext eventContextSync(ActEvent<?> event, Object ... args) {
        return new ActEventContext(false, false, event, args);
    }

    private EventObjectContext eventContextSync(EventObject event, Object ... args) {
        return new EventObjectContext<EventObject>(false, false, event, args);
    }

    private StringEventContext eventContextSync(String event, Object ... args) {
        return new StringEventContext(false, false, event, args);
    }

    private EnumEventContext eventContextSync(Enum event, Object ... args) {
        return new EnumEventContext(false, false, event, args);
    }

    private SysEvent[] initSysEventLookup(App app) {
        SysEventId[] ids = SysEventId.values();
        int len = ids.length;
        SysEvent[] events = new SysEvent[len];
        for (int i = 0; i < len; ++i) {
            SysEventId id = ids[i];
            events[id.ordinal()] = id.of(app);
        }
        return events;
    }

    private List[] initAppListenerArray() {
        SysEventId[] ids = SysEventId.values();
        int len = ids.length;
        List[] l = new List[len];
        for (int i = 0; i < len; ++i) {
            l[i] = new ArrayList();
        }
        return l;
    }

    private void loadDefaultEventListeners() {
        this.loadDiBinderListener();
    }

    private void loadDiBinderListener() {
        this.bind(DependencyInjectionBinder.class, new ActEventListenerBase<DependencyInjectionBinder>(){

            @Override
            public void on(DependencyInjectionBinder event) throws Exception {
                Object injector = EventBus.this.app().injector();
                if (null == injector) {
                    LOGGER.warn("Dependency injector not found");
                } else {
                    injector.registerDiBinder(event);
                }
            }
        });
    }

    private SysEvent lookUpSysEvent(SysEventId id) {
        return this.sysEventLookup[id.ordinal()];
    }

    private void releaseSysEventListeners(List[] array) {
        for (List l : array) {
            Destroyable.Util.destroyAll(l, ApplicationScoped.class);
            l.clear();
        }
    }

    private void releaseActEventListeners(Map<?, List<ActEventListener>> listeners) {
        for (List<ActEventListener> l : listeners.values()) {
            Destroyable.Util.destroyAll(l, ApplicationScoped.class);
            l.clear();
        }
        listeners.clear();
    }

    private void releaseAdhocEventListeners(ConcurrentMap<Key, List<SimpleEventListener>> listeners) {
        for (List l : listeners.values()) {
            Destroyable.Util.tryDestroyAll(l, ApplicationScoped.class);
            l.clear();
        }
        listeners.clear();
    }

    private boolean hasAdhocEventListenerFor(Enum event) {
        return this.enumsWithAdhocListeners.contains(event) || this.classesWithAdhocListeners.contains(event.getDeclaringClass());
    }

    private boolean hasAdhocEventListenerFor(String event) {
        return this.stringsWithAdhocListeners.contains(event);
    }

    private boolean hasAdhocEventListenerFor(EventObject event) {
        return this.classesWithAdhocListeners.contains(event.getClass());
    }

    public static boolean isAsync(AnnotatedElement c) {
        Annotation[] aa;
        for (Annotation a : aa = c.getAnnotations()) {
            if (!a.annotationType().getSimpleName().startsWith("Async")) continue;
            return true;
        }
        return false;
    }

    private static boolean _isAsync(Object eventId) {
        return eventId instanceof Class && EventBus.isAsync((Class)eventId);
    }

    private static class ActEventContext
    extends EventObjectContext<ActEvent<?>> {
        ActEventContext(ActEvent<?> event, Object[] args) {
            super(event, args);
        }

        ActEventContext(boolean asyncForAsync, boolean asyncForSync, ActEvent<?> event, Object[] args) {
            super(asyncForAsync, asyncForSync, event, args);
        }

        @Override
        Class<? extends ActEvent<?>> lookupEventType() {
            return ActEvent.typeOf((ActEvent)this.event);
        }
    }

    private static class EventObjectContext<T extends EventObject>
    extends EventContext<T> {
        EventObjectContext(T event, Object[] args) {
            super(event, args);
        }

        EventObjectContext(boolean asyncForAsync, boolean asyncForSync, T event, Object[] args) {
            super(asyncForAsync, asyncForSync, event, args);
        }

        @Override
        Class<? extends T> lookupEventType() {
            return (Class)$.cast(ActEvent.typeOf((EventObject)this.event));
        }

        @Override
        boolean shouldCallAdhocEventListeners(EventBus eventBus) {
            return eventBus.hasAdhocEventListenerFor((EventObject)this.event);
        }
    }

    private static class StringEventContext
    extends EventContext<String> {
        StringEventContext(String event, Object[] args) {
            super(event, args);
        }

        StringEventContext(boolean asyncForAsync, boolean asyncForSync, String event, Object[] args) {
            super(asyncForAsync, asyncForSync, event, args);
        }

        @Override
        boolean shouldCallAdhocEventListeners(EventBus eventBus) {
            return eventBus.hasAdhocEventListenerFor((String)this.event);
        }
    }

    private static class EnumEventContext
    extends EventContext<Enum> {
        EnumEventContext(Enum event, Object[] args) {
            super(event, args);
        }

        EnumEventContext(boolean asyncForAsync, boolean asyncForSync, Enum event, Object[] args) {
            super(asyncForAsync, asyncForSync, event, args);
        }

        @Override
        Class<? extends Enum> lookupEventType() {
            return ((Enum)this.event).getDeclaringClass();
        }

        @Override
        boolean shouldCallAdhocEventListeners(EventBus eventBus) {
            return eventBus.hasAdhocEventListenerFor((Enum)this.event);
        }
    }

    private static abstract class EventContext<T> {
        boolean asyncForAsync = true;
        boolean asyncForSync = false;
        Class<? extends T> eventType;
        List<Key> keys;
        List<Key> keysForOnceBus;
        T event;
        Object[] args;

        EventContext(T event, Object[] args) {
            this.event = event;
            this.args = args;
        }

        EventContext(boolean asyncForAsync, boolean asyncForSync, T event, Object[] args) {
            this(event, args);
            this.asyncForAsync = asyncForAsync;
            this.asyncForSync = asyncForSync;
        }

        final Class<? extends T> eventType() {
            if (null == this.eventType) {
                this.eventType = this.lookupEventType();
            }
            return this.eventType;
        }

        List<Key> keys(EventBus eventBus) {
            if (eventBus.once) {
                if (null == this.keysForOnceBus) {
                    this.keysForOnceBus = Key.keysOf(this.eventType(), this.event, this.args, eventBus);
                }
                return this.keysForOnceBus;
            }
            if (null == this.keys) {
                this.keys = Key.keysOf(this.eventType(), this.event, this.args, eventBus);
            }
            return this.keys;
        }

        boolean hasArgs() {
            return 0 < this.args.length;
        }

        boolean shouldCallActEventListeners(EventBus eventBus) {
            return !this.hasArgs() && eventBus.eventsWithActListeners.contains(this.eventType());
        }

        Class<? extends T> lookupEventType() {
            return (Class)$.cast(this.event.getClass());
        }

        abstract boolean shouldCallAdhocEventListeners(EventBus var1);
    }

    private static class Key {
        private static Logger logger = LogManager.get(EventBus.class);
        private static final Class[] EMPTY_ARG_LIST = new Class[0];
        private Object id;
        private IdType idType;
        private Class[] argTypes;
        private boolean varargs;
        private Object[] args;
        private static Class<?> VARARG_TYPE = Object[].class;
        private static ConcurrentMap<Class, Class> typeMap = new ConcurrentHashMap<Class, Class>();

        Key(Object id, SimpleEventListener eventListener) {
            this.setId(id);
            this.setArgTypes(eventListener);
        }

        Key(Object id, List<Class> argTypeList, Object[] args) {
            this(id, argTypeList, args, false);
        }

        Key(Object id, List<Class> argTypeList, Object[] args, boolean varargs) {
            this.setId(id);
            this.argTypes = Key.convert(argTypeList);
            this.args = args;
            this.varargs = varargs;
        }

        private void setArgTypes(SimpleEventListener eventListener) {
            List<Class> argTypeList = eventListener.argumentTypes();
            if (null == argTypeList || argTypeList.isEmpty()) {
                this.argTypes = EMPTY_ARG_LIST;
                return;
            }
            Class arg0Type = argTypeList.get(0);
            this.argTypes = Key.convert(argTypeList);
            int varargsIdx = 1;
            if (this.id != arg0Type && !arg0Type.isInstance(this.id)) {
                E.illegalArgumentIf((this.idType == IdType.CLASS ? 1 : 0) != 0, (String)"The first argument in the event listener argument list must be event when binding to an event class (Enum or EventObject). \n\t listener: %s \n\t event: %s", (Object[])new Object[]{eventListener, this.id});
                varargsIdx = 0;
            }
            this.varargs = varargsIdx + 1 == argTypeList.size() && Object[].class == argTypeList.get(varargsIdx);
        }

        private void setId(Object id) {
            this.idType = Key.typeOf(id);
            this.id = IdType.CLASS == this.idType && !(id instanceof Class) ? id.getClass() : id;
        }

        static IdType typeOf(Object id) {
            Class<?> type;
            if (id instanceof String) {
                return IdType.STRING;
            }
            if (Enum.class.isInstance(id)) {
                return IdType.ENUM;
            }
            Class<?> clazz = type = id instanceof Class ? (Class<?>)id : id.getClass();
            if (Enum.class.isAssignableFrom(type) || EventObject.class.isAssignableFrom(type)) {
                return IdType.CLASS;
            }
            throw E.unexpected((String)"Invalid event type: %s", (Object[])new Object[]{id});
        }

        private static Class[] convert(List<Class> argList) {
            int sz = argList.size();
            Class[] ca = argList.toArray(new Class[sz]);
            for (int i = 0; i < sz; ++i) {
                ca[i] = $.wrapperClassOf((Class)ca[i]);
            }
            return ca;
        }

        private static Class effectiveTypeOf(Object o) {
            return Key.effectiveTypeOf(o.getClass());
        }

        private static Class effectiveTypeOf(Class<?> type) {
            if (null == type || Object.class == type) {
                return type;
            }
            Class<?> mappedType = (Class<?>)typeMap.get(type);
            if (null == mappedType) {
                int modifiers = type.getModifiers();
                if (!Modifier.isPublic(modifiers) || type.isAnonymousClass() || type.isLocalClass() || type.isMemberClass()) {
                    Class<?>[] ca = type.getInterfaces();
                    if (ca.length > 0) {
                        for (Class<?> intf : ca) {
                            if (!Modifier.isPublic(intf.getModifiers())) continue;
                            mappedType = intf;
                        }
                    }
                    if (null == mappedType) {
                        Class<?> parent = type.getSuperclass();
                        mappedType = null == parent || Object.class == parent ? type : Key.effectiveTypeOf(parent);
                    }
                    typeMap.putIfAbsent(type, mappedType);
                } else {
                    typeMap.putIfAbsent(type, type);
                    mappedType = type;
                }
            }
            return mappedType;
        }

        static List<Key> keysOf(Class<?> idClass, Object id, Object[] args, EventBus eventBus) {
            IdType type;
            ArrayList<Key> keys = new ArrayList<Key>();
            ArrayList<Class> argTypes = new ArrayList<Class>();
            ArrayList<Class> varArgTypes = new ArrayList<Class>();
            varArgTypes.add(VARARG_TYPE);
            for (Object arg : args) {
                if (null == arg) {
                    argTypes = null;
                    break;
                }
                argTypes.add(Key.effectiveTypeOf(arg));
            }
            if (IdType.STRING == (type = Key.typeOf(id))) {
                if (!eventBus.stringsWithAdhocListeners.contains(id)) {
                    return C.list();
                }
                if (null != argTypes) {
                    keys.add(new Key(id, argTypes, args));
                }
                keys.add(new Key(id, varArgTypes, new Object[]{args}));
            } else if (IdType.CLASS == type) {
                if (!eventBus.classesWithAdhocListeners.contains(idClass)) {
                    return C.list();
                }
                varArgTypes.add(0, idClass);
                Object[] varArgs = new Object[]{id, args};
                keys.add(new Key(id, varArgTypes, varArgs));
                if (null != argTypes) {
                    Object[] finalArgs = $.concat((Object[])new Object[]{id}, (Object[])args);
                    argTypes.add(0, idClass);
                    keys.add(new Key(id, argTypes, finalArgs));
                }
            } else {
                if (eventBus.enumsWithAdhocListeners.contains(id)) {
                    keys.add(new Key(id, varArgTypes, new Object[]{args}));
                    if (null != argTypes) {
                        keys.add(new Key(id, argTypes, args));
                    }
                }
                if (eventBus.classesWithAdhocListeners.contains(id.getClass())) {
                    ArrayList<Class> varArgTypesForClass = new ArrayList<Class>(2);
                    Object[] varArgs = new Object[]{id, args};
                    varArgTypesForClass.add(id.getClass());
                    varArgTypesForClass.add(VARARG_TYPE);
                    keys.add(new Key(id.getClass(), varArgTypesForClass, varArgs, true));
                    if (null != argTypes) {
                        ArrayList<Class> argTypesForClass = new ArrayList<Class>(1 + argTypes.size());
                        argTypesForClass.add(id.getClass());
                        argTypesForClass.addAll(argTypes);
                        keys.add(new Key(id.getClass(), argTypesForClass, $.concat((Object[])new Object[]{id}, (Object[])args), true));
                    }
                }
            }
            return keys;
        }

        public int hashCode() {
            return $.hc((Object)this.id, (Object)this.argTypes);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key that = (Key)$.cast((Object)obj);
                return $.eq((Object)that.id, (Object)this.id) && $.eq2((Object)that.argTypes, (Object)this.argTypes);
            }
            return false;
        }

        public String toString() {
            return !this.varargs ? S.fmt((String)"(%s, %s)", (Object[])new Object[]{this.id, $.toString2((Object)this.argTypes)}) : S.fmt((String)"(%s, ...)", (Object[])new Object[]{this.id});
        }

        private static enum IdType {
            STRING,
            ENUM,
            CLASS;

        }
    }
}

