/*
 * Decompiled with CFR 0.152.
 */
package act.event.bytecode;

import act.Act;
import act.app.App;
import act.event.EventBus;
import act.event.SimpleEventListener;
import act.inject.param.ParamValueLoaderService;
import java.lang.reflect.Method;
import java.util.List;
import org.osgl.$;
import org.osgl.inject.BeanSpec;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class ReflectedSimpleEventListener
implements SimpleEventListener {
    private volatile transient Object host;
    private C.List<Class> paramTypes;
    private C.List<Class> providedParamTypes;
    private final Class<?> hostClass;
    private final Method method;
    private final int providedParamSize;
    private final boolean isStatic;
    private final boolean isAsync;

    ReflectedSimpleEventListener(String className, String methodName, List<BeanSpec> paramTypes, boolean isStatic) {
        this.isStatic = isStatic;
        this.paramTypes = C.newList();
        this.providedParamTypes = C.newList();
        Object injector = Act.injector();
        boolean cutOff = false;
        if (null == paramTypes) {
            paramTypes = C.list();
        }
        for (int i = paramTypes.size() - 1; i >= 0; --i) {
            BeanSpec spec = (BeanSpec)paramTypes.get(i);
            if (ParamValueLoaderService.provided(spec, injector)) {
                E.unexpectedIf((boolean)cutOff, (String)"provided(injected) argument must be put at the end of passed in argument list", (Object[])new Object[0]);
                this.providedParamTypes.add((Object)spec.rawType());
                continue;
            }
            cutOff = true;
            this.paramTypes.add((Object)spec.rawType());
        }
        this.paramTypes = this.paramTypes.reverse();
        this.providedParamSize = this.providedParamTypes.size();
        if (this.providedParamSize > 0) {
            this.providedParamTypes = this.providedParamTypes.reverse();
        }
        Class[] argList = new Class[paramTypes.size()];
        for (int i = 0; i < argList.length; ++i) {
            argList[i] = ((BeanSpec)paramTypes.get(i)).rawType();
        }
        this.hostClass = Act.app().classForName(className);
        this.method = $.getMethod(this.hostClass, (String)methodName, (Class[])argList);
        this.isAsync = EventBus.isAsync(this.hostClass) || EventBus.isAsync(this.method);
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    public void invoke(Object ... args) {
        Object host;
        int paramNo = this.paramTypes.size();
        int argsNo = args.length;
        Object[] realArgs = args;
        if (paramNo != argsNo || this.providedParamSize > 0) {
            realArgs = new Object[paramNo + this.providedParamSize];
            System.arraycopy(args, 0, realArgs, 0, Math.min(paramNo, argsNo));
            App app = Act.app();
            for (int i = 0; i < this.providedParamSize; ++i) {
                realArgs[i + paramNo] = app.getInstance((Class)this.providedParamTypes.get(i));
            }
        }
        if (null == (host = this.host())) {
            $.invokeStatic((Method)this.method, (Object[])realArgs);
        } else {
            $.invokeVirtual((Object)host, (Method)this.method, (Object[])realArgs);
        }
    }

    @Override
    public List<Class> argumentTypes() {
        return this.paramTypes;
    }

    public String toString() {
        return S.fmt((String)"%s.%s(%s)", (Object[])new Object[]{this.hostClass, this.method.getName(), S.strip(this.paramTypes, (String)"[", (String)"]")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object host() {
        if (this.isStatic) {
            return null;
        }
        if (null == this.host) {
            ReflectedSimpleEventListener reflectedSimpleEventListener = this;
            synchronized (reflectedSimpleEventListener) {
                if (null == this.host) {
                    App app = App.instance();
                    this.host = app.getInstance(this.hostClass);
                }
            }
        }
        return this.host;
    }
}

