/*
 * Decompiled with CFR 0.152.
 */
package act.inject.genie;

import act.Act;
import act.app.App;
import act.app.AppClassLoader;
import act.conf.AppConfig;
import act.inject.DefaultValue;
import act.util.ClassNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.InjectException;
import org.osgl.inject.loader.AnnotatedElementLoader;
import org.osgl.inject.loader.ConfigurationValueLoader;
import org.osgl.inject.loader.TypedElementLoader;
import org.osgl.inject.util.ArrayLoader;
import org.osgl.util.C;
import org.osgl.util.S;

class GenieProviders {
    private static final AnnotatedElementLoader _ANNO_ELEMENT_LOADER = new AnnotatedElementLoader(){

        protected List<Class<?>> load(Class<? extends Annotation> aClass, final boolean loadNonPublic, final boolean loadAbstract) {
            final AppClassLoader cl = GenieProviders.app().classLoader();
            ClassNode root = cl.classInfoRepository().node(aClass.getName());
            if (null == root) {
                return C.list();
            }
            final ArrayList list = new ArrayList();
            Lang.Visitor<ClassNode> visitor = new Lang.Visitor<ClassNode>(){

                public void visit(ClassNode classNode) throws Lang.Break {
                    Class c = $.classForName((String)classNode.name(), (ClassLoader)cl);
                    list.add(c);
                }
            };
            for (ClassNode node : root.annotatedClasses()) {
                $.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

                    public boolean test(ClassNode classNode) {
                        if (!loadNonPublic && !classNode.isPublic()) {
                            return false;
                        }
                        return loadAbstract || !classNode.isAbstract();
                    }
                }, (Lang.Visitor)visitor).visit((Object)node);
            }
            return list;
        }
    };
    public static final Provider<ConfigurationValueLoader> CONF_VALUE_LOADER = new Provider<ConfigurationValueLoader>(){

        public ConfigurationValueLoader get() {
            return new ConfigurationValueLoader(){

                protected void initialized() {
                    super.initialized();
                    if (S.notBlank((String)this.defaultValue)) {
                        return;
                    }
                    DefaultValue defaultValue = (DefaultValue)this.spec.getAnnotation(DefaultValue.class);
                    if (null != defaultValue) {
                        this.defaultValue = defaultValue.value();
                    }
                }

                public Object get() {
                    AppConfig<?> appConfig = GenieProviders.app().config();
                    Object injector = Act.injector();
                    String confKey = this.value().toString();
                    boolean isImpl = confKey.endsWith(".impl");
                    if (this.spec.isInstanceOf(Map.class)) {
                        String prefix = confKey;
                        Map<String, Object> confMap = appConfig.subSet(prefix);
                        Map retVal = (Map)injector.get(this.spec.rawType());
                        List typeParams = this.spec.typeParams();
                        Class<Object> valType = null != typeParams && typeParams.size() > 1 ? (Type)typeParams.get(1) : Object.class;
                        BeanSpec valSpec = BeanSpec.of(valType, injector);
                        int pos = prefix.length() + 1;
                        for (String key : confMap.keySet()) {
                            if (S.eq((String)key, (String)prefix)) continue;
                            Object val = confMap.get(key);
                            retVal.put(key.substring(pos), null == val ? null : this.cast(S.string((Object)val), valSpec, isImpl));
                        }
                        return retVal;
                    }
                    if (this.spec.isInstanceOf(Collection.class) || this.spec.isArray()) {
                        Object val;
                        try {
                            val = appConfig.get(confKey);
                        }
                        catch (Exception e) {
                            val = appConfig.rawConfiguration().get(confKey);
                        }
                        if (this.spec.isInstance(val)) {
                            return val;
                        }
                        return this.cast(null == val ? null : val.toString(), this.spec, isImpl);
                    }
                    if (S.isBlank((String)confKey)) {
                        throw new InjectException("Missing configuration key", new Object[0]);
                    }
                    Object conf = this.conf(confKey, this.defaultValue());
                    if (null == conf) {
                        return null;
                    }
                    if (this.spec.isInstance(conf)) {
                        return conf;
                    }
                    return this.cast(S.string((Object)conf), this.spec, isImpl);
                }

                protected Object conf(String s, String defaultValue) {
                    Object o = GenieProviders.app().config().get(s);
                    return null == o ? defaultValue : o;
                }

                private Object cast(String val, BeanSpec spec, boolean isImpl) {
                    if (null == val) {
                        return null;
                    }
                    if (spec.isInstanceOf(Collection.class)) {
                        Collection retVal = (Collection)Act.getInstance(spec.rawType());
                        List typeParams = spec.typeParams();
                        Class<Object> itemType = null != typeParams && typeParams.size() > 0 ? (Type)typeParams.get(0) : Object.class;
                        BeanSpec itemSpec = BeanSpec.of(itemType, Act.injector());
                        for (String itemVal : S.fastSplit((String)S.string((Object)val), (String)",")) {
                            retVal.add(this.cast(itemVal, itemSpec, isImpl));
                        }
                        return retVal;
                    }
                    if (spec.isArray()) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        BeanSpec itemSpec = spec.componentSpec();
                        for (String itemVal : S.fastSplit((String)S.string((Object)val), (String)",")) {
                            list.add(this.cast(itemVal, itemSpec, isImpl));
                        }
                        return ArrayLoader.listToArray(list, (Class)itemSpec.rawType());
                    }
                    Class type = spec.rawType();
                    if (type.isInstance(val)) {
                        return val;
                    }
                    if (isImpl) {
                        return $.newInstance((String)val, (ClassLoader)Act.app().classLoader());
                    }
                    if ($.isSimpleType((Class)type)) {
                        return Act.app().resolverManager().resolve(val, type);
                    }
                    try {
                        return $.newInstance((String)val, (ClassLoader)Act.app().classLoader());
                    }
                    catch (Exception e) {
                        throw new InjectException("Cannot cast value type[%s] to required type[%s]", new Object[]{val.getClass(), spec});
                    }
                }
            };
        }
    };
    public static final Provider<TypedElementLoader> TYPED_ELEMENT_LOADER = new Provider<TypedElementLoader>(){

        public TypedElementLoader get() {
            return new TypedElementLoader(){

                protected List<Class> load(Class aClass, final boolean loadNonPublic, final boolean loadAbstract, final boolean loadRoot) {
                    final AppClassLoader cl = GenieProviders.app().classLoader();
                    final ClassNode root = cl.classInfoRepository().node(aClass.getName());
                    if (null == root) {
                        return C.list();
                    }
                    final ArrayList<Class> list = new ArrayList<Class>();
                    Lang.Visitor<ClassNode> visitor = new Lang.Visitor<ClassNode>(){

                        public void visit(ClassNode classNode) throws Lang.Break {
                            Class c = $.classForName((String)classNode.name(), (ClassLoader)cl);
                            list.add(c);
                        }
                    };
                    root.visitTree((Lang.Function<ClassNode, ?>)$.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

                        public boolean test(ClassNode classNode) {
                            if (!loadNonPublic && !classNode.isPublic()) {
                                return false;
                            }
                            if (!loadAbstract && classNode.isAbstract()) {
                                return false;
                            }
                            return loadRoot || root != classNode;
                        }
                    }, (Lang.Visitor)visitor));
                    return list;
                }
            };
        }
    };
    public static final Provider<AnnotatedElementLoader> ANNOTATED_ELEMENT_LOADER = new Provider<AnnotatedElementLoader>(){

        public AnnotatedElementLoader get() {
            return _ANNO_ELEMENT_LOADER;
        }
    };

    private GenieProviders() {
    }

    private static App app() {
        return App.instance();
    }
}

