/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.app.ActionContext;
import act.app.App;
import act.inject.DefaultValue;
import act.inject.param.ParamValueLoader;
import act.inject.param.StringValueResolverValueLoaderBase;
import act.util.ActContext;
import java.util.ArrayList;
import java.util.Collection;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.util.ArrayLoader;
import org.osgl.util.AnnotationAware;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

class HeaderValueLoader
implements ParamValueLoader {
    private final String key;
    private final boolean multiValues;
    private final boolean isArray;
    private final Class elementType;
    private final Class targetType;
    private final StringValueResolver stringValueResolver;
    private final Object defVal;

    public HeaderValueLoader(String name, BeanSpec beanSpec) {
        this.key = this.key(name, beanSpec);
        this.targetType = beanSpec.rawType();
        this.isArray = this.targetType.isArray();
        boolean bl = this.multiValues = this.isArray || Collection.class.isAssignableFrom(this.targetType);
        this.elementType = this.isArray ? this.targetType.getComponentType() : (this.multiValues ? (Class)beanSpec.typeParams().get(0) : null);
        Class effectiveType = null != this.elementType ? this.elementType : this.targetType;
        this.stringValueResolver = App.instance().resolverManager().resolver(effectiveType, (AnnotationAware)beanSpec);
        E.illegalArgumentIf((null == this.stringValueResolver ? 1 : 0) != 0, (String)"Cannot find out StringValueResolver for %s", (Object[])new Object[]{beanSpec});
        DefaultValue defValAnno = (DefaultValue)beanSpec.getAnnotation(DefaultValue.class);
        this.defVal = null != defValAnno ? this.stringValueResolver.resolve(defValAnno.value()) : StringValueResolverValueLoaderBase.defVal(null, effectiveType);
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        if (context instanceof ActionContext) {
            return this.load((ActionContext)context, noDefaultValue);
        }
        throw E.unsupport();
    }

    private Object load(ActionContext context, boolean noDefaultValue) {
        if (this.multiValues) {
            Iterable iterable = context.req().headers(this.key);
            ArrayList<Object> list = new ArrayList<Object>();
            if (null != iterable) {
                for (String s : iterable) {
                    Object obj = this.stringValueResolver.resolve(s);
                    if (null == obj) continue;
                    list.add(obj);
                }
            }
            if (this.isArray) {
                return ArrayLoader.listToArray(list, (Class)this.elementType);
            }
            Collection c = (Collection)App.instance().injector().get(this.targetType);
            c.addAll(list);
            return c;
        }
        String value = context.req().header(this.key);
        Object obj = null == value ? null : this.stringValueResolver.resolve(value);
        return null == obj && !noDefaultValue ? this.defVal : obj;
    }

    @Override
    public String bindName() {
        return this.key;
    }

    private String key(String name, BeanSpec spec) {
        if (S.notBlank((String)name)) {
            return name;
        }
        name = spec.name();
        return Keyword.of((CharSequence)name).httpHeader();
    }
}

