/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.cli.tree.TreeNode;
import act.cli.view.CliView;
import act.inject.param.ParamKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ParamTreeNode
implements TreeNode {
    private ParamKey key;
    private String leafVal;
    private Map<String, ParamTreeNode> map;
    private List<ParamTreeNode> list;

    private ParamTreeNode(ParamKey path) {
        this.key = path;
    }

    @Override
    public String id() {
        return this.key.toString();
    }

    @Override
    public String label() {
        return this.id();
    }

    @Override
    public List<TreeNode> children() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (this.isList()) {
            list.addAll(this.list);
        } else if (this.isMap()) {
            list.addAll(this.map.values());
        }
        return list;
    }

    public String toString() {
        return this.id();
    }

    String debug() {
        return CliView.TREE.render(this, null, null);
    }

    ParamKey key() {
        return this.key;
    }

    boolean isLeaf() {
        return null != this.leafVal;
    }

    String value() {
        return this.leafVal;
    }

    boolean isMap() {
        return null != this.map;
    }

    Set<String> mapKeys() {
        return this.map.keySet();
    }

    Collection<ParamTreeNode> mapValues() {
        return this.map.values();
    }

    ParamTreeNode child(String name) {
        return this.map.get(name);
    }

    boolean isList() {
        return null != this.list;
    }

    List<ParamTreeNode> list() {
        return this.list;
    }

    void addListItem(ParamTreeNode item) {
        this.list.add(item);
    }

    void addChild(String key, ParamTreeNode child) {
        this.map.put(key, child);
    }

    static ParamTreeNode leaf(ParamKey key, String value) {
        ParamTreeNode node = new ParamTreeNode(key);
        node.leafVal = value;
        return node;
    }

    static ParamTreeNode map(ParamKey key) {
        ParamTreeNode node = new ParamTreeNode(key);
        node.map = new HashMap<String, ParamTreeNode>();
        return node;
    }

    static ParamTreeNode list(ParamKey key) {
        ParamTreeNode node = new ParamTreeNode(key);
        node.list = new ArrayList<ParamTreeNode>();
        return node;
    }
}

