/*
 * Decompiled with CFR 0.152.
 */
package act.internal.util;

import act.Act;
import act.internal.util.AppNameInferer;
import act.internal.util.JavaNames;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.osgl.$;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;
import osgl.version.Version;

public class AppDescriptor
implements Serializable {
    private static final Logger LOGGER = Act.LOGGER;
    private String appName;
    private String packageName;
    private Version version;

    private AppDescriptor(String appName, String packageName, Version version) {
        if (appName.startsWith("${")) {
            LOGGER.warn("app name is substitute variable - fallback to default app name");
            appName = S.afterLast((String)packageName, (String)".");
        }
        this.appName = appName;
        this.packageName = packageName;
        this.version = version;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isValid() {
        return !this.version.isUnknown();
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    public static AppDescriptor of(String appName, String packageName, Version appVersion) {
        String[] packages = packageName.split("[,;:\\s]+");
        String effectPackageName = packageName;
        if (packages.length > 0) {
            effectPackageName = packages[0];
        }
        E.illegalArgumentIf((!JavaNames.isPackageOrClassName(effectPackageName) ? 1 : 0) != 0, (String)("valid package name expected. found: " + effectPackageName));
        return new AppDescriptor(AppDescriptor.ensureAppName(appName, effectPackageName, (Version)$.notNull((Object)appVersion)), packageName, appVersion);
    }

    public static AppDescriptor of(String appName, Class<?> entryClass, Version appVersion) {
        return new AppDescriptor(AppDescriptor.ensureAppName(appName, entryClass, (Version)$.notNull((Object)appVersion)), JavaNames.packageNameOf(entryClass), appVersion);
    }

    public static AppDescriptor of(String appName, Class<?> entryClass) {
        return AppDescriptor.of(appName, entryClass, Version.of(entryClass));
    }

    public static AppDescriptor of(String appName, String packageName) {
        return AppDescriptor.of(appName, packageName, Version.ofPackage((String)packageName));
    }

    public static AppDescriptor of(String packageName) {
        return AppDescriptor.of(null, packageName);
    }

    public static AppDescriptor of(Class<?> entryClass) {
        return AppDescriptor.of(null, entryClass);
    }

    public static AppDescriptor deserializeFrom(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (AppDescriptor)ois.readObject();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        catch (ClassNotFoundException e) {
            throw E.unexpected((Throwable)e);
        }
    }

    private static String ensureAppName(String appName, Class<?> entryClass, Version version) {
        if (S.blank((String)appName)) {
            if (!version.isUnknown()) {
                appName = version.getArtifactId();
            }
            if (S.blank((String)appName)) {
                appName = AppNameInferer.from(entryClass);
            }
        }
        return appName;
    }

    private static String ensureAppName(String appName, String packageName, Version version) {
        if (S.blank((String)appName)) {
            if (!version.isUnknown()) {
                appName = version.getArtifactId();
            }
            if (S.blank((String)appName)) {
                appName = AppNameInferer.fromPackageName(packageName);
            }
        }
        return appName;
    }
}

