/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.app.App;
import act.app.event.SysEventId;
import act.conf.AppConfig;
import act.event.SysEventListenerBase;
import act.job.AlongWith;
import act.job.Cron;
import act.job.Every;
import act.job.FixedDelay;
import act.job.InvokeAfter;
import act.job.InvokeBefore;
import act.job.Job;
import act.job.JobManager;
import act.job.OnAppStart;
import act.job.OnAppStop;
import fc.cron.CronExpression;
import java.util.EventObject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;
import org.rythmengine.utils.Time;

public abstract class JobTrigger {
    protected static final Logger LOGGER = LogManager.get(JobTrigger.class);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected static boolean isTraceEnabled() {
        return LOGGER.isTraceEnabled();
    }

    protected static void trace(String msg, Object ... args) {
        LOGGER.trace(msg, args);
    }

    final void register(Job job, JobManager manager) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("trigger on [%s]: %s", new Object[]{this, job});
        }
        job.trigger(this);
        this.schedule(manager, job);
    }

    void scheduleFollowingCalls(JobManager manager, Job job) {
    }

    void schedule(JobManager manager, Job job) {
    }

    void traceSchedule(Job job) {
        if (JobTrigger.isTraceEnabled()) {
            JobTrigger.trace("trigger[%s] schedule job: %s", this, job);
        }
    }

    static JobTrigger of(AppConfig config, Cron anno) {
        String v = anno.value();
        if (v.startsWith("cron.")) {
            v = (String)config.get(v);
        } else if (v.startsWith("${") && v.endsWith("}")) {
            v = v.substring(2, v.length() - 1);
            v = (String)config.get(v);
        }
        if (S.blank((String)v)) {
            throw E.invalidConfiguration((String)"Cannot find configuration for cron: %s", (Object[])new Object[]{anno.value()});
        }
        return JobTrigger.cron(v);
    }

    static JobTrigger of(AppConfig config, OnAppStart anno) {
        if (anno.async()) {
            return JobTrigger.alongWith(SysEventId.START);
        }
        return JobTrigger.after(SysEventId.START);
    }

    static JobTrigger of(AppConfig config, OnAppStop anno) {
        if (anno.async()) {
            return JobTrigger.alongWith(SysEventId.STOP);
        }
        return JobTrigger.before(SysEventId.STOP);
    }

    static JobTrigger of(AppConfig config, FixedDelay anno) {
        String delay = anno.value();
        if (delay.startsWith("delay.")) {
            delay = (String)config.get(delay);
        } else if (delay.startsWith("${") && delay.endsWith("}")) {
            delay = delay.substring(2, delay.length() - 1);
            delay = (String)config.get(delay);
        }
        if (S.blank((String)delay)) {
            throw E.invalidConfiguration((String)"Cannot find configuration for delay: %s", (Object[])new Object[]{anno.value()});
        }
        return JobTrigger.fixedDelay(delay, anno.startImmediately());
    }

    static JobTrigger of(AppConfig config, Every anno) {
        String duration = anno.value();
        if (duration.startsWith("every.")) {
            duration = (String)config.get(duration);
        } else if (duration.startsWith("${") && duration.endsWith("}")) {
            duration = duration.substring(2, duration.length() - 1);
            duration = (String)config.get(duration);
        }
        if (S.blank((String)duration)) {
            throw E.invalidConfiguration((String)"Cannot find configuration for duration: %s", (Object[])new Object[]{anno.value()});
        }
        return JobTrigger.every(duration, anno.startImmediately());
    }

    static JobTrigger of(AppConfig config, AlongWith anno) {
        String id = anno.value();
        E.illegalArgumentIf((boolean)S.blank((String)id), (String)"associate job ID cannot be empty");
        return new _AlongWith(id);
    }

    static JobTrigger of(AppConfig config, InvokeAfter anno) {
        String id = anno.value();
        E.illegalArgumentIf((boolean)S.blank((String)id), (String)"associate job ID cannot be empty");
        return new _After(id);
    }

    static JobTrigger of(AppConfig config, InvokeBefore anno) {
        String id = anno.value();
        E.illegalArgumentIf((boolean)S.blank((String)id), (String)"associate job ID cannot be empty");
        return new _Before(id);
    }

    static JobTrigger cron(String expression) {
        return new _Cron(expression);
    }

    static JobTrigger fixedDelay(String duration, boolean startImmediately) {
        return new _FixedDelay(duration, startImmediately);
    }

    static JobTrigger fixedDelay(long seconds, boolean startImmediately) {
        return new _FixedDelay(seconds, startImmediately);
    }

    static JobTrigger fixedDelay(long interval, TimeUnit timeUnit, boolean startImmediately) {
        return new _FixedDelay(timeUnit.toSeconds(interval), startImmediately);
    }

    static JobTrigger every(String duration, boolean startImmediately) {
        return new _Every(duration, startImmediately);
    }

    static JobTrigger every(long seconds, boolean startImmediately) {
        return new _Every(seconds, TimeUnit.SECONDS, startImmediately);
    }

    static JobTrigger every(long duration, TimeUnit timeUnit, boolean startImmediately) {
        return new _Every(duration, timeUnit, startImmediately);
    }

    static JobTrigger onAppStart(boolean async) {
        return async ? JobTrigger.alongWith(SysEventId.START) : JobTrigger.after(SysEventId.START);
    }

    static JobTrigger onAppStop(boolean async) {
        return async ? JobTrigger.alongWith(SysEventId.STOP) : JobTrigger.before(SysEventId.STOP);
    }

    static JobTrigger onSysEvent(SysEventId eventId, boolean async) {
        return async ? JobTrigger.alongWith(eventId) : JobTrigger.after(eventId);
    }

    static JobTrigger delayForSeconds(long seconds, boolean startImmediately) {
        return new _FixedDelay(seconds, startImmediately);
    }

    static JobTrigger alongWith(String jobId) {
        return new _AlongWith(jobId);
    }

    static JobTrigger alongWith(SysEventId sysEvent) {
        return new _AlongWith(JobManager.sysEventJobId(sysEvent));
    }

    static JobTrigger before(String jobId) {
        return new _Before(jobId);
    }

    static JobTrigger before(SysEventId sysEvent) {
        return JobTrigger.before(JobManager.sysEventJobId(sysEvent));
    }

    static JobTrigger after(String jobId) {
        return new _After(jobId);
    }

    static JobTrigger after(SysEventId sysEvent) {
        return JobTrigger.after(JobManager.sysEventJobId(sysEvent));
    }

    private static class _After
    extends _AssociatedTo {
        _After(String targetId) {
            super(targetId);
        }

        @Override
        public String toString() {
            return S.concat((String)"after ", (String)this.targetId);
        }

        @Override
        void associate(Job theJob, Job toJob) {
            toJob.addFollowingJob(theJob);
        }
    }

    private static class _Before
    extends _AssociatedTo {
        _Before(String targetId) {
            super(targetId);
        }

        @Override
        public String toString() {
            return S.concat((String)"before ", (String)this.targetId);
        }

        @Override
        void associate(Job theJob, Job toJob) {
            toJob.addPrecedenceJob(theJob);
        }
    }

    private static class _AlongWith
    extends _AssociatedTo {
        _AlongWith(String targetId) {
            super(targetId);
        }

        @Override
        public String toString() {
            return S.concat((String)"along with ", (String)this.targetId);
        }

        @Override
        void associate(Job theJob, Job toJob) {
            toJob.addParallelJob(theJob);
        }
    }

    private static abstract class _AssociatedTo
    extends JobTrigger {
        String targetId;

        _AssociatedTo(String targetId) {
            E.illegalArgumentIf((boolean)S.blank((String)targetId), (String)"associate job ID expected");
            this.targetId = targetId;
        }

        @Override
        void schedule(JobManager manager, Job job) {
            this.traceSchedule(job);
            if (null == this.targetId) {
                LOGGER.warn("Failed to register job because target job not found: %s. Will try again after app started", new Object[]{this.targetId});
                this.scheduleDelayedRegister(manager, job);
            } else {
                Job associateTarget = manager.jobById(this.targetId);
                if (null == associateTarget) {
                    LOGGER.warn("Cannot find associated job: %s", new Object[]{this.targetId});
                } else {
                    this.associate(job, associateTarget);
                }
            }
        }

        private void scheduleDelayedRegister(final JobManager manager, final Job job) {
            final String id = this.delayedRegisterJobId(job);
            _AssociatedTo.before(SysEventId.START).register(new Job(id, manager, (Lang.Func0<?>)new Lang.F0<Void>(){

                public Void apply() throws NotAppliedException, Lang.Break {
                    Job associateTo = manager.jobById(id);
                    if (null == associateTo) {
                        LOGGER.warn("Cannot find associated job: %s", new Object[]{id});
                    } else {
                        _AssociatedTo.this.associate(job, associateTo);
                    }
                    return null;
                }
            }), manager);
        }

        private String delayedRegisterJobId(Job job) {
            return S.concat((String)"delayed_association_register-", (String)job.id(), (String)"-to-", (String)this.targetId);
        }

        abstract void associate(Job var1, Job var2);
    }

    private static class _Every
    extends _Periodical {
        _Every(String duration, boolean startImmediately) {
            super(duration, startImmediately);
        }

        _Every(long duration, TimeUnit timeUnit, boolean startImmediately) {
            super(timeUnit.toSeconds(duration), startImmediately);
        }

        @Override
        public String toString() {
            return S.concat((String)"every ", (String)S.string((Object)this.seconds), (String)" seconds");
        }

        @Override
        protected void delayedSchedule(JobManager manager, Job job) {
            ScheduledThreadPoolExecutor executor = manager.executor();
            ScheduledFuture<?> future = executor.scheduleAtFixedRate(job, this.seconds, this.seconds, TimeUnit.SECONDS);
            manager.futureScheduled(job.id(), future);
        }
    }

    private static class _FixedDelay
    extends _Periodical {
        _FixedDelay(String duration, boolean startImmediately) {
            super(duration, startImmediately);
        }

        _FixedDelay(long seconds, boolean startImmediately) {
            super(seconds, startImmediately);
        }

        @Override
        public String toString() {
            return S.concat((String)"fixed delay of ", (String)S.string((Object)this.seconds), (String)" seconds");
        }

        @Override
        protected void delayedSchedule(JobManager manager, Job job) {
            ScheduledThreadPoolExecutor executor = manager.executor();
            ScheduledFuture<?> future = executor.scheduleWithFixedDelay(job, this.seconds, this.seconds, TimeUnit.SECONDS);
            manager.futureScheduled(job.id(), future);
        }
    }

    private static abstract class _Periodical
    extends JobTrigger {
        protected long seconds;
        protected boolean startImmediately;

        _Periodical(String duration, boolean startImmediately) {
            E.illegalArgumentIf((boolean)S.blank((String)duration), (String)"delay duration shall not be empty");
            this.seconds = Time.parseDuration((String)duration);
            E.illegalArgumentIf((this.seconds < 1L ? 1 : 0) != 0, (String)"delay duration shall not be zero or negative number");
            this.startImmediately = startImmediately;
        }

        _Periodical(long seconds, boolean startImmediately) {
            E.illegalArgumentIf((seconds < 1L ? 1 : 0) != 0, (String)"delay duration cannot be zero or negative");
            this.seconds = seconds;
            this.startImmediately = startImmediately;
        }

        @Override
        final void schedule(final JobManager manager, final Job job) {
            this.traceSchedule(job);
            App app = manager.app();
            if (!app.isStarted()) {
                app.eventBus().bindAsync(SysEventId.POST_START, new SysEventListenerBase(){

                    @Override
                    public void on(EventObject event) {
                        _Periodical.this.runAndSchedule(manager, job);
                    }
                });
            } else {
                this.runAndSchedule(manager, job);
            }
        }

        protected abstract void delayedSchedule(JobManager var1, Job var2);

        protected void runAndSchedule(JobManager manager, Job job) {
            if (this.startImmediately) {
                manager.now(job);
            }
            this.delayedSchedule(manager, job);
        }
    }

    static class _Cron
    extends JobTrigger {
        private CronExpression cronExpr;

        _Cron(String expression) {
            this.cronExpr = new CronExpression(expression);
        }

        @Override
        public String toString() {
            return S.newBuffer((String)"cron :").a((Object)this.cronExpr).toString();
        }

        @Override
        void schedule(final JobManager manager, final Job job) {
            this.traceSchedule(job);
            App app = manager.app();
            if (!app.isStarted()) {
                app.eventBus().bindAsync(SysEventId.POST_START, new SysEventListenerBase(){

                    @Override
                    public void on(EventObject event) throws Exception {
                        _Cron.this.delayedSchedule(manager, job);
                    }
                });
            } else {
                this.delayedSchedule(manager, job);
            }
        }

        private void delayedSchedule(JobManager manager, Job job) {
            DateTime now = DateTime.now();
            DateTime next = this.cronExpr.nextTimeAfter(now.plusSeconds(1));
            Seconds seconds = Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)next);
            ScheduledFuture<?> future = manager.executor().schedule(job, (long)seconds.getSeconds(), TimeUnit.SECONDS);
            manager.futureScheduled(job.id(), future);
        }

        @Override
        void scheduleFollowingCalls(JobManager manager, Job job) {
            this.schedule(manager, job);
        }
    }
}

