/*
 * Decompiled with CFR 0.152.
 */
package act.job.bytecode;

import act.app.AppByteCodeScannerBase;
import act.app.event.SysEventId;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import act.job.JobAnnotationProcessor;
import act.job.bytecode.JobAnnoInfo;
import act.job.meta.JobClassMetaInfo;
import act.job.meta.JobClassMetaInfoManager;
import act.job.meta.JobMethodMetaInfo;
import act.sys.Env;
import act.sys.meta.EnvAnnotationVisitor;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.S;

public class JobByteCodeScanner
extends AppByteCodeScannerBase {
    private JobAnnotationProcessor annotationProcessor;
    private JobClassMetaInfo classInfo;
    private volatile JobClassMetaInfoManager classInfoBase;

    @Override
    protected boolean shouldScan(String className) {
        this.classInfo = new JobClassMetaInfo();
        return true;
    }

    @Override
    protected void onAppSet() {
        this.annotationProcessor = new JobAnnotationProcessor(this.app());
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
        this.classInfoBase().registerJobMetaInfo(this.classInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobClassMetaInfoManager classInfoBase() {
        if (null == this.classInfoBase) {
            JobByteCodeScanner jobByteCodeScanner = this;
            synchronized (jobByteCodeScanner) {
                if (null == this.classInfoBase) {
                    this.classInfoBase = this.app().classLoader().jobClassMetaInfoManager();
                }
            }
        }
        return this.classInfoBase;
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            JobByteCodeScanner.this.classInfo.className(name);
            Type superType = Type.getObjectType((String)superName);
            JobByteCodeScanner.this.classInfo.superType(superType);
            if (_ByteCodeVisitor.isAbstract(access)) {
                JobByteCodeScanner.this.classInfo.setAbstract();
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (!this.isEligibleMethod(access, name, desc)) {
                return mv;
            }
            return new JobMethodVisitor(mv, access, name, desc, signature, exceptions);
        }

        private boolean isEligibleMethod(int access, String name, String desc) {
            return _ByteCodeVisitor.isPublic(access);
        }

        private class JobMethodVisitor
        extends MethodVisitor
        implements Opcodes {
            private String methodName;
            private int access;
            private boolean requireScan;
            private JobMethodMetaInfo methodInfo;
            private ActionAnnotationVisitor aav;
            private EnvAnnotationVisitor eav;
            private List<String> paramTypes;

            JobMethodVisitor(MethodVisitor mv, int access, String methodName, String desc, String signature, String[] exceptions) {
                super(327680, mv);
                this.access = access;
                this.methodName = methodName;
                Type[] arguments = Type.getArgumentTypes((String)desc);
                this.paramTypes = new ArrayList<String>();
                if (null != arguments) {
                    for (Type type : arguments) {
                        this.paramTypes.add(type.getClassName());
                    }
                }
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                Type type = Type.getType((String)desc);
                String className = type.getClassName();
                try {
                    Class<?> c = Class.forName(className);
                    if (JobClassMetaInfo.isActionAnnotation(c)) {
                        this.markRequireScan();
                        if (null == this.methodInfo) {
                            JobMethodMetaInfo tmp;
                            this.methodInfo = tmp = new JobMethodMetaInfo(JobByteCodeScanner.this.classInfo, this.paramTypes);
                            JobByteCodeScanner.this.classInfo.addAction(tmp);
                            this.aav = new ActionAnnotationVisitor(av, c, this.methodInfo);
                        } else {
                            this.aav.add(c);
                        }
                        return this.aav;
                    }
                    if (Env.isEnvAnnotation(c)) {
                        this.eav = new EnvAnnotationVisitor(av, desc);
                        return this.eav;
                    }
                }
                catch (Exception e) {
                    throw E.unexpected((Throwable)e);
                }
                return av;
            }

            public void visitEnd() {
                if (!this.requireScan()) {
                    super.visitEnd();
                    return;
                }
                JobMethodMetaInfo info = this.methodInfo;
                info.name(this.methodName);
                boolean isStatic = AsmTypes.isStatic(this.access);
                if (isStatic) {
                    info.invokeStaticMethod();
                } else {
                    info.invokeInstanceMethod();
                }
                if (null != this.aav && (null == this.eav || this.eav.matched())) {
                    this.aav.doRegistration();
                }
                super.visitEnd();
            }

            private void markRequireScan() {
                this.requireScan = true;
            }

            private boolean requireScan() {
                return this.requireScan;
            }

            private class ActionAnnotationVisitor
            extends AnnotationVisitor
            implements Opcodes {
                List<JobAnnoInfo> annoInfos;
                JobAnnoInfo currentInfo;
                JobMethodMetaInfo method;

                public ActionAnnotationVisitor(AnnotationVisitor av, Class<? extends Annotation> c, JobMethodMetaInfo methodMetaInfo) {
                    super(327680, av);
                    this.annoInfos = new ArrayList<JobAnnoInfo>();
                    this.method = methodMetaInfo;
                    this.add(c);
                }

                void add(Class<? extends Annotation> annotationClass) {
                    this.currentInfo = new JobAnnoInfo(annotationClass);
                    this.annoInfos.add(this.currentInfo);
                }

                public void visitEnum(String name, String desc, String value) {
                    if (desc.contains("SysEventId")) {
                        this.currentInfo.sysEventId = SysEventId.valueOf(value);
                    }
                    super.visitEnum(name, desc, value);
                }

                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        this.currentInfo.value = value.toString();
                    } else if ("async".equals(name)) {
                        this.currentInfo.async = $.bool((Object)value);
                    } else if ("id".equals(name)) {
                        this.method.id(S.string((Object)value));
                    } else if ("startImmediately".equals(name)) {
                        this.currentInfo.startImmediately = Boolean.parseBoolean(value.toString());
                    }
                    super.visit(name, value);
                }

                public void doRegistration() {
                    for (JobAnnoInfo info : this.annoInfos) {
                        JobByteCodeScanner.this.annotationProcessor.register(this.method, info.annotationType, info);
                    }
                }
            }
        }
    }
}

