/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.cli.tree.FilteredTreeNode;
import act.cli.tree.TreeNode;
import act.cli.tree.TreeNodeFilter;
import act.metric.MetricInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.S;

public class MetricInfoTree {
    private Map<String, MetricInfo> infoMap = new HashMap<String, MetricInfo>();
    private MetricInfoNode root;
    private Map<String, MetricInfoNode> nodeMap = new HashMap<String, MetricInfoNode>();
    private TreeNodeFilter filter = null;
    static final NodeDecorator COUNTER = new NodeDecorator((Lang.Function<MetricInfo, String>)new Lang.Transformer<MetricInfo, String>(){

        public String transform(MetricInfo metricInfo) {
            return S.fmt((String)"%s: %s", (Object[])new Object[]{metricInfo.getName(), metricInfo.getCountAsStr()});
        }
    });
    static final NodeDecorator TIMER = new NodeDecorator((Lang.Function<MetricInfo, String>)new Lang.Transformer<MetricInfo, String>(){

        public String transform(MetricInfo metricInfo) {
            return S.fmt((String)"%s: %s / %s = %s", (Object[])new Object[]{metricInfo.getName(), metricInfo.getAccumulated(), metricInfo.getCountAsStr(), metricInfo.getAvg()});
        }
    });

    public MetricInfoTree(List<MetricInfo> infoList, Lang.Predicate<String> filter) {
        for (MetricInfo info : infoList) {
            this.infoMap.put(info.getName(), info);
        }
        if (filter != Lang.F.TRUE) {
            this.filter = TreeNodeFilter.Common.pathMatches(filter);
        }
        this.buildTree();
    }

    public TreeNode root(NodeDecorator decorator) {
        return null == this.filter ? decorator.decorate(this.root) : new FilteredTreeNode(decorator.decorate(this.root), this.filter);
    }

    MetricInfoNode getNode(MetricInfo info) {
        MetricInfoNode node = this.nodeMap.get(info.getName());
        if (null == node) {
            node = new MetricInfoNode(info);
            this.nodeMap.put(info.getName(), node);
        }
        return node;
    }

    MetricInfo getMetricInfo(String name) {
        return this.infoMap.get(name);
    }

    void buildTree() {
        for (Map.Entry<String, MetricInfo> entry : this.infoMap.entrySet()) {
            String path = entry.getKey();
            MetricInfo info = entry.getValue();
            MetricInfoNode node = this.getNode(info);
            if (!node.isRoot) continue;
            this.root = node;
        }
    }

    public static class NodeDecorator {
        Lang.Function<MetricInfo, String> labelGetter;

        NodeDecorator(Lang.Function<MetricInfo, String> labelGetter) {
            this.labelGetter = (Lang.Function)$.notNull(labelGetter);
        }

        TreeNode decorate(final MetricInfoNode node) {
            return new TreeNode(){

                @Override
                public String id() {
                    return node.id();
                }

                @Override
                public String label() {
                    return (String)NodeDecorator.this.labelGetter.apply((Object)node.info);
                }

                @Override
                public List<TreeNode> children() {
                    return node.children().map((Lang.Function)new Lang.Transformer<TreeNode, TreeNode>(){

                        public TreeNode transform(TreeNode treeNode) {
                            return NodeDecorator.this.decorate((MetricInfoNode)treeNode);
                        }
                    });
                }
            };
        }
    }

    class MetricInfoNode
    implements TreeNode {
        MetricInfo info;
        C.List<TreeNode> children = C.newList();
        private boolean isRoot;

        MetricInfoNode(MetricInfo info) {
            this.info = (MetricInfo)$.notNull((Object)info);
            this.isRoot = !this.addToParent();
        }

        @Override
        public String id() {
            return S.str((Object)this.info.getName()).afterLast(":").toString();
        }

        @Override
        public String label() {
            return this.info.getName();
        }

        public C.List<TreeNode> children() {
            return this.children;
        }

        public String getParentPath() {
            String path = this.info.getName();
            if (path.contains(":")) {
                return S.beforeLast((String)path, (String)":");
            }
            return "";
        }

        boolean addToParent() {
            String parentPath = this.getParentPath();
            if (S.blank((String)parentPath)) {
                return false;
            }
            MetricInfo parent = MetricInfoTree.this.getMetricInfo(parentPath);
            if (null == parent) {
                return false;
            }
            MetricInfoNode parentNode = MetricInfoTree.this.getNode(parent);
            parentNode.children.add((Object)this);
            return true;
        }
    }
}

