/*
 * Decompiled with CFR 0.152.
 */
package act.route;

import act.app.ActionContext;
import act.handler.RequestHandler;
import act.handler.RequestHandlerBase;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.util.E;
import org.osgl.util.S;

public class RouteInfo
extends Lang.T3<String, String, String>
implements Comparable<RouteInfo> {
    public static final RequestHandler UNKNOWN_HANDLER = new RequestHandlerBase(){

        @Override
        public void handle(ActionContext context) {
            throw E.unsupport();
        }

        @Override
        public boolean express(ActionContext context) {
            return true;
        }

        @Override
        public String toString() {
            return "unknown";
        }

        @Override
        public boolean sessionFree() {
            return true;
        }

        @Override
        public void prepareAuthentication(ActionContext context) {
            throw E.unsupport();
        }
    };

    public RouteInfo(H.Method method, String path, RequestHandler handler) {
        super((Object)method.name(), (Object)path, (Object)handler.toString());
    }

    public String method() {
        return (String)this._1;
    }

    public String path() {
        return (String)this._2;
    }

    public String handler() {
        return (String)this._3;
    }

    public String compactHandler() {
        return RouteInfo.compactHandler((String)this._3);
    }

    public static String compactHandler(String handler) {
        String[] sa = handler.split("\\.");
        int len = sa.length;
        if (len == 1) {
            return handler;
        }
        S.Buffer sb = S.newBuffer();
        for (int i = 0; i < len - 2; ++i) {
            sb.append(sa[i].charAt(0)).append('.');
        }
        sb.append(sa[len - 2]).append('.').append(sa[len - 1]);
        return sb.toString();
    }

    public String toString() {
        return S.fmt((String)"[%s %s] -> [%s]", (Object[])new Object[]{this.method(), this.path(), this.compactHandler()});
    }

    @Override
    public int compareTo(RouteInfo routeInfo) {
        int n = this.path().compareTo(routeInfo.path());
        if (n != 0) {
            return n;
        }
        n = this.method().compareTo(routeInfo.method());
        if (n != 0) {
            return n;
        }
        return this.handler().compareTo(routeInfo.handler());
    }

    public static RouteInfo of(ActionContext context) {
        H.Method m = context.req().method();
        String path = context.req().url();
        RequestHandler handler = context.handler();
        if (null == handler) {
            handler = UNKNOWN_HANDLER;
        }
        return new RouteInfo(m, path, handler);
    }
}

