/*
 * Decompiled with CFR 0.152.
 */
package act.route;

import act.route.Router;

public enum RouteSource {
    BUILD_IN{

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            switch (existingRoute) {
                case BUILD_IN: {
                    return Router.ConflictResolver.EXIT;
                }
            }
            return Router.ConflictResolver.SKIP;
        }
    }
    ,
    ROUTE_TABLE{

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            switch (existingRoute) {
                case APP_CONFIG: {
                    return Router.ConflictResolver.EXIT;
                }
                case ACTION_ANNOTATION: {
                    return Router.ConflictResolver.OVERWRITE;
                }
            }
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    ACTION_ANNOTATION{

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            switch (existingRoute) {
                case ACTION_ANNOTATION: {
                    return Router.ConflictResolver.EXIT;
                }
                case APP_CONFIG: 
                case ROUTE_TABLE: {
                    return Router.ConflictResolver.SKIP;
                }
            }
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    APP_CONFIG{

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            switch (existingRoute) {
                case APP_CONFIG: {
                    return Router.ConflictResolver.EXIT;
                }
            }
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    ADMIN_OVERWRITE{

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    ADMIN_ADD{

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            return Router.ConflictResolver.EXIT;
        }
    };


    abstract Router.ConflictResolver onConflict(RouteSource var1);
}

