/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.conf.AppConfig;
import act.session.SessionMapper;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.http.H;

@Singleton
public class CookieSessionMapper
implements SessionMapper {
    private SessionMapper.ExpirationMapper expirationMapper;
    private String sessionCookieName;
    private String flashCookieName;
    private String cookieDomain;
    private boolean sessionSecure;
    private boolean sessionWillExpire;
    private boolean persistentSession;
    private int ttl;

    @Inject
    public CookieSessionMapper(AppConfig conf) {
        this.sessionCookieName = conf.sessionCookieName();
        this.flashCookieName = conf.flashCookieName();
        this.cookieDomain = conf.cookieDomain();
        this.sessionSecure = conf.sessionSecure();
        this.persistentSession = conf.persistSession();
        this.ttl = conf.sessionTtl();
        this.sessionWillExpire = this.ttl > 0;
        this.expirationMapper = new SessionMapper.ExpirationMapper(conf);
    }

    @Override
    public void writeExpiration(long expiration, H.Response response) {
        this.expirationMapper.writeExpiration(expiration, response);
    }

    @Override
    public void write(String session, String flash, H.Response response) {
        this.writeState(session, this.sessionCookieName, response);
        this.writeState(flash, this.flashCookieName, response);
    }

    @Override
    public String readSession(H.Request request) {
        return this.readState(this.sessionCookieName, request);
    }

    @Override
    public String readFlash(H.Request request) {
        return this.readState(this.flashCookieName, request);
    }

    private void writeState(String state, String cookieName, H.Response response) {
        if (null == state) {
            return;
        }
        H.Cookie cookie = this.createCookie(cookieName, state);
        response.addCookie(cookie);
    }

    private H.Cookie createCookie(String name, String value) {
        H.Cookie cookie = new H.Cookie(name, value);
        cookie.path("/");
        cookie.domain(this.cookieDomain);
        cookie.httpOnly(true);
        cookie.secure(this.sessionSecure);
        if (this.sessionWillExpire && this.persistentSession) {
            cookie.maxAge(this.ttl);
        }
        return cookie;
    }

    private String readState(String cookieName, H.Request request) {
        H.Cookie cookie = request.cookie(cookieName);
        return null == cookie ? null : cookie.value();
    }
}

