/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.AppByteCodeScannerBase;
import act.app.event.SysEventId;
import act.asm.AnnotationVisitor;
import act.asm.Type;
import act.event.SysEventListenerBase;
import act.util.ByteCodeVisitor;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import java.util.EventObject;

public class ClassInfoByteCodeScanner
extends AppByteCodeScannerBase {
    private ClassInfoRepository classInfoRepository;

    @Override
    protected void onAppSet() {
        this.app().eventBus().bind(SysEventId.CLASS_LOADER_INITIALIZED, new SysEventListenerBase("init-class-info-repo"){

            @Override
            public void on(EventObject event) {
                ClassInfoByteCodeScanner.this.classInfoRepository = ClassInfoByteCodeScanner.this.app().classLoader().classInfoRepository();
            }
        });
    }

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        ClassNode me;

        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            String myName = Type.getObjectType((String)name).getClassName();
            this.me = ClassInfoByteCodeScanner.this.classInfoRepository.node(myName);
            this.me.modifiers(access);
            String superType = Type.getObjectType((String)superName).getClassName();
            if (!Object.class.getName().equals(superType)) {
                this.me.parent(superType);
            }
            if (null != interfaces) {
                for (String intf : interfaces) {
                    this.me.addInterface(intf);
                }
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String annotationType = Type.getType((String)desc).getClassName();
            this.me.annotatedWith(annotationType);
            return super.visitAnnotation(desc, visible);
        }
    }
}

