/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.ActionContext;
import act.app.App;
import act.app.util.NamedPort;
import act.conf.AppConfig;
import act.controller.Controller;
import act.route.Router;
import act.util.MissingAuthenticationHandler;
import act.util.ReturnUnauthorized;
import act.util.SingletonBase;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.mvc.result.Redirect;
import org.osgl.mvc.result.Result;
import org.osgl.util.S;

public class RedirectToLoginUrl
extends SingletonBase
implements MissingAuthenticationHandler {
    private static final String KEY_REFERER = "__act_referer__";
    private volatile Result R = null;
    private volatile Result R_AJAX = null;
    private final Map<String, Result> resultMap = new HashMap<String, Result>();
    private final Map<String, Result> ajaxResultMap = new HashMap<String, Result>();
    private final Redirect userDefined;
    private boolean hasRouteToLoginUrl;

    public RedirectToLoginUrl(String url) {
        this.userDefined = new Redirect(url);
    }

    public RedirectToLoginUrl() {
        this.userDefined = null;
        App app = App.instance();
        AppConfig<?> config = app.config();
        String loginUrl = config.loginUrl();
        String ajaxLoginUrl = config.ajaxLoginUrl();
        Router router = app.router();
        Lang.Var result = $.var();
        Lang.Var ajaxResult = $.var();
        this.findResults(loginUrl, ajaxLoginUrl, (Lang.Var<Result>)result, (Lang.Var<Result>)ajaxResult, router);
        this.R = (Result)((Object)result.get());
        this.R_AJAX = (Result)((Object)result.get());
        this.resultMap.put("", this.R);
        this.ajaxResultMap.put("", this.R_AJAX);
        for (NamedPort port : config.namedPorts()) {
            Router routerX = app.router(port);
            this.findResults(loginUrl, ajaxLoginUrl, (Lang.Var<Result>)result, (Lang.Var<Result>)ajaxResult, routerX);
            this.resultMap.put(port.name(), (Result)((Object)result.get()));
            this.ajaxResultMap.put(port.name(), (Result)((Object)ajaxResult.get()));
        }
    }

    public boolean hasLoginUrl() {
        return this.hasRouteToLoginUrl;
    }

    @Override
    public Result result(ActionContext context) {
        this.cacheUrl(context);
        context.dissolve();
        if (null != this.userDefined) {
            return this.userDefined;
        }
        if (context.isAjax()) {
            return this._ajaxResult(context);
        }
        return this._result(context);
    }

    @Override
    public void handle(ActionContext context) {
        throw this.result(context);
    }

    private Result _ajaxResult(ActionContext context) {
        String portId = context.router().portId();
        return S.blank((String)portId) ? this.R_AJAX : this.ajaxResultMap.get(portId);
    }

    private Result _result(ActionContext context) {
        String portId = context.router().portId();
        return S.blank((String)portId) ? this.R : this.resultMap.get(portId);
    }

    protected void findResults(String loginUrl, String ajaxLoginUrl, Lang.Var<Result> result, Lang.Var<Result> ajaxResult, Router router) {
        this.hasRouteToLoginUrl = this.hasRouteTo(loginUrl, router);
        result.set(this.hasRouteToLoginUrl ? new Redirect(loginUrl) : ReturnUnauthorized.result());
        ajaxResult.set(S.eq((String)ajaxLoginUrl, (String)loginUrl) ? this.R : (this.hasRouteTo(ajaxLoginUrl, router) ? new Redirect(ajaxLoginUrl) : ReturnUnauthorized.result()));
    }

    protected final boolean hasRouteTo(String url, Router router) {
        return null != router.findStaticGetHandler(url);
    }

    private void cacheUrl(ActionContext context) {
        String url = context.req().url();
        context.cache(KEY_REFERER, url, 300);
    }

    public static void redirectToOriginalUrl(ActionContext context, String defLandingUrl) {
        String url = (String)context.cached(KEY_REFERER);
        if (S.blank((String)url)) {
            url = defLandingUrl;
        } else {
            context.evictCache(KEY_REFERER);
        }
        if (S.blank((String)url)) {
            url = "/";
        }
        throw Controller.Util.redirect(url, new Object[0]);
    }

    public static void redirectToOriginalUrl(ActionContext context) {
        RedirectToLoginUrl.redirectToOriginalUrl(context, "/");
    }
}

