/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.Destroyable;
import act.annotations.Alias;
import act.app.App;
import act.app.AppByteCodeScannerBase;
import act.app.AppClassLoader;
import act.app.event.SysEventId;
import act.asm.AnnotationVisitor;
import act.asm.ClassVisitor;
import act.asm.FieldVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.internal.password.PasswordMetaInfo;
import act.meta.ClassMetaInfoManager;
import act.util.AppByteCodeEnhancer;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public interface SimpleBean {

    public static class ByteCodeEnhancer
    extends AppByteCodeEnhancer<ByteCodeEnhancer> {
        public static final int PRIORITY = 9;
        private MetaInfoManager metaInfoManager;
        private ClassInfoRepository classInfoRepository;
        private boolean isSimpleBean = false;
        private boolean hasPublicFields = false;
        private Map<String, Lang.T2<String, String>> getters = new HashMap<String, Lang.T2<String, String>>();
        private Map<String, Lang.T2<String, String>> setters = new HashMap<String, Lang.T2<String, String>>();
        private boolean needDefaultConstructor = false;
        private String classDesc;
        private String superClassDesc;
        private MetaInfo metaInfo;
        private ClassMetaInfoManager<PasswordMetaInfo> passwordMetaInfoManager;
        private PasswordMetaInfo passwordMetaInfo;
        private static final int _I = 73;
        private static final int _Z = 90;
        private static final int _S = 83;
        private static final int _B = 66;
        private static final int _C = 67;
        private static final int _D = 68;
        private static final int _J = 74;
        private static final int _F = 70;

        public ByteCodeEnhancer() {
            super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate());
        }

        public ByteCodeEnhancer(ClassVisitor cv) {
            super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate(), cv);
        }

        @Override
        protected Class<ByteCodeEnhancer> subClass() {
            return ByteCodeEnhancer.class;
        }

        @Override
        public int priority() {
            return 9;
        }

        @Override
        protected void reset() {
            this.isSimpleBean = false;
            this.hasPublicFields = false;
            this.getters.clear();
            this.setters.clear();
            this.needDefaultConstructor = false;
            this.classDesc = null;
            this.superClassDesc = null;
            this.metaInfo = null;
            super.reset();
        }

        @Override
        public AppByteCodeEnhancer app(App app) {
            AppClassLoader classLoader = app.classLoader();
            this.classInfoRepository = classLoader.classInfoRepository();
            this.metaInfoManager = classLoader.simpleBeanInfoManager();
            this.passwordMetaInfoManager = app.classMetaInfoManager(PasswordMetaInfo.class);
            return super.app(app);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classDesc = name;
            String className = Type.getObjectType((String)name).getClassName();
            this.passwordMetaInfo = this.passwordMetaInfoManager.get(className);
            this.isSimpleBean = this.metaInfoManager.isSimpleBean(className);
            if (this.isSimpleBean) {
                this.needDefaultConstructor = true;
                MetaInfo metaInfo = this.metaInfoManager.get(className);
                this.superClassDesc = superName;
                if (null != metaInfo) {
                    this.metaInfo = metaInfo;
                    Map publicFields = metaInfo.publicFields;
                    if (!publicFields.isEmpty()) {
                        this.getters.putAll(publicFields);
                        this.setters.putAll(publicFields);
                        this.hasPublicFields = true;
                    } else {
                        this.hasPublicFields = false;
                    }
                }
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String setter;
            PropertyAssignMethodVisitor mv = new PropertyAssignMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), name);
            if (!this.isSimpleBean) {
                return mv;
            }
            if ("<init>".equals(name) && "()V".equals(desc)) {
                this.needDefaultConstructor = false;
            }
            if (!this.hasPublicFields) {
                return mv;
            }
            String getter = this.fieldNameFromGetterSetter(name, true);
            if (null != getter) {
                this.getters.remove(getter);
                this.getters.remove(this.metaInfo.aliasOf(getter));
            }
            if (null != (setter = this.fieldNameFromGetterSetter(name, false))) {
                this.setters.remove(setter);
                this.setters.remove(this.metaInfo.aliasOf(setter));
            }
            return mv;
        }

        private String fieldNameFromGetterSetter(String methodName, boolean getter) {
            char c;
            String fieldName;
            if (methodName.startsWith(getter ? "get" : "set") && !(fieldName = methodName.substring(3)).isEmpty() && Character.isUpperCase(c = fieldName.charAt(0))) {
                return ("" + fieldName.charAt(0)).toLowerCase() + fieldName.substring(1);
            }
            return getter ? this.fieldNameFromBooleanGetter(methodName) : null;
        }

        private String fieldNameFromGetterSetter(String methodName) {
            char c;
            String fieldName;
            if ((methodName.startsWith("get") || methodName.startsWith("set")) && !(fieldName = methodName.substring(3)).isEmpty() && Character.isUpperCase(c = fieldName.charAt(0))) {
                return ("" + fieldName.charAt(0)).toLowerCase() + fieldName.substring(1);
            }
            return this.fieldNameFromBooleanGetter(methodName);
        }

        private String fieldNameFromBooleanGetter(String methodName) {
            char c;
            String fieldName;
            if (methodName.startsWith("is") && !(fieldName = methodName.substring(2)).isEmpty() && Character.isUpperCase(c = fieldName.charAt(0))) {
                return ("" + fieldName.charAt(0)).toLowerCase() + fieldName.substring(1);
            }
            return null;
        }

        public void visitEnd() {
            if (this.needDefaultConstructor) {
                this.addDefaultConstructor();
            }
            if (!this.getters.isEmpty()) {
                this.addGetters();
            }
            if (!this.setters.isEmpty()) {
                this.addSetters();
            }
            super.visitEnd();
        }

        private void addDefaultConstructor() {
            MethodVisitor mv = this.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.superClassDesc, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        private void addGetters() {
            for (Map.Entry field : C.list(this.getters.entrySet())) {
                this.addGetter(field);
            }
        }

        private void addSetters() {
            for (Map.Entry field : C.list(this.setters.entrySet())) {
                this.addSetter(field);
            }
        }

        private void addGetter(Map.Entry<String, Lang.T2<String, String>> field) {
            String name = field.getKey();
            if (this.metaInfo.isSensitive(name)) {
                return;
            }
            String desc = (String)field.getValue()._1;
            String signature = (String)field.getValue()._2;
            if (null != signature) {
                signature = S.concat((String)"()", (String)signature);
            }
            MethodVisitor mv = this.visitMethod(1, this.getterName(name, MetaInfo.isBoolean(desc)), S.concat((String)"()", (String)desc), signature, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classDesc, name, desc);
            mv.visitInsn(this.returnCode(desc));
            if (68 == desc.hashCode() || 74 == desc.hashCode()) {
                mv.visitMaxs(2, 1);
            } else {
                mv.visitMaxs(1, 1);
            }
            mv.visitEnd();
        }

        private void addSetter(Map.Entry<String, Lang.T2<String, String>> field) {
            String name = field.getKey();
            if (this.metaInfo.isSensitive(name) || null != this.passwordMetaInfo && this.passwordMetaInfo.isPasswordField(name)) {
                return;
            }
            String desc = (String)field.getValue()._1;
            String signature = (String)field.getValue()._2;
            if (null != signature) {
                signature = S.concat((String)"(", (String)signature, (String)")V");
            }
            MethodVisitor mv = this.visitMethod(1, this.setterName(name), S.concat((String)"(", (String)desc, (String)")V"), signature, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(this.loadCode(desc), 1);
            mv.visitFieldInsn(181, this.classDesc, name, desc);
            mv.visitInsn(177);
            if (68 == desc.hashCode() || 74 == desc.hashCode()) {
                mv.visitMaxs(3, 3);
            } else {
                mv.visitMaxs(2, 2);
            }
            mv.visitEnd();
        }

        private String getterName(String fieldName, boolean isBoolean) {
            return (isBoolean ? "is" : "get") + S.capFirst((String)fieldName);
        }

        private String setterName(String fieldName) {
            return "set" + S.capFirst((String)fieldName);
        }

        private int loadCode(String desc) {
            return this.loadOrReturnCode(desc, true);
        }

        private int returnCode(String desc) {
            return this.loadOrReturnCode(desc, false);
        }

        private int loadOrReturnCode(String desc, boolean load) {
            switch (desc.hashCode()) {
                case 66: 
                case 67: 
                case 73: 
                case 83: 
                case 90: {
                    return load ? 21 : 172;
                }
                case 74: {
                    return load ? 22 : 173;
                }
                case 68: {
                    return load ? 24 : 175;
                }
                case 70: {
                    return load ? 23 : 174;
                }
            }
            return load ? 25 : 176;
        }

        private class PropertyAssignMethodVisitor
        extends MethodVisitor {
            private String fieldName;

            public PropertyAssignMethodVisitor(MethodVisitor upstream, String name) {
                super(327680, upstream);
                this.fieldName = ByteCodeEnhancer.this.fieldNameFromGetterSetter(name);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                block5: {
                    block4: {
                        if (!this.shouldReplaceWithGetterOrSetter(owner, name)) break block4;
                        switch (opcode) {
                            case 181: {
                                this.visitMethodInsn(182, owner, ByteCodeEnhancer.this.setterName(name), "(" + desc + ")V");
                                break block5;
                            }
                            case 180: {
                                this.visitMethodInsn(182, owner, ByteCodeEnhancer.this.getterName(name, MetaInfo.isBoolean(desc)), "()" + desc);
                                break block5;
                            }
                            default: {
                                throw new IllegalStateException("visitFieldInsn opcode not supported: " + opcode);
                            }
                        }
                    }
                    super.visitFieldInsn(opcode, owner, name, desc);
                }
            }

            private boolean shouldReplaceWithGetterOrSetter(String owner, String name) {
                ClassNode node = ByteCodeEnhancer.this.classInfoRepository.node(owner);
                if (null == node || !node.hasInterface(SimpleBean.class.getName())) {
                    return false;
                }
                String ownerClass = Type.getObjectType((String)owner).getClassName();
                MetaInfo metaInfo = ByteCodeEnhancer.this.metaInfoManager.get(ownerClass);
                while (null == metaInfo || !metaInfo.publicFields.containsKey(name)) {
                    if (null == (node = node.parent())) {
                        return false;
                    }
                    metaInfo = ByteCodeEnhancer.this.metaInfoManager.get(node.name());
                }
                return !this.insideGetterSetter(owner, name, metaInfo.aliasOf(name));
            }

            private boolean insideGetterSetter(String owner, String name, String alias) {
                return null != this.fieldName && !S.neq((String)ByteCodeEnhancer.this.classDesc, (String)owner) && (!S.neq((String)this.fieldName, (String)name) || !S.neq((String)this.fieldName, (String)alias));
            }
        }
    }

    public static class ByteCodeScanner
    extends AppByteCodeScannerBase {
        @Override
        protected boolean shouldScan(String className) {
            return true;
        }

        @Override
        public ByteCodeVisitor byteCodeVisitor() {
            return new SimpleBeanByteCodeVisitor();
        }

        @Override
        public void scanFinished(String className) {
        }

        private static class SimpleBeanByteCodeVisitor
        extends ByteCodeVisitor {
            private static final String ALIAS_DESC = Type.getType(Alias.class).getDescriptor();
            private String className;
            private boolean isPublicClass;
            private Map<String, Lang.T2<String, String>> publicFields = new HashMap<String, Lang.T2<String, String>>();
            private Map<String, String> aliases = new HashMap<String, String>();

            private SimpleBeanByteCodeVisitor() {
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (SimpleBeanByteCodeVisitor.isPublic(access)) {
                    this.isPublicClass = true;
                    this.className = Type.getObjectType((String)name).getClassName();
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
                FieldVisitor fv = super.visitField(access, name, desc, signature, value);
                if (this.isPublicClass && AsmTypes.isPublic(access) && !AsmTypes.isStatic(access)) {
                    this.publicFields.put(name, (Lang.T2<String, String>)$.T2((Object)desc, (Object)signature));
                    return new FieldVisitor(327680, fv){
                        private String alias;

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            AnnotationVisitor av = super.visitAnnotation(desc, visible);
                            if (ALIAS_DESC.equals(desc)) {
                                return new AnnotationVisitor(327680, av){

                                    public void visit(String name, Object value) {
                                        alias = S.string((Object)value);
                                    }
                                };
                            }
                            return av;
                        }

                        public void visitEnd() {
                            if (null != this.alias && S.neq((String)name, (String)this.alias)) {
                                SimpleBeanByteCodeVisitor.this.aliases.put(name, this.alias);
                                SimpleBeanByteCodeVisitor.this.aliases.put(this.alias, name);
                            }
                            super.visitEnd();
                        }
                    };
                }
                return fv;
            }

            public void visitEnd() {
                if (this.isPublicClass) {
                    Act.app().jobManager().on(SysEventId.APP_CODE_SCANNED, new Runnable(){

                        @Override
                        public void run() {
                            MetaInfoManager metaInfoManager = Act.app().classLoader().simpleBeanInfoManager();
                            if (metaInfoManager.isSimpleBean(SimpleBeanByteCodeVisitor.this.className)) {
                                MetaInfo metaInfo = new MetaInfo(SimpleBeanByteCodeVisitor.this.className, SimpleBeanByteCodeVisitor.this.publicFields, SimpleBeanByteCodeVisitor.this.aliases);
                                metaInfoManager.register(metaInfo);
                            }
                        }
                    });
                }
                super.visitEnd();
            }
        }
    }

    @ApplicationScoped
    public static class MetaInfoManager
    extends DestroyableBase {
        private static final String INTF_SIMPLE_BEAN = SimpleBean.class.getName();
        private ClassInfoRepository classInfoRepository;
        private Map<String, MetaInfo> registry = new HashMap<String, MetaInfo>();

        @Inject
        public MetaInfoManager(AppClassLoader classLoader) {
            this.classInfoRepository = classLoader.classInfoRepository();
        }

        @Override
        protected void releaseResources() {
            Destroyable.Util.tryDestroyAll(this.registry.values(), ApplicationScoped.class);
            this.registry.clear();
        }

        public void register(MetaInfo metaInfo) {
            this.registry.put(metaInfo.getClassName(), metaInfo);
        }

        public boolean isPublicField(String className, String field) {
            MetaInfo metaInfo = this.get(className);
            return null != metaInfo && metaInfo.publicFields.containsKey(field) && this.isSimpleBean(className);
        }

        private boolean isSimpleBean(String className) {
            ClassNode node = this.classInfoRepository.node(className);
            if (null == node) {
                return false;
            }
            return node.hasInterface(INTF_SIMPLE_BEAN);
        }

        public MetaInfo get(String className) {
            return this.registry.get(className);
        }

        public Lang.Option<MetaInfo> safeGet(String className) {
            return $.some((Object)this.get(className));
        }
    }

    @ApplicationScoped
    public static class MetaInfo
    extends DestroyableBase {
        private String className;
        private Map<String, Lang.T2<String, String>> publicFields;
        private Set<String> sensitiveFields;
        private Set<String> passwordFields;
        private Map<String, String> fieldAliases;

        @Inject
        MetaInfo(String className, Map<String, Lang.T2<String, String>> publicFields, Map<String, String> aliases) {
            this.className = className;
            this.publicFields = publicFields;
            this.sensitiveFields = new HashSet<String>();
            this.passwordFields = new HashSet<String>();
            this.fieldAliases = aliases;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public Map<String, Lang.T2<String, String>> getPublicFields() {
            return C.map(this.publicFields);
        }

        public void addSensitiveField(String fieldName) {
            E.illegalArgumentIf((boolean)this.passwordFields.contains(fieldName), (String)"@Sensitive and @Password cannot be used together");
            this.sensitiveFields.add(fieldName);
        }

        public void addPasswordField(String fieldName) {
            E.illegalArgumentIf((boolean)this.sensitiveFields.contains(fieldName), (String)"@Sensitive and @Password cannot be used together");
            this.passwordFields.add(fieldName);
        }

        public boolean isSensitive(String fieldName) {
            return this.sensitiveFields.contains(fieldName);
        }

        public String aliasOf(String fieldName) {
            String s = this.fieldAliases.get(fieldName);
            return null == s ? fieldName : s;
        }

        public boolean isPassword(String fieldName) {
            return this.passwordFields.contains(fieldName);
        }

        public boolean hasPublicField() {
            return !this.publicFields.isEmpty();
        }

        @Override
        protected void releaseResources() {
            this.publicFields.clear();
        }

        static boolean isBoolean(String desc) {
            return "Z".equals(desc) || "java/lang/Boolean".equals(desc);
        }
    }
}

