/*
 * Decompiled with CFR 0.152.
 */
package act.validation;

import act.Act;
import act.app.App;
import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.AsmContext;
import act.asm.AsmException;
import act.asm.ClassVisitor;
import act.asm.FieldVisitor;
import act.asm.Handle;
import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.asm.TypePath;
import act.internal.password.MultiplePasswordProvider;
import act.internal.password.PasswordMetaInfo;
import act.internal.password.PasswordProvider;
import act.meta.ClassMetaInfoManager;
import act.util.AppByteCodeEnhancer;
import act.util.ByteCodeVisitor;
import act.validation.PasswordHandler;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.Payload;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@Target(value={ElementType.FIELD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={PasswordHandler.class})
public @interface Password {
    public static final String ASM_DESC = Type.getType(Password.class).getDescriptor();
    public static final String DEFAULT_PATTERN = "__def__";

    public String value() default "__def__";

    public String message() default "{act.validation.constraints.Password.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Verifier {
        public static boolean verifyPassword(char[] passwordText, Object passwordHolder) {
            E.illegalStateIfNot((boolean)(passwordHolder instanceof PasswordProvider), (String)"passwordHolder is not a PasswordProvider");
            return Verifier.verifyPassword(passwordText, (PasswordProvider)passwordHolder);
        }

        public static boolean verifyPassword(char[] passwordText, PasswordProvider passwordHolder) {
            boolean ok = Act.crypto().verifyPassword(passwordText, passwordHolder.password());
            Arrays.fill(passwordText, '\u0000');
            return ok;
        }

        public static boolean verifyPassword(char[] passwordText, Object passwordHolder, String fieldName) {
            E.illegalStateIfNot((boolean)(passwordHolder instanceof MultiplePasswordProvider), (String)"passwordHolder is not a MultiplePasswordProvider");
            return Verifier.verifyPassword(passwordText, (MultiplePasswordProvider)passwordHolder, fieldName);
        }

        public static boolean verifyPassword(char[] passwordText, MultiplePasswordProvider passwordHolder, String fieldName) {
            boolean ok = Act.crypto().verifyPassword(passwordText, passwordHolder.password(fieldName));
            Arrays.fill(passwordText, '\u0000');
            return ok;
        }
    }

    public static interface Validator {
        public boolean isValid(char[] var1);
    }

    public static class Enhancer
    extends AppByteCodeEnhancer<Enhancer> {
        static final String DESC_CHAR_ARRAY = "([C)V";
        private Set<String> passwordFieldSetters = new HashSet<String>();
        private String className;
        private String classInternalName;
        private ClassMetaInfoManager<PasswordMetaInfo> metaInfoManager;
        private PasswordMetaInfo metaInfo;
        private boolean eligible;
        private boolean intfAdded;
        private boolean isSinglePasswordProvider;

        public Enhancer() {
            super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate());
        }

        public Enhancer(ClassVisitor cv) {
            super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate(), cv);
        }

        @Override
        public AppByteCodeEnhancer app(App app) {
            this.metaInfoManager = app.classMetaInfoManager(PasswordMetaInfo.class);
            return super.app(app);
        }

        @Override
        protected Class<Enhancer> subClass() {
            return Enhancer.class;
        }

        @Override
        protected void reset() {
            this.classInternalName = null;
            this.className = null;
            this.metaInfo = null;
            this.eligible = false;
            this.intfAdded = false;
            this.isSinglePasswordProvider = false;
            this.passwordFieldSetters.clear();
            super.reset();
        }

        @Override
        public int priority() {
            return 10;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classInternalName = name;
            this.className = Type.getObjectType((String)name).getClassName();
            this.metaInfo = this.metaInfoManager.get(this.className);
            boolean bl = this.eligible = null != this.metaInfo && this.metaInfo.hasPasswordField();
            if (this.eligible) {
                C.List intf;
                this.passwordFieldSetters.addAll((Collection<String>)C.list(this.metaInfo.passwordFieldNames()));
                C.List list = intf = null == interfaces ? C.newList() : C.newListOf((Object[])interfaces);
                if (this.metaInfo.isSinglePasswordProvider()) {
                    this.isSinglePasswordProvider = true;
                    String intfName = Type.getType(PasswordProvider.class).getInternalName();
                    if (!intf.contains((Object)intfName)) {
                        intf.add((Object)intfName);
                        this.intfAdded = true;
                    }
                } else {
                    String intfName = Type.getType(MultiplePasswordProvider.class).getInternalName();
                    if (!intf.contains((Object)intfName)) {
                        intf.add((Object)intfName);
                        this.intfAdded = true;
                    }
                }
                super.visit(version, access, name, signature, superName, (String[])intf.toArray((Object[])new String[intf.size()]));
            } else {
                super.visit(version, access, name, signature, superName, interfaces);
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            PasswordVerifierInvokeAdaptor mv = new PasswordVerifierInvokeAdaptor(super.visitMethod(access, name, desc, signature, exceptions), this.metaInfoManager);
            if (!this.eligible || !DESC_CHAR_ARRAY.equals(desc)) {
                return mv;
            }
            final String fieldName = this.fieldNameFromSetter(name);
            return null == fieldName || !this.passwordFieldSetters.contains(fieldName) ? mv : new MethodVisitor(327680, mv){

                public void visitCode() {
                    Enhancer.this.visitSetterCode(fieldName, this);
                    Enhancer.this.passwordFieldSetters.remove(fieldName);
                }
            };
        }

        public void visitEnd() {
            super.visitEnd();
            if (!this.eligible) {
                return;
            }
            for (String field : this.passwordFieldSetters) {
                MethodVisitor mv = this.visitMethod(1, Enhancer.setterName(field), DESC_CHAR_ARRAY, null, null);
                mv.visitCode();
                this.visitSetterCode(field, mv);
            }
            if (this.intfAdded) {
                MethodVisitor mv;
                if (this.isSinglePasswordProvider) {
                    mv = this.visitMethod(1, "password", "()[C", null, null);
                    mv.visitCode();
                    this.visitSinglePasswordProviderMethod(this.metaInfo.singlePasswordFieldName(), mv);
                } else {
                    mv = this.visitMethod(1, "password", "(Ljava/lang/String;)[C", null, null);
                    this.visitMultiplePasswordProviderMethod(mv);
                }
            }
        }

        private String fieldNameFromSetter(String methodName) {
            int len = methodName.length();
            if (len > 3 && methodName.startsWith("set")) {
                return S.lowerFirst((String)methodName.substring(3));
            }
            return null;
        }

        private void visitSetterCode(String field, MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "act/Act", "crypto", "()Lact/crypto/AppCrypto;", false);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "act/crypto/AppCrypto", "passwordHash", "([C)[C", false);
            mv.visitFieldInsn(181, this.classInternalName, field, "[C");
            mv.visitVarInsn(25, 1);
            mv.visitInsn(3);
            mv.visitMethodInsn(184, "java/util/Arrays", "fill", "([CC)V", false);
            mv.visitInsn(177);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }

        private void visitSinglePasswordProviderMethod(String field, MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classInternalName, field, "[C");
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        private void visitMultiplePasswordProviderMethod(MethodVisitor mv) {
            for (String field : this.metaInfo.passwordFieldNames()) {
                mv.visitLdcInsn((Object)field);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
                Label l1 = new Label();
                mv.visitJumpInsn(153, l1);
                Label l2 = new Label();
                mv.visitLabel(l2);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.classInternalName, field, "[C");
                mv.visitInsn(176);
                mv.visitLabel(l1);
                mv.visitFrame(3, 0, null, 0, null);
            }
            mv.visitInsn(176);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "()V", false);
            mv.visitInsn(191);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }

        private static String setterName(String fieldName) {
            return "set" + S.capFirst((String)fieldName);
        }

        private static class PasswordVerifierInvokeAdaptor
        extends MethodVisitor {
            private Map<Integer, String> localVarTable = new HashMap<Integer, String>();
            private LastInsnInfo lastInsnInfo;
            private java.util.List<CallContext> callContexts = new ArrayList<CallContext>();
            private ClassMetaInfoManager<PasswordMetaInfo> metaInfoManager;

            public PasswordVerifierInvokeAdaptor(MethodVisitor mv, ClassMetaInfoManager<PasswordMetaInfo> metaInfoManager) {
                super(327680, mv);
                this.metaInfoManager = metaInfoManager;
            }

            public void visitInsn(int opcode) {
                this.lastInsnInfo = null;
                super.visitInsn(opcode);
            }

            public void visitIntInsn(int opcode, int operand) {
                this.lastInsnInfo = null;
                super.visitIntInsn(opcode, operand);
            }

            public void visitVarInsn(int opcode, int var) {
                if (25 == opcode) {
                    this.lastInsnInfo = new LastInsnInfo();
                    this.lastInsnInfo.varIndex = var;
                } else {
                    this.lastInsnInfo = null;
                }
                super.visitVarInsn(opcode, var);
            }

            public void visitTypeInsn(int opcode, String type) {
                this.lastInsnInfo = null;
                super.visitTypeInsn(opcode, type);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                this.lastInsnInfo = new LastInsnInfo();
                this.lastInsnInfo.fieldDesc = desc;
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                this.lastInsnInfo = null;
                super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
            }

            public void visitJumpInsn(int opcode, Label label) {
                this.lastInsnInfo = null;
                super.visitJumpInsn(opcode, label);
            }

            public void visitLabel(Label label) {
                this.lastInsnInfo = null;
                super.visitLabel(label);
            }

            public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                this.lastInsnInfo = null;
                return super.visitInsnAnnotation(typeRef, typePath, desc, visible);
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                this.lastInsnInfo = null;
                super.visitFrame(type, nLocal, local, nStack, stack);
            }

            public void visitLdcInsn(Object cst) {
                this.lastInsnInfo = null;
                super.visitLdcInsn(cst);
            }

            public void visitIincInsn(int var, int increment) {
                this.lastInsnInfo = null;
                super.visitIincInsn(var, increment);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                this.visitMethodInsn(opcode, owner, name, desc, false);
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                this.lastInsnInfo = null;
                super.visitTableSwitchInsn(min, max, dflt, labels);
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                this.lastInsnInfo = null;
                super.visitLookupSwitchInsn(dflt, keys, labels);
            }

            public void visitMultiANewArrayInsn(String desc, int dims) {
                this.lastInsnInfo = null;
                super.visitMultiANewArrayInsn(desc, dims);
            }

            public void visitLineNumber(int line, Label start) {
                this.lastInsnInfo = null;
                super.visitLineNumber(line, start);
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                this.localVarTable.put(index, desc);
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (184 == opcode && !itf && "verifyPassword".equals(name) && "act/validation/Password$Verifier".equals(owner)) {
                    PasswordMetaInfo metaInfo = null;
                    if (!this.lastInsnInfo.isVarIndex()) {
                        PasswordMetaInfo passwordMetaInfo = metaInfo = null == this.lastInsnInfo ? null : this.lastInsnInfo.metaInfo(this.localVarTable, this.metaInfoManager);
                        if (null == metaInfo) {
                            throw AsmException.of((String)"Cannot call Password.Verifier.verifyPassword on object without a @Password field", (Object[])new Object[0]);
                        }
                    } else {
                        CallContext ctx = new CallContext(this.lastInsnInfo.varIndex, AsmContext.line(), desc);
                        this.callContexts.add(ctx);
                    }
                    if ("([CLjava/lang/Object;)Z".equals(desc)) {
                        if (null != metaInfo && !metaInfo.isSinglePasswordProvider()) {
                            throw AsmException.of((String)"Cannot call Password.Verifier.verifyPassword on object with multiple @Password fields without field name parameter", (Object[])new Object[0]);
                        }
                        super.visitMethodInsn(opcode, owner, name, "([CLact/internal/password/PasswordProvider;)Z", itf);
                        return;
                    } else {
                        if (!"([CLjava/lang/Object;Ljava/lang/String;)Z".equals(desc)) throw AsmException.of((String)("Unknown Password.Verifier.verifyPassword call: " + desc), (Object[])new Object[0]);
                        if (null != metaInfo && metaInfo.isSinglePasswordProvider()) {
                            throw AsmException.of((String)"It shall call Password.Verifier.verifyPassword on object with single @Password field without field name parameter", (Object[])new Object[0]);
                        }
                        super.visitMethodInsn(opcode, owner, name, "([CLact/internal/password/PasswordProvider;Ljava/lang/String;)Z", itf);
                    }
                    return;
                } else {
                    this.lastInsnInfo = new LastInsnInfo();
                    this.lastInsnInfo.methodDesc = desc;
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            public void visitEnd() {
                if (this.localVarTable.isEmpty()) {
                    if (!this.callContexts.isEmpty()) {
                        logger.warn("Local Variable Table is empty. Cannot verify Password.Verifier.verifyPassword call");
                    }
                } else if (!this.callContexts.isEmpty()) {
                    for (CallContext ctx : this.callContexts) {
                        AsmContext.line((int)ctx.lineNumber);
                        String varDesc = this.localVarTable.get(ctx.varIndex);
                        if (null == varDesc) {
                            throw AsmException.of((String)("Cannot find var descriptor by var index: " + ctx.varIndex), (Object[])new Object[0]);
                        }
                        String className = Type.getType((String)varDesc).getClassName();
                        PasswordMetaInfo metaInfo = this.metaInfoManager.get(className);
                        if (null == metaInfo) {
                            throw AsmException.of((String)"Cannot call Password.Verifier.verifyPassword on object without a @Password field", (Object[])new Object[0]);
                        }
                        if (!("([CLjava/lang/Object;)Z".equals(ctx.methodDescriptor) ? !metaInfo.isSinglePasswordProvider() : "([CLjava/lang/Object;Ljava/lang/String;)Z".equals(ctx.methodDescriptor) && metaInfo.isSinglePasswordProvider())) continue;
                        throw AsmException.of((String)"It shall call Password.Verifier.verifyPassword on object with single @Password field without field name parameter", (Object[])new Object[0]);
                    }
                }
                super.visitEnd();
            }

            private static class CallContext {
                int varIndex;
                int lineNumber;
                String methodDescriptor;

                public CallContext(int varIndex, int lineNumber, String methodDescriptor) {
                    this.varIndex = varIndex;
                    this.lineNumber = lineNumber;
                    this.methodDescriptor = methodDescriptor;
                }
            }

            private static class LastInsnInfo {
                private String fieldDesc;
                private int varIndex = -1;
                private String methodDesc;

                private LastInsnInfo() {
                }

                PasswordMetaInfo metaInfo(Map<Integer, String> localVarTable, ClassMetaInfoManager<PasswordMetaInfo> metaInfoManager) {
                    try {
                        String className;
                        if (null != this.fieldDesc) {
                            className = Type.getType((String)this.fieldDesc).getClassName();
                        } else if (this.varIndex > -1) {
                            className = Type.getType((String)localVarTable.get(this.varIndex)).getClassName();
                        } else {
                            String desc = S.afterLast((String)")", (String)this.methodDesc);
                            className = Type.getType((String)desc).getClassName();
                        }
                        PasswordMetaInfo metaInfo = metaInfoManager.get(className);
                        if (null == metaInfo) {
                            throw new AsmException("Cannot find password meta info", new Object[0]);
                        }
                        return metaInfo;
                    }
                    catch (Exception e) {
                        throw new AsmException((Throwable)e);
                    }
                }

                boolean isVarIndex() {
                    return this.varIndex > -1;
                }
            }
        }
    }

    public static class ByteCodeScanner
    extends AppByteCodeScannerBase {
        @Override
        protected boolean shouldScan(String className) {
            return true;
        }

        @Override
        public ByteCodeVisitor byteCodeVisitor() {
            return new ByteCodeVisitor(){
                private String className;
                private ClassMetaInfoManager<PasswordMetaInfo> metaInfoManager;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.className = Type.getObjectType((String)name).getClassName();
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
                    FieldVisitor fv = super.visitField(access, name, desc, signature, value);
                    final String fieldDesc = desc;
                    return new FieldVisitor(327680, fv){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            if (ASM_DESC.equals(desc)) {
                                E.illegalStateIfNot((boolean)"[C".equals(fieldDesc), (String)"@Password works on char[] typed field only");
                                ((PasswordMetaInfo)this.manager().getOrCreate(className)).addPasswordField(name, desc);
                            }
                            return super.visitAnnotation(desc, visible);
                        }
                    };
                }

                private ClassMetaInfoManager<PasswordMetaInfo> manager() {
                    if (null == this.metaInfoManager) {
                        this.metaInfoManager = Act.app().classMetaInfoManager(PasswordMetaInfo.class);
                    }
                    return this.metaInfoManager;
                }
            };
        }

        @Override
        public void scanFinished(String className) {
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public Password[] value();
    }
}

