/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.rythmengine.extension.Transformer;
import org.rythmengine.template.ITemplate;

public class JodaTransformers {
    static String format(ReadableInstant dateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return formatter.print(dateTime);
    }

    static String format(ReadablePartial dateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return formatter.print(dateTime);
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(DateTime dateTime) {
        return JodaTransformers.shortStyle(null, dateTime);
    }

    public static String shortStyle(ITemplate template, DateTime dateTime) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadableInstant)dateTime, DateTimeFormat.patternForStyle((String)"SS", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(DateTime dateTime) {
        return JodaTransformers.mediumStyle(null, dateTime);
    }

    public static String mediumStyle(ITemplate template, DateTime dateTime) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadableInstant)dateTime, DateTimeFormat.patternForStyle((String)"MM", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(DateTime dateTime) {
        return JodaTransformers.longStyle(null, dateTime);
    }

    public static String longStyle(ITemplate template, DateTime dateTime) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadableInstant)dateTime, DateTimeFormat.patternForStyle((String)"LL", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(LocalDateTime dateTime) {
        return JodaTransformers.shortStyle(null, dateTime);
    }

    public static String shortStyle(ITemplate template, LocalDateTime dateTime) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)dateTime, DateTimeFormat.patternForStyle((String)"SS", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(LocalDateTime dateTime) {
        return JodaTransformers.mediumStyle(null, dateTime);
    }

    public static String mediumStyle(ITemplate template, LocalDateTime dateTime) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)dateTime, DateTimeFormat.patternForStyle((String)"MM", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(LocalDateTime dateTime) {
        return JodaTransformers.longStyle(null, dateTime);
    }

    public static String longStyle(ITemplate template, LocalDateTime dateTime) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)dateTime, DateTimeFormat.patternForStyle((String)"LL", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(LocalDate LocalDate2) {
        return JodaTransformers.shortStyle(null, LocalDate2);
    }

    public static String shortStyle(ITemplate template, LocalDate LocalDate2) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalDate2, DateTimeFormat.patternForStyle((String)"S-", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(LocalDate LocalDate2) {
        return JodaTransformers.mediumStyle(null, LocalDate2);
    }

    public static String mediumStyle(ITemplate template, LocalDate LocalDate2) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalDate2, DateTimeFormat.patternForStyle((String)"M-", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(LocalDate LocalDate2) {
        return JodaTransformers.longStyle(null, LocalDate2);
    }

    public static String longStyle(ITemplate template, LocalDate LocalDate2) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalDate2, DateTimeFormat.patternForStyle((String)"L-", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String shortStyle(LocalTime LocalTime2) {
        return JodaTransformers.shortStyle(null, LocalTime2);
    }

    public static String shortStyle(ITemplate template, LocalTime LocalTime2) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalTime2, DateTimeFormat.patternForStyle((String)"-S", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String mediumStyle(LocalTime LocalTime2) {
        return JodaTransformers.mediumStyle(null, LocalTime2);
    }

    public static String mediumStyle(ITemplate template, LocalTime LocalTime2) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalTime2, DateTimeFormat.patternForStyle((String)"-M", (Locale)locale));
    }

    @Transformer(requireTemplate=true)
    public static String longStyle(LocalTime LocalTime2) {
        return JodaTransformers.longStyle(null, LocalTime2);
    }

    public static String longStyle(ITemplate template, LocalTime LocalTime2) {
        Locale locale = null == template ? Locale.getDefault() : template.__curLocale();
        return JodaTransformers.format((ReadablePartial)LocalTime2, DateTimeFormat.patternForStyle((String)"-L", (Locale)locale));
    }
}

