/*
 * Decompiled with CFR 0.152.
 */
package act.ws;

import act.util.DestroyableBase;
import act.xio.WebSocketConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.Lang;
import org.osgl.util.C;

public class WebSocketConnectionRegistry
extends DestroyableBase {
    private ConcurrentMap<String, ConcurrentMap<WebSocketConnection, WebSocketConnection>> registry = new ConcurrentHashMap<String, ConcurrentMap<WebSocketConnection, WebSocketConnection>>();

    public List<WebSocketConnection> get(String key) {
        ArrayList<WebSocketConnection> retList = new ArrayList<WebSocketConnection>();
        this.accept(key, (Lang.Function<WebSocketConnection, ?>)C.F.addTo(retList));
        return retList;
    }

    public void accept(String key, Lang.Function<WebSocketConnection, ?> visitor) {
        ConcurrentMap connections = (ConcurrentMap)this.registry.get(key);
        if (null == connections) {
            return;
        }
        if (!connections.isEmpty()) {
            ArrayList<WebSocketConnection> toBeCleared = null;
            for (WebSocketConnection conn : connections.keySet()) {
                if (conn.closed()) {
                    if (null == toBeCleared) {
                        toBeCleared = new ArrayList<WebSocketConnection>();
                    }
                    toBeCleared.add(conn);
                    continue;
                }
                visitor.apply((Object)conn);
            }
            if (null != toBeCleared) {
                ConcurrentMap originalCopy = (ConcurrentMap)this.registry.get(key);
                originalCopy.keySet().removeAll(toBeCleared);
            }
        }
    }

    public void register(String key, WebSocketConnection connection) {
        this.signIn(key, connection);
    }

    public void signIn(String key, WebSocketConnection connection) {
        ConcurrentMap<WebSocketConnection, WebSocketConnection> bag = this.ensureConnectionList(key);
        bag.put(connection, connection);
    }

    public void register(String key, Collection<WebSocketConnection> connections) {
        this.signIn(key, connections);
    }

    public void signIn(String key, Collection<WebSocketConnection> connections) {
        if (connections.isEmpty()) {
            return;
        }
        HashMap<WebSocketConnection, WebSocketConnection> newMap = new HashMap<WebSocketConnection, WebSocketConnection>();
        for (WebSocketConnection conn : connections) {
            newMap.put(conn, conn);
        }
        ConcurrentMap<WebSocketConnection, WebSocketConnection> bag = this.ensureConnectionList(key);
        bag.putAll(newMap);
    }

    public void deRegister(String key, WebSocketConnection connection) {
        this.signOff(key, connection);
    }

    public void deRegister(String key, Collection<WebSocketConnection> connections) {
        this.signOff(key, connections);
    }

    public void signOff(String key, WebSocketConnection connection) {
        ConcurrentMap<WebSocketConnection, WebSocketConnection> connections = this.ensureConnectionList(key);
        if (null == connections) {
            return;
        }
        connections.remove(connection);
    }

    public void signOff(String key, Collection<WebSocketConnection> connections) {
        if (connections.isEmpty()) {
            return;
        }
        ConcurrentMap<WebSocketConnection, WebSocketConnection> bag = this.ensureConnectionList(key);
        bag.keySet().removeAll(connections);
    }

    public int count() {
        int n = 0;
        for (ConcurrentMap bag : this.registry.values()) {
            n += bag.size();
        }
        return n;
    }

    public int count(String key) {
        ConcurrentMap bag = (ConcurrentMap)this.registry.get(key);
        return null == bag ? 0 : bag.size();
    }

    @Override
    protected void releaseResources() {
        for (ConcurrentMap connections : this.registry.values()) {
            for (WebSocketConnection conn : connections.keySet()) {
                conn.destroy();
            }
        }
        this.registry.clear();
    }

    private ConcurrentMap<WebSocketConnection, WebSocketConnection> ensureConnectionList(String key) {
        ConcurrentMap<WebSocketConnection, WebSocketConnection> newConnections;
        ConcurrentMap<WebSocketConnection, WebSocketConnection> connections = (ConcurrentMap<WebSocketConnection, WebSocketConnection>)this.registry.get(key);
        if (null == connections && null == (connections = this.registry.putIfAbsent(key, newConnections = this.newConnectionBag()))) {
            connections = newConnections;
        }
        return connections;
    }

    private ConcurrentMap<WebSocketConnection, WebSocketConnection> newConnectionBag() {
        return new ConcurrentHashMap<WebSocketConnection, WebSocketConnection>();
    }
}

