/*
 * Decompiled with CFR 0.152.
 */
package act.xio;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.controller.meta.ActionMethodMetaInfo;
import act.util.DestroyableBase;
import act.ws.WebSocketConnectionManager;
import act.xio.Network;
import act.xio.NetworkHandler;
import act.xio.WebSocketConnectionHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.E;

public abstract class NetworkBase
extends DestroyableBase
implements Network {
    protected static final Logger logger = LogManager.get(Network.class);
    private volatile boolean started;
    private Map<Integer, NetworkHandler> registry = new HashMap<Integer, NetworkHandler>();
    private Map<Integer, NetworkHandler> failed = new HashMap<Integer, NetworkHandler>();
    private Set<Integer> securePorts = new HashSet<Integer>();
    private volatile WebSocketConnectionHandler simpleWebSocketConnector;

    @Override
    public synchronized void register(int port, boolean secure, NetworkHandler client) {
        E.NPE((Object)client);
        E.illegalArgumentIf((boolean)this.registry.containsKey(port), (String)"Port %s has been registered already", (Object[])new Object[]{port});
        this.registry.put(port, client);
        if (secure) {
            this.securePorts.add(port);
        }
        if (this.started) {
            if (!this.trySetUpClient(client, port, secure)) {
                this.failed.put(port, client);
            } else {
                logger.info("network client hooked on port: %s", new Object[]{port});
            }
        }
    }

    @Override
    public void start() {
        this.bootUp();
        for (int port : this.registry.keySet()) {
            NetworkHandler client = this.registry.get(port);
            if (!this.trySetUpClient(client, port, this.securePorts.contains(port))) {
                this.failed.put(port, client);
                continue;
            }
            Act.LOGGER.info("network client hooked on port: %s", new Object[]{port});
        }
        this.started = true;
        App app = Act.app();
        if (null != app) {
            app.registerHotReloadListener(new App.HotReloadListener(){

                @Override
                public void preHotReload() {
                    NetworkBase.this.simpleWebSocketConnector = null;
                }
            });
        }
    }

    @Override
    public void shutdown() {
        this.close();
    }

    protected void resetWebSocketConnectionHandler() {
        this.simpleWebSocketConnector = null;
    }

    private boolean trySetUpClient(NetworkHandler client, int port, boolean secure) {
        try {
            this.setUpClient(client, port, secure);
            return true;
        }
        catch (IOException e) {
            logger.warn((Throwable)e, "Cannot set up %s to port %s:", new Object[]{client, port});
            return false;
        }
    }

    protected abstract void setUpClient(NetworkHandler var1, int var2, boolean var3) throws IOException;

    protected abstract void bootUp();

    protected abstract void close();

    @Override
    protected void releaseResources() {
        super.releaseResources();
        Destroyable.Util.destroyAll(this.registry.values(), ApplicationScoped.class);
        this.registry.clear();
    }

    @Override
    public WebSocketConnectionHandler createWebSocketConnectionHandler(ActionMethodMetaInfo methodInfo) {
        WebSocketConnectionManager manager = Act.app().service(WebSocketConnectionManager.class);
        return this.internalCreateWsConnHandler(methodInfo, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketConnectionHandler createWebSocketConnectionHandler() {
        if (null == this.simpleWebSocketConnector) {
            NetworkBase networkBase = this;
            synchronized (networkBase) {
                if (null == this.simpleWebSocketConnector) {
                    WebSocketConnectionManager manager = Act.app().service(WebSocketConnectionManager.class);
                    this.simpleWebSocketConnector = this.internalCreateWsConnHandler(null, manager);
                }
            }
        }
        return this.simpleWebSocketConnector;
    }

    protected abstract WebSocketConnectionHandler internalCreateWsConnHandler(ActionMethodMetaInfo var1, WebSocketConnectionManager var2);
}

