/*
 * Decompiled with CFR 0.152.
 */
package act.xio;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.handler.RequestHandlerBase;
import act.inject.param.JsonDTO;
import act.inject.param.JsonDTOClassManager;
import act.inject.param.ParamValueLoader;
import act.inject.param.ParamValueLoaderManager;
import act.inject.param.ParamValueLoaderService;
import act.inject.param.ProvidedValueLoader;
import act.sys.Env;
import act.ws.WebSocketConnectionManager;
import act.ws.WebSocketContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.osgl.$;
import org.osgl.inject.BeanSpec;
import org.osgl.mvc.annotation.WsAction;
import org.osgl.mvc.result.BadRequest;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public abstract class WebSocketConnectionHandler
extends RequestHandlerBase {
    private static final Object[] DUMP_PARAMS = new Object[0];
    protected boolean disabled;
    protected ClassLoader cl;
    protected WebSocketConnectionManager connectionManager;
    protected ActionMethodMetaInfo handler;
    protected ControllerClassMetaInfo controller;
    protected Class<?> handlerClass;
    protected Method method;
    protected MethodAccess methodAccess;
    private int methodIndex;
    protected boolean isStatic;
    private ParamValueLoaderService paramLoaderService;
    private JsonDTOClassManager jsonDTOClassManager;
    private int paramCount;
    private int fieldsAndParamsCount;
    private String singleJsonFieldName;
    private List<BeanSpec> paramSpecs;
    private Object host;
    private boolean isWsHandler;
    private Class[] paramTypes;
    private boolean isSingleParam;

    protected WebSocketConnectionHandler(WebSocketConnectionManager manager) {
        this.connectionManager = manager;
        this.isWsHandler = false;
        this.disabled = true;
    }

    public WebSocketConnectionHandler(ActionMethodMetaInfo methodInfo, WebSocketConnectionManager manager) {
        ParamValueLoader[] loaders;
        this.connectionManager = (WebSocketConnectionManager)$.notNull((Object)manager);
        if (null == methodInfo) {
            this.isWsHandler = false;
            this.disabled = true;
            return;
        }
        App app = manager.app();
        this.cl = app.classLoader();
        this.handler = (ActionMethodMetaInfo)$.notNull((Object)methodInfo);
        this.controller = this.handler.classInfo();
        this.paramLoaderService = app.service(ParamValueLoaderManager.class).get(WebSocketContext.class);
        this.jsonDTOClassManager = app.service(JsonDTOClassManager.class);
        this.handlerClass = $.classForName((String)this.controller.className(), (ClassLoader)this.cl);
        this.disabled = !Env.matches(this.handlerClass);
        this.paramTypes = this.paramTypes(this.cl);
        try {
            this.method = this.handlerClass.getMethod(methodInfo.name(), this.paramTypes);
            this.isWsHandler = null != this.method.getAnnotation(WsAction.class);
            this.disabled = this.disabled || !Env.matches(this.method);
        }
        catch (NoSuchMethodException e) {
            throw E.unexpected((Throwable)e);
        }
        if (!this.isWsHandler || this.disabled) {
            return;
        }
        this.isStatic = methodInfo.isStatic();
        if (!this.isStatic) {
            this.methodAccess = MethodAccess.get(this.handlerClass);
            this.methodIndex = this.methodAccess.getIndex(methodInfo.name(), this.paramTypes);
            this.host = Act.getInstance(this.handlerClass);
        } else {
            this.method.setAccessible(true);
        }
        this.paramCount = this.handler.paramCount();
        this.paramSpecs = this.jsonDTOClassManager.beanSpecs(this.handlerClass, this.method);
        this.fieldsAndParamsCount = this.paramSpecs.size();
        if (this.fieldsAndParamsCount == 1) {
            this.singleJsonFieldName = this.paramSpecs.get(0).name();
        }
        if ((loaders = this.paramLoaderService.methodParamLoaders(this.host, this.method, null)).length > 0) {
            int realParamCnt = 0;
            for (ParamValueLoader loader : loaders) {
                if (loader instanceof ProvidedValueLoader) continue;
                ++realParamCnt;
            }
            this.isSingleParam = 1 == realParamCnt;
        }
    }

    @Override
    public String toString() {
        return "websocket connection handler";
    }

    public boolean isWsHandler() {
        return this.isWsHandler;
    }

    @Override
    public void prepareAuthentication(ActionContext context) {
    }

    protected void invoke(WebSocketContext context) {
        if (this.disabled) {
            return;
        }
        this.ensureJsonDTOGenerated(context);
        Object[] params = this.params(context);
        Object retVal = this.isStatic ? $.invokeStatic((Method)this.method, (Object[])params) : this.methodAccess.invoke(this.host, this.methodIndex, params);
        if (null == retVal) {
            return;
        }
        if (retVal instanceof String) {
            context.sendToSelf((String)retVal);
        } else {
            context.sendJsonToSelf(retVal);
        }
    }

    private Object[] params(WebSocketContext context) {
        if (0 == this.paramCount) {
            return DUMP_PARAMS;
        }
        Object[] params = this.paramLoaderService.loadMethodParams(this.host, this.method, context);
        if (this.isSingleParam) {
            for (int i = 0; i < this.paramCount; ++i) {
                if (null != params[i]) continue;
                String singleVal = context.stringMessage();
                Class paramType = this.paramTypes[i];
                StringValueResolver resolver = context.app().resolverManager().resolver(paramType);
                if (null != resolver) {
                    params[i] = resolver.apply(singleVal);
                    continue;
                }
                E.unexpected((String)"Cannot determine string value resolver for param type: %s", (Object[])new Object[]{paramType});
            }
        }
        return params;
    }

    private Class[] paramTypes(ClassLoader cl) {
        int sz = this.handler.paramCount();
        Class[] ca = new Class[sz];
        for (int i = 0; i < sz; ++i) {
            HandlerParamMetaInfo param = this.handler.param(i);
            ca[i] = $.classForName((String)param.type().getClassName(), (ClassLoader)cl);
        }
        return ca;
    }

    private void ensureJsonDTOGenerated(WebSocketContext context) {
        if (0 == this.fieldsAndParamsCount || !context.isJson()) {
            return;
        }
        Class<? extends JsonDTO> dtoClass = this.jsonDTOClassManager.get(this.handlerClass, this.method);
        if (null == dtoClass) {
            return;
        }
        try {
            JsonDTO dto = (JsonDTO)JSON.parseObject((String)this.patchedJsonBody(context), dtoClass);
            context.attribute("__json_dto__", dto);
        }
        catch (JSONException e) {
            if (e.getCause() != null) {
                this.logger.warn(e.getCause(), "error parsing JSON data");
            } else {
                this.logger.warn((Throwable)e, "error parsing JSON data");
            }
            throw new BadRequest(e.getCause());
        }
    }

    private String patchedJsonBody(WebSocketContext context) {
        boolean needPatch;
        String body = context.stringMessage();
        if (S.blank((String)body) || 1 < this.fieldsAndParamsCount) {
            return body;
        }
        String theName = this.singleJsonFieldName(context);
        int theNameLen = theName.length();
        if (null == theName) {
            return body;
        }
        boolean bl = needPatch = (body = body.trim()).charAt(0) == '[';
        if (!needPatch) {
            if (body.charAt(0) != '{') {
                throw new IllegalArgumentException("Cannot parse JSON string: " + body);
            }
            boolean startCheckName = false;
            int nameStart = -1;
            for (int i = 1; i < body.length(); ++i) {
                char c = body.charAt(i);
                if (c == ' ') continue;
                if (startCheckName) {
                    if (c == '\"') break;
                    int id = i - nameStart - 1;
                    if (id < theNameLen && theName.charAt(i - nameStart - 1) == c) continue;
                    needPatch = true;
                    break;
                }
                if (c != '\"') continue;
                startCheckName = true;
                nameStart = i;
            }
        }
        return needPatch ? S.fmt((String)"{\"%s\": %s}", (Object[])new Object[]{theName, body}) : body;
    }

    private String singleJsonFieldName(WebSocketContext context) {
        if (null != this.singleJsonFieldName) {
            return this.singleJsonFieldName;
        }
        Set<String> set = context.paramKeys();
        for (BeanSpec spec : this.paramSpecs) {
            String name = spec.name();
            if (set.contains(name)) continue;
            return name;
        }
        return null;
    }
}

