/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.ActResponse;
import act.app.ActionContext;
import act.app.App;
import act.conf.AppConfig;
import act.xio.NetworkHandler;
import act.xio.undertow.UndertowNetworkDispatcher;
import act.xio.undertow.UndertowRequest;
import act.xio.undertow.UndertowResponse;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.osgl.http.H;
import org.osgl.util.E;

public class ActHttpHandler
implements HttpHandler {
    private final NetworkHandler client;

    public ActHttpHandler(NetworkHandler client) {
        E.NPE((Object)client);
        this.client = client;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ActionContext ctx = this.createActionContext(exchange);
        this.client.handle(ctx, new UndertowNetworkDispatcher(exchange));
    }

    private ActionContext createActionContext(HttpServerExchange exchange) {
        App app = this.client.app();
        AppConfig<?> config = app.config();
        return ActionContext.create(app, this.req(exchange, config), this.resp(exchange, config));
    }

    private H.Request req(HttpServerExchange exchange, AppConfig config) {
        return new UndertowRequest(exchange, config);
    }

    private ActResponse<?> resp(HttpServerExchange exchange, AppConfig config) {
        return new UndertowResponse(exchange, config);
    }
}

