/*
 * Decompiled with CFR 0.152.
 */
package act.apidoc;

import act.Act;
import act.apidoc.Endpoint;
import act.apidoc.javadoc.Javadoc;
import act.apidoc.javadoc.JavadocBlockTag;
import act.apidoc.javadoc.JavadocParser;
import act.app.ActionContext;
import act.app.App;
import act.app.AppServiceBase;
import act.app.DevModeClassLoader;
import act.app.Source;
import act.app.event.SysEventId;
import act.app.util.NamedPort;
import act.conf.AppConfig;
import act.controller.Controller;
import act.handler.RequestHandler;
import act.handler.RequestHandlerBase;
import act.handler.builtin.ResourceGetter;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.route.Router;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.osgl.util.S;

public class ApiManager
extends AppServiceBase<ApiManager> {
    static final Logger LOGGER = LogManager.get(ApiManager.class);
    SortedSet<Endpoint> endpoints = new TreeSet<Endpoint>();
    private static final Set<String> actionAnnotations = C.set((Object)"Action", (Object[])new String[]{"GetAction", "PostAction", "PutAction", "DeleteAction"});

    public ApiManager(final App app) {
        super(app);
        if (!app.config().apiDocEnabled()) {
            return;
        }
        app.jobManager().alongWith(SysEventId.POST_START, "compile-api-book", new Runnable(){

            @Override
            public void run() {
                ApiManager.this.load(app);
            }
        });
        app.router().addMapping(H.Method.GET, (CharSequence)"/~/apibook/endpoint", new GetEndpointsHandler(this));
        ResourceGetter apidocHandler = new ResourceGetter("asset/~act/apibook/index.html");
        app.router().addMapping(H.Method.GET, (CharSequence)"/~/apibook", apidocHandler);
        app.router().addMapping(H.Method.GET, (CharSequence)"/~/apidoc", apidocHandler);
    }

    @Override
    protected void releaseResources() {
        this.endpoints.clear();
    }

    public void load(App app) {
        LOGGER.info("start compiling API book");
        Router router = app.router();
        AppConfig<?> config = app.config();
        HashSet<Class> controllerClasses = new HashSet<Class>();
        this.load(router, null, config, controllerClasses);
        for (NamedPort port : app.config().namedPorts()) {
            router = app.router(port);
            this.load(router, port, config, controllerClasses);
        }
        if (Act.isDev()) {
            this.exploreDescriptions(controllerClasses);
        }
    }

    private void load(Router router, NamedPort port, AppConfig config, final Set<Class> controllerClasses) {
        final int portNumber = null == port ? config.httpExternalPort() : port.port();
        final boolean isDev = Act.isDev();
        final boolean hideBuiltIn = this.app().config().isHideBuiltInEndpointsInApiDoc();
        router.accept(new Router.Visitor(){

            @Override
            public void visit(H.Method method, String path, RequestHandler handler) {
                if (this.showEndpoint(path, handler)) {
                    Endpoint endpoint = new Endpoint(portNumber, method, path, handler);
                    ApiManager.this.endpoints.add(endpoint);
                    if (isDev) {
                        controllerClasses.add(endpoint.controllerClass());
                    }
                }
            }

            private boolean showEndpoint(String path, RequestHandler handler) {
                return handler instanceof RequestHandlerProxy && (!hideBuiltIn || !path.startsWith("/~/"));
            }
        });
    }

    private void exploreDescriptions(Set<Class> controllerClasses) {
        DevModeClassLoader cl = (DevModeClassLoader)$.cast((Object)Act.app().classLoader());
        HashMap<String, Javadoc> methodJavaDocs = new HashMap<String, Javadoc>();
        for (Class controllerClass : controllerClasses) {
            Source src = cl.source(controllerClass);
            if (null == src) continue;
            try {
                CompilationUnit compilationUnit = JavaParser.parse((Reader)IO.reader((String)src.code()), (boolean)true);
                List types = compilationUnit.getTypes();
                for (TypeDeclaration type : types) {
                    if (!(type instanceof ClassOrInterfaceDeclaration)) continue;
                    this.exploreDeclaration((ClassOrInterfaceDeclaration)type, methodJavaDocs, "");
                }
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e, "error parsing source for " + controllerClass);
            }
        }
        for (Endpoint endpoint : this.endpoints) {
            List<Endpoint.ParamInfo> params;
            Javadoc javadoc = (Javadoc)methodJavaDocs.get(endpoint.getId());
            if (null == javadoc) continue;
            String desc = javadoc.getDescription().toText();
            if (S.notBlank((String)desc)) {
                endpoint.setDescription(desc);
            }
            if ((params = endpoint.getParams()).isEmpty()) continue;
            HashMap<String, Endpoint.ParamInfo> paramLookup = new HashMap<String, Endpoint.ParamInfo>();
            for (Endpoint.ParamInfo param : params) {
                paramLookup.put(param.getName(), param);
            }
            List<JavadocBlockTag> blockTags = javadoc.getBlockTags();
            for (JavadocBlockTag tag : blockTags) {
                String paramName;
                Endpoint.ParamInfo paramInfo;
                if (!"param".equals(tag.getTagName()) || null == (paramInfo = (Endpoint.ParamInfo)paramLookup.get(paramName = (String)tag.getName().get()))) continue;
                paramInfo.setDescription(tag.getContent().toText());
            }
        }
    }

    private void exploreDeclaration(ClassOrInterfaceDeclaration classDeclaration, Map<String, Javadoc> methodJavaDocs, String prefix) {
        String className = classDeclaration.getName();
        String newPrefix = S.blank((String)prefix) ? className : S.concat((String)prefix, (String)".", (String)className);
        for (Node node : classDeclaration.getChildrenNodes()) {
            Comment comment;
            if (node instanceof ClassOrInterfaceDeclaration) {
                this.exploreDeclaration((ClassOrInterfaceDeclaration)node, methodJavaDocs, newPrefix);
                continue;
            }
            if (!(node instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)node;
            List annoList = methodDeclaration.getAnnotations();
            boolean needJavadoc = false;
            if (null != annoList && !annoList.isEmpty()) {
                for (AnnotationExpr anno : annoList) {
                    String annoName = anno.getName().getName();
                    if (!actionAnnotations.contains(annoName)) continue;
                    needJavadoc = true;
                    break;
                }
            }
            if (!needJavadoc || !((comment = methodDeclaration.getComment()) instanceof JavadocComment)) continue;
            JavadocComment javadocComment = (JavadocComment)comment;
            Javadoc javadoc = JavadocParser.parse(javadocComment);
            methodJavaDocs.put(S.concat((String)newPrefix, (String)".", (String)methodDeclaration.getName()), javadoc);
        }
    }

    private class GetEndpointsHandler
    extends RequestHandlerBase {
        private ApiManager api;

        public GetEndpointsHandler(ApiManager api) {
            this.api = api;
        }

        @Override
        public void handle(ActionContext context) {
            Controller.Util.renderJson(this.api.endpoints).apply(context.req(), context.prepareRespForWrite());
        }

        @Override
        public void prepareAuthentication(ActionContext context) {
        }

        @Override
        public String toString() {
            return "API doc handler";
        }
    }
}

