/*
 * Decompiled with CFR 0.152.
 */
package act.apidoc;

import act.db.DbBind;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.ReadableInstant;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;

class BeanSpecInterpreter {
    BeanSpecInterpreter() {
    }

    String interpret(BeanSpec beanSpec) {
        List types;
        if (beanSpec.hasAnnotation(DbBind.class)) {
            return "String";
        }
        Class rawType = beanSpec.rawType();
        if (Collection.class.isAssignableFrom(rawType)) {
            List types2 = beanSpec.typeParams();
            if (types2.size() > 0) {
                return this.interpret(BeanSpec.of((Type)((Type)types2.get(0)), null, (Injector)beanSpec.injector())) + "[]";
            }
            return "any[]";
        }
        if (Map.class.isAssignableFrom(rawType) && (types = beanSpec.typeParams()).size() > 1) {
            Type key = (Type)types.get(0);
            Type val = (Type)types.get(1);
            String keyStr = this.interpret(BeanSpec.of((Type)key, null, (Injector)beanSpec.injector()));
            String valStr = this.interpret(BeanSpec.of((Type)val, null, (Injector)beanSpec.injector()));
            if ("String".equals(keyStr) && "Object".equals(valStr)) {
                return "js object";
            }
            return "map of (" + keyStr + ", " + valStr + ")";
        }
        if (Number.class.isAssignableFrom(rawType)) {
            return "number";
        }
        if (Date.class.isAssignableFrom(rawType)) {
            return "datetime";
        }
        if (ReadableInstant.class.isAssignableFrom(rawType)) {
            return "datetime";
        }
        if (rawType.getName().contains("ObjectId")) {
            return "id (String)";
        }
        return rawType.getSimpleName();
    }
}

