/*
 * Decompiled with CFR 0.152.
 */
package act.apidoc;

import act.Act;
import act.apidoc.ApiManager;
import act.apidoc.BeanSpecInterpreter;
import act.apidoc.Description;
import act.app.data.StringValueResolverManager;
import act.conf.AppConfig;
import act.data.DataPropertyRepository;
import act.data.Sensitive;
import act.handler.RequestHandler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.inject.DefaultValue;
import act.inject.DependencyInjector;
import act.inject.param.ParamValueLoaderService;
import act.util.FastJsonPropertyPreFilter;
import act.util.PropertySpec;
import act.validation.NotBlank;
import com.alibaba.fastjson.JSON;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.bval.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.Result;
import org.osgl.storage.ISObject;
import org.osgl.util.C;
import org.osgl.util.Generics;
import org.osgl.util.N;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class Endpoint
implements Comparable<Endpoint> {
    private static final Logger LOGGER = ApiManager.LOGGER;
    private static BeanSpecInterpreter beanSpecInterpretor = new BeanSpecInterpreter();
    private String id;
    private Scheme scheme = Scheme.HTTP;
    private int port;
    private H.Method httpMethod;
    private String path;
    private String handler;
    FastJsonPropertyPreFilter fastJsonPropertyPreFilter;
    private String description;
    private Class<?> returnType;
    private String returnSample;
    private List<ParamInfo> params = new ArrayList<ParamInfo>();
    private String sampleJsonPost;
    private String sampleQuery;
    private Class<?> controllerClass;
    private Locale defLocale;
    private static final Lang.Predicate<Field> FIELD_PREDICATE = new Lang.Predicate<Field>(){

        public boolean test(Field field) {
            return !ParamValueLoaderService.shouldWaive(field);
        }
    };

    Endpoint(int port, H.Method httpMethod, String path, RequestHandler handler) {
        AppConfig conf = Act.appConfig();
        this.httpMethod = (H.Method)$.requireNotNull((Object)httpMethod);
        String urlContext = conf.urlContext();
        this.path = null == urlContext || path.startsWith("/~/") ? (String)$.requireNotNull((Object)path) : S.concat((String)urlContext, (String)((String)$.requireNotNull((Object)path)));
        this.handler = handler.toString();
        this.port = port;
        this.defLocale = conf.locale();
        this.explore(handler);
    }

    @Override
    public int compareTo(Endpoint o) {
        int n = this.path.compareTo(o.path);
        if (0 != n) {
            return n;
        }
        return this.httpMethod.ordinal() - o.httpMethod.ordinal();
    }

    public String getId() {
        return this.id;
    }

    public String getXid() {
        return S.concat((Object)this.httpMethod, (Object)this.id.replace('.', '_'));
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public H.Method getHttpMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public Class<?> returnType() {
        return this.returnType;
    }

    public String getReturnSample() {
        return this.returnSample;
    }

    public String getReturnType() {
        if (Void.TYPE == this.returnType || Void.class == this.returnType) {
            return null;
        }
        return this.className(this.returnType);
    }

    public String getSampleJsonPost() {
        return this.sampleJsonPost;
    }

    public String getSampleQuery() {
        return this.sampleQuery;
    }

    public Class<?> controllerClass() {
        return this.controllerClass;
    }

    private void explore(RequestHandler handler) {
        RequestHandlerProxy proxy = (RequestHandlerProxy)$.cast((Object)handler);
        ReflectedHandlerInvoker invoker = (ReflectedHandlerInvoker)$.cast((Object)proxy.actionHandler().invoker());
        Class<?> controllerClass = invoker.controllerClass();
        Method method = invoker.method();
        this.returnType = method.getReturnType();
        PropertySpec pspec = method.getAnnotation(PropertySpec.class);
        if (null != pspec) {
            PropertySpec.MetaInfo propSpec = new PropertySpec.MetaInfo();
            for (String v : pspec.value()) {
                propSpec.onValue(v);
            }
            for (String v : pspec.http()) {
                propSpec.onValue(v);
            }
            List<String> outputs = propSpec.outputFieldsForHttp();
            Set<String> excluded = propSpec.excludeFieldsForHttp();
            if (!outputs.isEmpty() || !excluded.isEmpty()) {
                this.fastJsonPropertyPreFilter = new FastJsonPropertyPreFilter(this.returnType, outputs, excluded, Act.app().service(DataPropertyRepository.class));
            }
        }
        this.id = this.id(method);
        this.returnSample = this.generateSampleJson(BeanSpec.of((Type)method.getGenericReturnType(), null, Act.injector()));
        Description descAnno = method.getAnnotation(Description.class);
        this.description = null == descAnno ? this.methodDescription(method) : descAnno.value();
        this.exploreParamInfo(method);
        if (!Modifier.isStatic(method.getModifiers())) {
            this.exploreParamInfo(controllerClass);
        }
        this.controllerClass = controllerClass;
    }

    private String methodDescription(Method method) {
        return this.id(method);
    }

    private String id(Method method) {
        Class<?> hosting = method.getDeclaringClass();
        return this.className(hosting) + "." + method.getName();
    }

    private String className(Class<?> clz) {
        Class<?> enclosing = clz.getEnclosingClass();
        if (null != enclosing) {
            return this.className(enclosing) + "." + clz.getSimpleName();
        }
        return clz.getSimpleName();
    }

    private void exploreParamInfo(Method method) {
        Type[] paramTypes = method.getGenericParameterTypes();
        int paramCount = paramTypes.length;
        if (0 == paramCount) {
            return;
        }
        Object injector = Act.injector();
        Annotation[][] allAnnos = method.getParameterAnnotations();
        HashMap sampleData = new HashMap();
        StringValueResolverManager resolver = Act.app().resolverManager();
        ArrayList<String> sampleQuery = new ArrayList<String>();
        for (int i = 0; i < paramCount; ++i) {
            Type type = paramTypes[i];
            Annotation[] annos = allAnnos[i];
            ParamInfo info = this.paramInfo(type, annos, (DependencyInjector)injector, null);
            if (null == info) continue;
            this.params.add(info);
            if (this.path.contains("{" + info.getName() + "}")) continue;
            Object sample = null != info.defaultValue ? resolver.resolve(info.defaultValue, info.beanSpec.rawType()) : this.generateSampleData(info.beanSpec, new HashSet<Type>(), new ArrayList<String>());
            if (H.Method.GET == this.httpMethod) {
                String query = this.generateSampleQuery(info.beanSpec.withoutName(), info.bindName, new HashSet<Type>(), (List<String>)C.newList());
                if (!S.notBlank((String)query)) continue;
                sampleQuery.add(query);
                continue;
            }
            sampleData.put(info.bindName, sample);
        }
        if (!sampleData.isEmpty()) {
            this.sampleJsonPost = JSON.toJSONString(sampleData, (boolean)true);
        }
        if (!sampleQuery.isEmpty()) {
            this.sampleQuery = S.join((String)"&", sampleQuery);
        }
    }

    private void exploreParamInfo(Class<?> controller) {
        Object injector = Act.injector();
        List fields = $.fieldsOf(controller, FIELD_PREDICATE);
        for (Field field : fields) {
            Annotation[] annos;
            Type type = field.getGenericType();
            ParamInfo info = this.paramInfo(type, annos = field.getAnnotations(), (DependencyInjector)injector, field.getName());
            if (null == info) continue;
            this.params.add(info);
        }
    }

    private ParamInfo paramInfo(Type type, Annotation[] annos, DependencyInjector injector, String name) {
        if (this.isLoginUser(annos)) {
            return null;
        }
        BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])annos, (String)name, (Injector)injector);
        if (ParamValueLoaderService.providedButNotDbBind(spec, injector)) {
            return null;
        }
        if (ParamValueLoaderService.hasDbBind(spec.allAnnotations())) {
            if (S.blank((String)name)) {
                name = spec.name();
            }
            return new ParamInfo(name, BeanSpec.of(String.class, Act.injector()), name + " id");
        }
        String description = "";
        Description descAnno = (Description)spec.getAnnotation(Description.class);
        if (null != descAnno) {
            description = descAnno.value();
        }
        return new ParamInfo(spec.name(), spec, description);
    }

    private boolean isLoginUser(Annotation[] annos) {
        for (Annotation a : annos) {
            if (!"LoginUser".equals(a.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private String generateSampleJson(BeanSpec spec) {
        Class type = spec.rawType();
        if (Result.class.isAssignableFrom(type)) {
            return null;
        }
        Object sample = this.generateSampleData(spec, new HashSet<Type>(), new ArrayList<String>());
        if (null == sample) {
            return null;
        }
        if ($.isSimpleType((Class)type)) {
            sample = C.Map((Object[])new Object[]{"result", sample});
        }
        return JSON.toJSONString((Object)sample, (boolean)true);
    }

    private String generateSampleQuery(BeanSpec spec, String bindName, Set<Type> typeChain, List<String> nameChain) {
        Class type = spec.rawType();
        String specName = spec.name();
        if (S.notBlank((String)specName)) {
            nameChain.add(specName);
        }
        if ($.isSimpleType((Class)type)) {
            Object o = this.generateSampleData(spec, typeChain, nameChain);
            if (null == o) {
                return "";
            }
            return bindName + "=" + o;
        }
        if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            BeanSpec elementSpec = BeanSpec.of(elementType, Act.injector());
            if ($.isSimpleType(elementType)) {
                Object o = this.generateSampleData(elementSpec, typeChain, nameChain);
                if (null == o) {
                    return "";
                }
                return bindName + "=" + o + "&" + bindName + "=" + this.generateSampleData(elementSpec, typeChain, nameChain);
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            List typeParams = spec.typeParams();
            Object elementType = typeParams.isEmpty() ? Object.class : (Type)typeParams.get(0);
            BeanSpec elementSpec = BeanSpec.of(elementType, null, Act.injector());
            if ($.isSimpleType((Class)elementSpec.rawType())) {
                Object o = this.generateSampleData(elementSpec, typeChain, nameChain);
                if (null == o) {
                    return "";
                }
                return bindName + "=" + o + "&" + bindName + "=" + this.generateSampleData(elementSpec, typeChain, nameChain);
            }
        } else {
            if (Map.class.isAssignableFrom(type)) {
                LOGGER.warn("Map not supported yet");
                return "";
            }
            if (ReadableInstant.class.isAssignableFrom(type)) {
                return bindName + "=<datetime>";
            }
        }
        if (null != Endpoint.stringValueResolver(type)) {
            return bindName + "=" + S.random((int)5);
        }
        ArrayList<String> queryPairs = new ArrayList<String>();
        List fields = $.fieldsOf((Class)type);
        for (Field field : fields) {
            if (ParamValueLoaderService.shouldWaive(field)) continue;
            String fieldBindName = bindName + "." + field.getName();
            String pair = this.generateSampleQuery(BeanSpec.of((Field)field, Act.injector()), fieldBindName, (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain));
            if (!S.notBlank((String)pair)) continue;
            queryPairs.add(pair);
        }
        return S.join(queryPairs).by("&").get();
    }

    private static boolean isCollection(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)$.cast((Object)type);
            return Iterable.class.isAssignableFrom(clazz);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)$.cast((Object)type);
            return Endpoint.isCollection(ptype.getRawType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object generateSampleData(BeanSpec spec, Set<Type> typeChain, List<String> nameChain) {
        Class classType;
        block57: {
            block56: {
                Object componentType;
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block45: {
                                                        block46: {
                                                            block44: {
                                                                block42: {
                                                                    block43: {
                                                                        block41: {
                                                                            block40: {
                                                                                block39: {
                                                                                    block38: {
                                                                                        String path;
                                                                                        Type type = spec.type();
                                                                                        if (typeChain.contains(type) && !Endpoint.isCollection(type)) {
                                                                                            return S.concat((Object)spec.name(), (Object)":", (Object)type);
                                                                                        }
                                                                                        typeChain.add(type);
                                                                                        String name = spec.name();
                                                                                        if (S.notBlank((String)name)) {
                                                                                            nameChain.add(name);
                                                                                        }
                                                                                        if (null != this.fastJsonPropertyPreFilter && !this.fastJsonPropertyPreFilter.matches(path = S.join(nameChain).by(".").get())) {
                                                                                            return null;
                                                                                        }
                                                                                        classType = spec.rawType();
                                                                                        if (Void.TYPE != classType && Void.class != classType && !Result.class.isAssignableFrom(classType)) break block38;
                                                                                        Object var7_7 = null;
                                                                                        return var7_7;
                                                                                    }
                                                                                    if (Object.class != classType) break block39;
                                                                                    String string = "<Any>";
                                                                                    return string;
                                                                                }
                                                                                if (!classType.isEnum()) break block40;
                                                                                T[] ea = classType.getEnumConstants();
                                                                                int len = ea.length;
                                                                                Object var9_33 = 0 < len ? ea[N.randInt((int)len)] : null;
                                                                                return var9_33;
                                                                            }
                                                                            if (Locale.class != classType) break block41;
                                                                            Locale ea = this.defLocale;
                                                                            return ea;
                                                                        }
                                                                        if (String.class != classType) break block42;
                                                                        String mockValue = S.random((int)5);
                                                                        if (!spec.hasAnnotation(Sensitive.class)) break block43;
                                                                        String len = Act.crypto().encrypt(mockValue);
                                                                        return len;
                                                                    }
                                                                    String len = S.random((int)5);
                                                                    return len;
                                                                }
                                                                if (!classType.isArray()) break block44;
                                                                Object sample = Array.newInstance(classType.getComponentType(), 2);
                                                                Array.set(sample, 0, this.generateSampleData(BeanSpec.of(classType.getComponentType(), Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)));
                                                                Array.set(sample, 1, this.generateSampleData(BeanSpec.of(classType.getComponentType(), Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)));
                                                                Object len = sample;
                                                                return len;
                                                            }
                                                            if (!$.isSimpleType((Class)classType)) break block45;
                                                            if (Enum.class != classType) break block46;
                                                            String sample = "<Any Enum>";
                                                            return sample;
                                                        }
                                                        if (!classType.isPrimitive()) {
                                                            classType = $.primitiveTypeOf((Class)classType);
                                                        }
                                                        Object sample = ((StringValueResolver)StringValueResolver.predefined().get(classType)).resolve(null);
                                                        return sample;
                                                    }
                                                    if (!LocalDateTime.class.isAssignableFrom(classType)) break block47;
                                                    LocalDateTime sample = LocalDateTime.now();
                                                    return sample;
                                                }
                                                if (!DateTime.class.isAssignableFrom(classType)) break block48;
                                                DateTime sample = DateTime.now();
                                                return sample;
                                            }
                                            if (!LocalDate.class.isAssignableFrom(classType)) break block49;
                                            LocalDate sample = LocalDate.now();
                                            return sample;
                                        }
                                        if (!LocalTime.class.isAssignableFrom(classType)) break block50;
                                        LocalTime sample = LocalTime.now();
                                        return sample;
                                    }
                                    if (!Date.class.isAssignableFrom(classType)) break block51;
                                    Date sample = new Date();
                                    return sample;
                                }
                                if (!classType.getName().contains(".ObjectId")) break block52;
                                String sample = "<id>";
                                return sample;
                            }
                            if (BigDecimal.class != classType) break block53;
                            BigDecimal sample = BigDecimal.valueOf(1.1);
                            return sample;
                        }
                        if (BigInteger.class != classType) break block54;
                        BigInteger sample = BigInteger.valueOf(1L);
                        return sample;
                    }
                    if (!ISObject.class.isAssignableFrom(classType)) break block55;
                    Object sample = null;
                    return sample;
                }
                if (Map.class.isAssignableFrom(classType)) {
                    Map map = (Map)$.cast(Act.getInstance(classType));
                    List typeParams = spec.typeParams();
                    if (typeParams.isEmpty()) {
                        typeParams = Generics.typeParamImplementations((Class)classType, Map.class);
                    }
                    if (typeParams.size() < 2) {
                        map.put(S.random(), S.random());
                        map.put(S.random(), S.random());
                    } else {
                        Type keyType = (Type)typeParams.get(0);
                        Type valType = (Type)typeParams.get(1);
                        map.put(this.generateSampleData(BeanSpec.of((Type)keyType, null, Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)), this.generateSampleData(BeanSpec.of((Type)valType, null, Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)));
                        map.put(this.generateSampleData(BeanSpec.of((Type)keyType, null, Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)), this.generateSampleData(BeanSpec.of((Type)valType, null, Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)));
                    }
                    break block56;
                }
                if (!Iterable.class.isAssignableFrom(classType)) break block56;
                Collection col = (Collection)$.cast(Act.getInstance(classType));
                List typeParams = spec.typeParams();
                if (typeParams.isEmpty()) {
                    typeParams = Generics.typeParamImplementations((Class)classType, Map.class);
                }
                if (typeParams.isEmpty()) {
                    col.add(S.random());
                } else {
                    componentType = (Type)typeParams.get(0);
                    col.add(this.generateSampleData(BeanSpec.of((Type)componentType, null, Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)));
                    col.add(this.generateSampleData(BeanSpec.of((Type)componentType, null, Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain)));
                }
                componentType = col;
                return componentType;
            }
            if (null == Endpoint.stringValueResolver(classType)) break block57;
            String col = S.random((int)5);
            return col;
        }
        try {
            Object obj = Act.getInstance(classType);
            List fields = $.fieldsOf((Class)classType);
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers()) || ParamValueLoaderService.shouldWaive(field)) continue;
                Class<?> fieldType = field.getType();
                Object val = null;
                try {
                    field.setAccessible(true);
                    val = this.generateSampleData(BeanSpec.of((Field)field, Act.injector()), (Set<Type>)C.newSet(typeChain), (List<String>)C.newList(nameChain));
                    Class<?> valType = null == val ? null : val.getClass();
                    if (null == valType || !fieldType.isAssignableFrom(valType)) continue;
                    field.set(obj, val);
                }
                catch (Exception e) {
                    LOGGER.warn("Error setting value[%s] to field[%s.%s]", new Object[]{val, classType.getSimpleName(), field.getName()});
                }
            }
            Object t = obj;
            return t;
        }
        catch (Exception e) {
            LOGGER.warn("error generating sample data for type: %s", new Object[]{classType});
            Object var8_31 = null;
            return var8_31;
        }
    }

    private static <T> StringValueResolver stringValueResolver(Class<? extends T> type) {
        return Act.app().resolverManager().resolver(type);
    }

    public static enum Scheme {
        HTTP;

    }

    public static class ParamInfo {
        private String bindName;
        private BeanSpec beanSpec;
        private String description;
        private String defaultValue;
        private boolean required;
        private List<String> options;

        private ParamInfo(String bindName, BeanSpec beanSpec, String description) {
            this.bindName = bindName;
            this.beanSpec = beanSpec;
            this.description = description;
            this.defaultValue = this.checkDefaultValue(beanSpec);
            this.required = this.checkRequired(beanSpec);
            this.options = this.checkOptions(beanSpec);
        }

        public String getName() {
            return this.bindName;
        }

        public String getType() {
            return beanSpecInterpretor.interpret(this.beanSpec);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        private String checkDefaultValue(BeanSpec spec) {
            DefaultValue def = (DefaultValue)spec.getAnnotation(DefaultValue.class);
            if (null != def) {
                return def.value();
            }
            Class type = spec.rawType();
            if (type.isPrimitive()) {
                Object o = Act.app().resolverManager().resolve("", type);
                return null != o ? o.toString() : null;
            }
            return null;
        }

        private boolean checkRequired(BeanSpec spec) {
            return spec.hasAnnotation(NotNull.class) || spec.hasAnnotation(NotBlank.class) || spec.hasAnnotation(NotEmpty.class);
        }

        private List<String> checkOptions(BeanSpec spec) {
            Class type = spec.rawType();
            if (type.isEnum()) {
                return C.listOf((Object[])type.getEnumConstants()).map((Lang.Function)Lang.F.asString());
            }
            return null;
        }
    }
}

