/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.App;
import act.app.AppByteCodeScanner;
import act.app.AppClassInfoRepository;
import act.app.AppCodeScannerManager;
import act.app.AppService;
import act.app.RuntimeDirs;
import act.app.event.SysEventId;
import act.app.util.EnvMatcher;
import act.asm.AsmException;
import act.asm.ClassReader;
import act.asm.ClassVisitor;
import act.asm.ClassWriter;
import act.boot.BootstrapClassLoader;
import act.boot.app.FullStackAppBootstrapClassLoader;
import act.cli.meta.CommanderClassMetaInfo;
import act.cli.meta.CommanderClassMetaInfoHolder;
import act.cli.meta.CommanderClassMetaInfoManager;
import act.conf.AppConfig;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.ControllerClassMetaInfoHolder;
import act.controller.meta.ControllerClassMetaInfoManager;
import act.event.SysEventListenerBase;
import act.exception.EnvNotMatchException;
import act.job.meta.JobClassMetaInfo;
import act.job.meta.JobClassMetaInfoManager;
import act.mail.meta.MailerClassMetaInfo;
import act.mail.meta.MailerClassMetaInfoHolder;
import act.mail.meta.MailerClassMetaInfoManager;
import act.metric.Metric;
import act.metric.Timer;
import act.util.ActClassLoader;
import act.util.ByteCodeVisitor;
import act.util.ClassInfoRepository;
import act.util.ClassNames;
import act.util.ClassNode;
import act.util.Files;
import act.util.Jars;
import act.util.SimpleBean;
import act.view.ActErrorResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

@ApplicationScoped
public class AppClassLoader
extends ClassLoader
implements ControllerClassMetaInfoHolder,
CommanderClassMetaInfoHolder,
MailerClassMetaInfoHolder,
AppService<AppClassLoader>,
ActClassLoader {
    private static final Logger logger = L.get(AppClassLoader.class);
    private App app;
    private Map<String, byte[]> libClsCache = new HashMap<String, byte[]>();
    private ClassInfoRepository classInfoRepository;
    private boolean destroyed;
    protected ControllerClassMetaInfoManager controllerInfo;
    protected MailerClassMetaInfoManager mailerInfo = new MailerClassMetaInfoManager();
    protected CommanderClassMetaInfoManager commanderInfo = new CommanderClassMetaInfoManager();
    protected JobClassMetaInfoManager jobInfo = new JobClassMetaInfoManager();
    protected SimpleBean.MetaInfoManager simpleBeanInfo;
    protected Metric metric = Act.metricPlugin().metric("act:classload");
    private Lang.F1<String, byte[]> bytecodeLookup = new Lang.F1<String, byte[]>(){

        public byte[] apply(String s) throws NotAppliedException, Lang.Break {
            return AppClassLoader.this.appBytecode(s);
        }
    };
    private static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return AppClassLoader.class.getProtectionDomain();
        }
    });

    @Inject
    public AppClassLoader(final App app) {
        super(Act.class.getClassLoader());
        this.app = (App)$.notNull((Object)app);
        ClassInfoRepository actClassInfoRepository = Act.classInfoRepository();
        if (null != actClassInfoRepository) {
            this.classInfoRepository = new AppClassInfoRepository(app, actClassInfoRepository);
        }
        this.controllerInfo = new ControllerClassMetaInfoManager(app);
        if (null == app.eventBus()) {
            return;
        }
        this.simpleBeanInfo = new SimpleBean.MetaInfoManager(this);
        app.eventBus().bind(SysEventId.APP_CODE_SCANNED, new SysEventListenerBase(){

            @Override
            public String id() {
                return "appClassLoader:controllerInfo:mergeActionMetaInfo";
            }

            @Override
            public void on(EventObject event) throws Exception {
                AppClassLoader.this.controllerInfo.mergeActionMetaInfo(app);
            }
        });
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public Class<? extends Annotation> scope() {
        return ApplicationScoped.class;
    }

    @Override
    public AppClassLoader app(App app) {
        throw E.unsupport();
    }

    @Override
    public final App app() {
        return this.app;
    }

    @Override
    public final void destroy() {
        this.libClsCache.clear();
        this.controllerInfo.destroy();
        this.mailerInfo.destroy();
        this.jobInfo.destroy();
        this.simpleBeanInfo.destroy();
        this.releaseResources();
        this.destroyed = true;
    }

    @Override
    public ClassInfoRepository classInfoRepository() {
        return this.classInfoRepository;
    }

    protected void releaseResources() {
        this.classInfoRepository.destroy();
    }

    public void detectChanges() {
    }

    @Override
    public ControllerClassMetaInfo controllerClassMetaInfo(String controllerClassName) {
        return this.controllerInfo.controllerMetaInfo(controllerClassName);
    }

    public ControllerClassMetaInfoManager controllerClassMetaInfoManager() {
        return this.controllerInfo;
    }

    @Override
    public CommanderClassMetaInfo commanderClassMetaInfo(String commanderClassName) {
        return this.commanderInfo.commanderMetaInfo(commanderClassName);
    }

    public CommanderClassMetaInfoManager commanderClassMetaInfoManager() {
        return this.commanderInfo;
    }

    public SimpleBean.MetaInfoManager simpleBeanInfoManager() {
        return this.simpleBeanInfo;
    }

    @Override
    public MailerClassMetaInfo mailerClassMetaInfo(String className) {
        return this.mailerInfo.mailerMetaInfo(className);
    }

    public MailerClassMetaInfoManager mailerClassMetaInfoManager() {
        return this.mailerInfo;
    }

    public JobClassMetaInfo jobClassMetaInfo(String jobClassName) {
        return this.jobInfo.jobMetaInfo(jobClassName);
    }

    public JobClassMetaInfoManager jobClassMetaInfoManager() {
        return this.jobInfo;
    }

    public SimpleBean.MetaInfo simpleBeanMetaInfo(String className) {
        return this.simpleBeanInfo.get(className);
    }

    public boolean isSourceClass(String className) {
        return false;
    }

    @Override
    public Class<?> loadedClass(String name) {
        ClassLoader p;
        Class<?> c = this.findLoadedClass(name);
        if (null == c && null != (p = this.getParent()) && (p instanceof ActClassLoader || p instanceof BootstrapClassLoader)) {
            return ((ActClassLoader)((Object)p)).loadedClass(name);
        }
        return c;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (name.startsWith("act.") && name.endsWith("Admin")) {
            return super.loadClass(name, resolve);
        }
        c = this.loadAppClass(name, resolve);
        if (null == c) {
            return super.loadClass(name, resolve);
        }
        return c;
    }

    protected void scan() {
        this.scanByteCode((Iterable<String>)this.libClsCache.keySet(), (Lang.Function<String, byte[]>)this.bytecodeLookup);
    }

    protected void scanByteCode(Iterable<String> classes, Lang.Function<String, byte[]> bytecodeProvider) {
        logger.debug("start to scan bytecode ...");
        AppCodeScannerManager scannerManager = this.app().scannerManager();
        HashMap dependencies = new HashMap();
        for (String className : classes) {
            logger.debug("scanning %s ...", new Object[]{className});
            dependencies.remove(className);
            byte[] ba = (byte[])bytecodeProvider.apply((Object)className);
            if (null == ba) {
                logger.warn("Cannot find any bytecode for class: %s. You might have an empty Java source file for that.", new Object[]{className});
                continue;
            }
            this.libClsCache.put(className, ba);
            Timer timer = this.metric.startTimer("act:classload:scan:bytecode:" + className);
            ArrayList<ByteCodeVisitor> visitors = new ArrayList<ByteCodeVisitor>();
            ArrayList<AppByteCodeScanner> scanners = new ArrayList<AppByteCodeScanner>();
            for (AppByteCodeScanner scanner : scannerManager.byteCodeScanners()) {
                if (!scanner.start(className)) continue;
                visitors.add(scanner.byteCodeVisitor());
                scanners.add(scanner);
            }
            if (visitors.isEmpty()) continue;
            ByteCodeVisitor theVisitor = ByteCodeVisitor.chain(visitors);
            EnvMatcher matcher = new EnvMatcher();
            matcher.setDownstream(theVisitor);
            ClassReader cr = new ClassReader(ba);
            try {
                cr.accept((ClassVisitor)matcher, 0);
            }
            catch (EnvNotMatchException e) {
                continue;
            }
            catch (AsmException e) {
                Throwable t = e.getCause();
                if (t instanceof ClassNotFoundException) continue;
                logger.error((Throwable)e, "Error scanning bytecode at %s", new Object[]{e.context()});
                ActErrorResult error = ActErrorResult.scanningError(e);
                if (Act.isDev()) {
                    this.app.setBlockIssue((Throwable)((Object)error));
                }
                throw error;
            }
            for (AppByteCodeScanner scanner : scanners) {
                scanner.scanFinished(className);
                Map<Class<? extends AppByteCodeScanner>, Set<String>> ss = scanner.dependencyClasses();
                if (ss.isEmpty()) continue;
                for (Class<? extends AppByteCodeScanner> scannerClass : ss.keySet()) {
                    AppByteCodeScanner scannerA = scannerManager.byteCodeScannerByClass(scannerClass);
                    for (String dependencyClass : ss.get(scannerClass)) {
                        logger.trace("dependencies[%s] found for %s by scanner %s", new Object[]{dependencyClass, className, scannerA});
                        ArrayList<AppByteCodeScanner> l = (ArrayList<AppByteCodeScanner>)dependencies.get(dependencyClass);
                        if (null == l) {
                            l = new ArrayList<AppByteCodeScanner>();
                            dependencies.put(dependencyClass, l);
                        }
                        if (l.contains(scanner)) continue;
                        l.add(scannerA);
                    }
                }
            }
            timer.stop();
        }
        while (!dependencies.isEmpty()) {
            String className = (String)dependencies.keySet().iterator().next();
            Timer timer = this.metric.startTimer("act:classload:scan:bytecode:" + className);
            List scanners = (List)dependencies.remove(className);
            ArrayList<ByteCodeVisitor> visitors = new ArrayList<ByteCodeVisitor>();
            for (AppByteCodeScanner scanner : scanners) {
                scanner.start(className);
                visitors.add(scanner.byteCodeVisitor());
            }
            ByteCodeVisitor theVisitor = ByteCodeVisitor.chain(visitors);
            byte[] bytes = (byte[])bytecodeProvider.apply((Object)className);
            this.libClsCache.put(className, bytes);
            ClassReader cr = new ClassReader(bytes);
            try {
                cr.accept((ClassVisitor)theVisitor, 0);
            }
            catch (AsmException e) {
                throw ActErrorResult.of(e);
            }
            for (AppByteCodeScanner scanner : scanners) {
                scanner.scanFinished(className);
                Map<Class<? extends AppByteCodeScanner>, Set<String>> ss = scanner.dependencyClasses();
                if (ss.isEmpty()) {
                    logger.trace("no dependencies found for %s by scanner %s", new Object[]{className, scanner});
                    continue;
                }
                for (Class<? extends AppByteCodeScanner> scannerClass : ss.keySet()) {
                    AppByteCodeScanner scannerA = scannerManager.byteCodeScannerByClass(scannerClass);
                    for (String dependencyClass : ss.get(scannerClass)) {
                        logger.trace("dependencies[%s] found for %s by scanner %s", new Object[]{dependencyClass, className, scannerA});
                        ArrayList<AppByteCodeScanner> l = (ArrayList<AppByteCodeScanner>)dependencies.get(dependencyClass);
                        if (null == l) {
                            l = new ArrayList<AppByteCodeScanner>();
                            dependencies.put(dependencyClass, l);
                        }
                        if (l.contains(scanner)) continue;
                        l.add(scannerA);
                    }
                }
            }
            timer.stop();
        }
    }

    protected void preload() {
        this.preloadLib();
        this.preloadClasses();
    }

    private void preloadLib() {
        HashMap<String, byte[]> bytecodeIdx = new HashMap<String, byte[]>();
        HashMap<String, Properties> jarConf = new HashMap<String, Properties>();
        Lang.Predicate ignoredClassNames = this.app().config().appClassTester().negate();
        Jars.F.JarEntryVisitor classNameIndexBuilder = Jars.F.classNameIndexBuilder(bytecodeIdx, (Lang.Function<String, Boolean>)ignoredClassNames);
        Jars.F.JarEntryVisitor confIndexBuilder = Jars.F.appConfigFileIndexBuilder(jarConf);
        List<File> jars = FullStackAppBootstrapClassLoader.jars(AppClassLoader.class.getClassLoader());
        for (File jar : jars) {
            Jars.scan(jar, classNameIndexBuilder, confIndexBuilder);
        }
        this.libClsCache.putAll(bytecodeIdx);
        AppConfig<?> config = this.app().config();
        config.loadJarProperties(jarConf);
    }

    void loadClasses() {
        for (String key : this.libClsCache.keySet()) {
            try {
                Class<?> c = this.loadClass(key, true);
                this.cache(c);
            }
            catch (Exception e) {
                logger.warn((Throwable)e, "error loading class");
            }
        }
    }

    protected void preloadClasses() {
        File base = RuntimeDirs.classes(this.app);
        List<File> files = Files.filter(base, _F.SAFE_CLASS);
        for (File file : files) {
            this.preloadClassFile(base, file);
        }
    }

    protected void preloadClassFile(File base, File file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        IO.copy((InputStream)IO.is((File)file), (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        this.libClsCache.put(ClassNames.sourceFileNameToClassName(base, file.getAbsolutePath().replace(".class", ".java")), bytes);
    }

    protected byte[] loadAppClassFromDisk(String name) {
        String path;
        File classFile;
        File base = RuntimeDirs.classes(this.app);
        if (base.canRead() && base.isDirectory() && (classFile = new File(base, path = ClassNames.classNameToClassFileName(name))).canRead()) {
            return IO.readContent((File)classFile);
        }
        return null;
    }

    public Class<?> defineClass(String name, byte[] b, int off, int len, boolean resolve) {
        Class<?> c = super.defineClass(name, b, off, len, DOMAIN);
        if (resolve) {
            super.resolveClass(c);
        }
        return c;
    }

    private Class<?> loadAppClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] bytecode = this.appBytecode(name);
        if (null == bytecode) {
            if (!name.contains("$") || !name.endsWith("MethodAccess") || name.endsWith("$MethodAccess")) {
                bytecode = this.loadAppClassFromDisk(name);
                if (null == bytecode) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (!this.app().config().needEnhancement(name)) {
            if (name.contains("$")) {
                return super.loadClass(name, resolve);
            }
            Class<?> c = super.defineClass(name, bytecode, 0, bytecode.length, DOMAIN);
            if (resolve) {
                super.resolveClass(c);
            }
            return c;
        }
        try {
            byte[] baNew = this.enhance(name, bytecode);
            try {
                Class<?> c = super.defineClass(name, baNew, 0, baNew.length, DOMAIN);
                if (resolve) {
                    super.resolveClass(c);
                }
                return c;
            }
            catch (VerifyError e) {
                File f2 = File.createTempFile(name, ".class");
                IO.write((byte[])baNew, (File)f2);
                throw e;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw E.unexpected((String)("Error processing class " + name), (Object[])new Object[0]);
        }
    }

    protected byte[] enhance(String className, byte[] bytecode) {
        return this.asmEnhance(className, bytecode);
    }

    private byte[] asmEnhance(String className, byte[] bytecode) {
        if (!AppClassLoader.enhanceEligible(className)) {
            return bytecode;
        }
        Lang.Var cw = $.var(null);
        ByteCodeVisitor enhancer = Act.enhancerManager().appEnhancer(this.app, className, (Lang.Var<ClassWriter>)cw);
        if (null == enhancer) {
            return bytecode;
        }
        EnvMatcher matcher = new EnvMatcher();
        matcher.setDownstream(enhancer);
        cw.set((Object)new ClassWriter(2));
        enhancer.commitDownstream();
        ClassReader r = new ClassReader(bytecode);
        try {
            r.accept((ClassVisitor)matcher, 8);
        }
        catch (EnvNotMatchException e) {
            return bytecode;
        }
        catch (AsmException e) {
            logger.error((Throwable)e, "error enhancing bytecode at %s", new Object[]{e.context()});
            throw ActErrorResult.enhancingError(e);
        }
        return ((ClassWriter)cw.get()).toByteArray();
    }

    protected byte[] appBytecode(String name) {
        return this.appBytecode(name, true);
    }

    protected byte[] appBytecode(String name, boolean loadFromSource) {
        return this.libClsCache.get(name);
    }

    protected byte[] bytecode(String name) {
        return this.bytecode(name, true);
    }

    protected byte[] bytecode(String name, boolean compileSource) {
        byte[] bytes = this.appBytecode(name, compileSource);
        if (null != bytes) {
            return bytes;
        }
        name = name.replace('.', '/') + ".class";
        InputStream is = this.getParent().getResourceAsStream(name);
        if (null == is) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy((InputStream)is, (OutputStream)baos);
        return baos.toByteArray();
    }

    byte[] enhancedBytecode(String name) {
        byte[] bytecode = this.bytecode(name, false);
        return null == bytecode ? null : this.enhance(name, bytecode);
    }

    private synchronized ClassNode cache(Class<?> c) {
        String pcname;
        Class<?>[] ca;
        String cname = ClassInfoRepository.canonicalName(c);
        if (null == cname) {
            return null;
        }
        ClassInfoRepository repo = this.classInfoRepository();
        if (repo.has(cname)) {
            return repo.node(cname);
        }
        String name = c.getName();
        ClassNode node = repo.node(name, cname);
        node.modifiers(c.getModifiers());
        for (Class<?> pc : ca = c.getInterfaces()) {
            String pcname2;
            if (pc == Object.class || null == (pcname2 = ClassInfoRepository.canonicalName(pc))) continue;
            this.cache(pc);
            node.addInterface(pcname2);
        }
        Class<?> pc = c.getSuperclass();
        if (null != pc && Object.class != pc && null != (pcname = ClassInfoRepository.canonicalName(pc))) {
            this.cache(pc);
            node.parent(pcname);
        }
        return node;
    }

    protected static boolean enhanceEligible(String name) {
        boolean sys = name.startsWith("java") || name.startsWith("com.google") || name.startsWith("org.apache") || name.startsWith("org.springframework");
        return !sys;
    }

    private static enum _F {

        static Lang.Predicate<String> SYS_CLASS_NAME = new Lang.Predicate<String>(){

            public boolean test(String s) {
                return s.startsWith("java") || s.startsWith("org.osgl.");
            }
        };
        static Lang.Predicate<String> SAFE_CLASS = S.F.endsWith((String)".class").and(new Lang.Function[]{SYS_CLASS_NAME.negate()});
    }
}

