/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.app.App;
import act.app.Daemon;
import act.util.SingletonBase;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.osgl.exception.ConfigurationException;

public abstract class DaemonBase
extends SingletonBase
implements Daemon {
    private Daemon.State state = Daemon.State.STOPPED;
    private Exception lastError;
    private DateTime ts = DateTime.now();
    private DateTime errTs;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void restart() {
        try {
            this.stop();
        }
        finally {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        DaemonBase daemonBase = this;
        synchronized (daemonBase) {
            if (this.state == Daemon.State.STARTED || this.state == Daemon.State.STARTING) {
                return;
            }
            this.setState(Daemon.State.STARTING);
        }
        try {
            this.setup();
            App.instance().jobManager().now(this);
        }
        catch (Exception e) {
            this.onException(e, "error starting daemon: %s", this.id());
            return;
        }
        daemonBase = this;
        synchronized (daemonBase) {
            this.setState(Daemon.State.STARTED);
        }
        this.info("Daemon[%s] started", this.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        DaemonBase daemonBase = this;
        synchronized (daemonBase) {
            if (this.state == Daemon.State.STOPPED || this.state == Daemon.State.STOPPING) {
                return;
            }
            this.setState(Daemon.State.STOPPING);
        }
        try {
            this.teardown();
        }
        catch (Exception e) {
            this.onException(e, "error stopping daemon: %s", this.id());
            return;
        }
        daemonBase = this;
        synchronized (daemonBase) {
            this.setState(Daemon.State.STOPPED);
        }
        this.info("Daemon[%s] stopped", this.id());
    }

    @Override
    public final void run() {
        try {
            this.doJob();
        }
        catch (Exception e) {
            this.onException(e, "Error executing daemon: %s", this.id());
        }
    }

    protected abstract void doJob() throws Exception;

    @Override
    public synchronized Daemon.State state() {
        return this.state;
    }

    @Override
    public DateTime timestamp() {
        return this.ts;
    }

    protected void setup() throws Exception {
    }

    protected void teardown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseResources() {
        try {
            this.stop();
        }
        finally {
            super.releaseResources();
        }
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }

    @Override
    public Exception lastError() {
        return this.lastError;
    }

    @Override
    public DateTime errorTimestamp() {
        return this.errTs;
    }

    @Override
    public synchronized void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public synchronized void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public synchronized <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected synchronized void onException(Exception e, String message, Object ... args) {
        this.lastError = e;
        this.setState(this.errorState(e));
        this.error(e, message, args);
    }

    private Daemon.State errorState(Exception e) {
        return this.isFatal(e) ? Daemon.State.FATAL : Daemon.State.ERROR;
    }

    protected boolean isFatal(Exception e) {
        return e instanceof ConfigurationException;
    }

    protected synchronized void setLastError(Exception e) {
        this.lastError = e;
    }

    private void setState(Daemon.State state) {
        this.state = state;
        this.ts = DateTime.now();
        if (state == Daemon.State.ERROR) {
            this.errTs = this.ts;
        }
    }
}

