/*
 * Decompiled with CFR 0.152.
 */
package act.boot.server;

import act.Act;
import act.Constants;
import act.asm.ClassReader;
import act.asm.ClassVisitor;
import act.asm.ClassWriter;
import act.boot.PluginClassProvider;
import act.boot.app.FullStackAppBootstrapClassLoader;
import act.util.ByteCodeVisitor;
import act.util.Jars;
import java.io.File;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;

public class ServerBootstrapClassLoader
extends ClassLoader
implements PluginClassProvider {
    private static Logger logger = L.get(ServerBootstrapClassLoader.class);
    protected final Class<?> PLUGIN_CLASS;
    private File lib;
    private File plugin;
    private Map<String, byte[]> libBC = new HashMap<String, byte[]>();
    private Map<String, byte[]> pluginBC = new HashMap<String, byte[]>();
    private List<Class<?>> pluginClasses = new ArrayList();
    private static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return ServerBootstrapClassLoader.class.getProtectionDomain();
        }
    });
    private static final Set<String> protectedClasses = C.set((Object)ServerBootstrapClassLoader.class.getName(), (Object[])new String[]{FullStackAppBootstrapClassLoader.class.getName(), PluginClassProvider.class.getName()});

    public ServerBootstrapClassLoader(ClassLoader parent) {
        super(parent);
        this.preload();
        this.PLUGIN_CLASS = $.classForName((String)"act.plugin.Plugin", (ClassLoader)this);
    }

    public ServerBootstrapClassLoader() {
        this(ServerBootstrapClassLoader._getParent());
    }

    private static ClassLoader _getParent() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null == cl) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    protected void preload() {
        String actHome = System.getProperty("ACT_HOME");
        if (null == actHome) {
            actHome = System.getenv("ACT_HOME");
        }
        if (null == actHome) {
            actHome = this.guessHome();
        }
        File home = new File(actHome);
        this.lib = new File(home, "lib");
        this.plugin = new File(home, "plugin");
        this.verifyHome();
        this.buildIndex();
    }

    private String guessHome() {
        return new File(".").getAbsolutePath();
    }

    private void verifyHome() {
        if (!this.verifyDir(this.lib) || !this.verifyDir(this.plugin)) {
            throw E.unexpected((String)"Cannot load Act: can't find lib or plugin dir", (Object[])new Object[0]);
        }
    }

    private boolean verifyDir(File dir) {
        return dir.exists() && dir.canExecute() && dir.isDirectory();
    }

    private void buildIndex() {
        this.libBC.putAll(Jars.buildClassNameIndex(this.lib));
        this.pluginBC.putAll(Jars.buildClassNameIndex(this.plugin));
        File actJar = Jars.probeJarFile(Act.class);
        if (null == actJar) {
            logger.warn("Cannot find jar file for Act");
        } else {
            this.pluginBC.putAll(Jars.buildClassNameIndex((List<File>)C.list((Object)actJar)));
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (!protectedClasses.contains(name)) {
            c = this.loadActClass(name, resolve, false);
        }
        if (null == c) {
            return super.loadClass(name, resolve);
        }
        return c;
    }

    @Override
    public List<Class<?>> pluginClasses() {
        if (this.pluginClasses.isEmpty()) {
            for (String className : C.list(this.pluginBC.keySet())) {
                Class<?> c = this.loadActClass(className, true, true);
                assert (null != c);
                int modifier = c.getModifiers();
                if (Modifier.isAbstract(modifier) || !Modifier.isPublic(modifier) || c.isInterface() || !this.PLUGIN_CLASS.isAssignableFrom(c)) continue;
                this.pluginClasses.add(c);
            }
        }
        return C.list(this.pluginClasses);
    }

    protected byte[] tryLoadResource(String name) {
        return null;
    }

    protected Class<?> loadActClass(String name, boolean resolve, boolean pluginOnly) {
        boolean fromPlugin = false;
        byte[] ba = this.pluginBC.remove(name);
        if (null == ba) {
            if (!pluginOnly) {
                ba = this.libBC.remove(name);
            }
        } else {
            fromPlugin = true;
        }
        if (null == ba) {
            ba = this.tryLoadResource(name);
        }
        if (null == ba) {
            if (pluginOnly) {
                return this.findLoadedClass(name);
            }
            return null;
        }
        Class<?> c = null;
        if (!name.startsWith(Constants.ACT_PKG) || name.startsWith(Constants.ASM_PKG)) {
            c = super.defineClass(name, ba, 0, ba.length, DOMAIN);
        }
        if (null == c) {
            Lang.Val cw = $.val(null);
            ByteCodeVisitor enhancer = Act.enhancerManager().generalEnhancer(name, (Lang.Var<ClassWriter>)cw);
            if (null == enhancer) {
                c = super.defineClass(name, ba, 0, ba.length, DOMAIN);
            } else {
                ClassWriter w = new ClassWriter(2);
                cw.set((Object)w);
                enhancer.commitDownstream();
                ClassReader r = new ClassReader(ba);
                try {
                    r.accept((ClassVisitor)enhancer, 0);
                    byte[] baNew = w.toByteArray();
                    c = super.defineClass(name, baNew, 0, baNew.length, DOMAIN);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Exception e) {
                    throw E.unexpected((String)("Error processing class " + name), (Object[])new Object[0]);
                }
            }
        }
        if (resolve) {
            super.resolveClass(c);
        }
        return c;
    }

    public Class<?> createClass(String name, byte[] b) throws ClassFormatError {
        return super.defineClass(name, b, 0, b.length, DOMAIN);
    }
}

