/*
 * Decompiled with CFR 0.152.
 */
package act.cli.bytecode;

import act.app.App;
import act.cli.CliContext;
import act.cli.CommandExecutor;
import act.cli.ReportProgress;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.meta.CommandParamMetaInfo;
import act.data.annotation.DateFormatPattern;
import act.data.annotation.Pattern;
import act.inject.param.CliContextParamLoader;
import act.inject.param.ParamValueLoaderManager;
import act.job.JobManager;
import act.job.TrackableWorker;
import act.util.Async;
import act.util.FastJsonFeature;
import act.util.FastJsonFilter;
import act.util.ProgressGauge;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Method;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;

public class ReflectedCommandExecutor
extends CommandExecutor {
    private static final Object[] DUMP_PARAMS = new Object[0];
    private CommandMethodMetaInfo methodMetaInfo;
    private App app;
    private CliContextParamLoader paramLoaderService;
    private ClassLoader cl;
    private Class[] paramTypes;
    private Class<?> commanderClass;
    private Method method;
    private MethodAccess methodAccess;
    private int commandIndex;
    private int paramCount;
    private boolean isStatic;
    private CliContext.ParsingContext parsingContext;
    private boolean async;
    private ReportProgress reportProgress;
    private String dateFormatPattern;
    private Class<? extends SerializeFilter>[] filters;
    private SerializerFeature[] features;

    public ReflectedCommandExecutor(CommandMethodMetaInfo methodMetaInfo, App app) {
        this.methodMetaInfo = (CommandMethodMetaInfo)$.requireNotNull((Object)methodMetaInfo);
        this.app = (App)$.NPE((Object)app);
        this.cl = app.classLoader();
        this.paramTypes = this.paramTypes();
        this.paramCount = methodMetaInfo.paramCount();
        this.isStatic = methodMetaInfo.isStatic();
        this.commanderClass = $.classForName((String)methodMetaInfo.classInfo().className(), (ClassLoader)this.cl);
        try {
            FastJsonFeature featureAnno;
            this.method = this.commanderClass.getMethod(methodMetaInfo.methodName(), this.paramTypes);
            this.async = null != this.method.getAnnotation(Async.class);
            this.reportProgress = this.method.getAnnotation(ReportProgress.class);
            FastJsonFilter filterAnno = this.method.getAnnotation(FastJsonFilter.class);
            if (null != filterAnno) {
                this.filters = filterAnno.value();
            }
            if (null != (featureAnno = this.method.getAnnotation(FastJsonFeature.class))) {
                this.features = featureAnno.value();
            }
        }
        catch (NoSuchMethodException e) {
            throw E.unexpected((Throwable)e);
        }
        if (!methodMetaInfo.isStatic()) {
            this.methodAccess = MethodAccess.get(this.commanderClass);
            this.commandIndex = this.methodAccess.getIndex(methodMetaInfo.methodName(), this.paramTypes);
        } else {
            this.method.setAccessible(true);
        }
        DateFormatPattern dfp = this.method.getAnnotation(DateFormatPattern.class);
        if (null != dfp) {
            this.dateFormatPattern = dfp.value();
        } else {
            Pattern pattern = this.method.getAnnotation(Pattern.class);
            if (null != pattern) {
                this.dateFormatPattern = pattern.value();
            }
        }
        this.paramLoaderService = (CliContextParamLoader)app.service(ParamValueLoaderManager.class).get(CliContext.class);
        this.buildParsingContext();
    }

    @Override
    public Object execute(CliContext context) {
        context.handlerMethod(this.method);
        if (null != this.dateFormatPattern) {
            context.dateFormatPattern(this.dateFormatPattern);
        }
        context.fastjsonFeatures(this.features);
        context.fastjsonFilters((Class[])this.filters);
        context.prepare(this.parsingContext);
        this.paramLoaderService.preParseOptions(this.method, this.methodMetaInfo, context);
        final Object cmd = this.commanderInstance(context);
        final Object[] params = this.params(cmd, context);
        if (this.async) {
            JobManager jobManager = context.app().jobManager();
            String jobId = jobManager.prepare((Lang.Function<ProgressGauge, ?>)new TrackableWorker(){

                @Override
                protected void run(ProgressGauge progressGauge) {
                    ReflectedCommandExecutor.this.invoke(cmd, params);
                }
            });
            context.setJobId(jobId);
            jobManager.now(jobId);
            if (null != this.reportProgress) {
                context.attribute("__act_report_progress__", this.reportProgress);
                return context.progress();
            }
            return "Async job started: " + jobId;
        }
        return this.invoke(cmd, params);
    }

    @Override
    protected void releaseResources() {
        this.app = null;
        this.cl = null;
        this.commandIndex = 0;
        this.commanderClass = null;
        this.method = null;
        this.methodAccess = null;
        this.paramTypes = null;
        super.releaseResources();
    }

    private Object commanderInstance(CliContext context) {
        if (this.isStatic) {
            return null;
        }
        String commander = this.commanderClass.getName();
        Object inst = context.__commanderInstance(commander);
        if (null == inst) {
            inst = this.paramLoaderService.loadHostBean(this.commanderClass, context);
            context.__commanderInstance(commander, inst);
        }
        return inst;
    }

    private Class<?>[] paramTypes() {
        int paramCount = this.methodMetaInfo.paramCount();
        Class[] ca = new Class[paramCount];
        if (0 == paramCount) {
            return ca;
        }
        for (int i = 0; i < paramCount; ++i) {
            CommandParamMetaInfo param = this.methodMetaInfo.param(i);
            String className = param.type().getClassName();
            ca[i] = $.classForName((String)className, (ClassLoader)this.cl);
        }
        return ca;
    }

    private Object[] params(Object cmd, CliContext ctx) {
        if (0 == this.paramCount) {
            return DUMP_PARAMS;
        }
        return this.paramLoaderService.loadMethodParams(cmd, this.method, ctx);
    }

    private Object invoke(Object commander, Object[] params) {
        Object result = null != this.methodAccess ? this.methodAccess.invoke(commander, this.commandIndex, params) : $.invokeStatic((Method)this.method, (Object[])params);
        return result;
    }

    private void buildParsingContext() {
        CliContextParamLoader loader = (CliContextParamLoader)this.app.service(ParamValueLoaderManager.class).get(CliContext.class);
        this.parsingContext = loader.buildParsingContext(this.commanderClass, this.method, this.methodMetaInfo);
    }
}

