/*
 * Decompiled with CFR 0.152.
 */
package act.cli.tree;

import act.cli.tree.TreeNode;
import java.util.List;
import org.osgl.Lang;
import org.osgl.util.S;

public abstract class TreeNodeFilter
extends Lang.F2<List<? extends TreeNode>, TreeNode, Boolean> {
    public final Boolean apply(List<? extends TreeNode> path, TreeNode theNode) {
        return this.test(path, theNode);
    }

    protected abstract boolean test(List<? extends TreeNode> var1, TreeNode var2);

    public static enum Common {


        private static String path(List<? extends TreeNode> context, TreeNode theNode) {
            S.Buffer sb = S.buffer();
            for (TreeNode treeNode : context) {
                sb.append(treeNode.id()).append("/");
            }
            sb.append(theNode.label());
            return sb.toString();
        }

        public static TreeNodeFilter pathMatches(final String pattern) {
            return new TreeNodeFilter(){

                @Override
                protected boolean test(List<? extends TreeNode> path, TreeNode theNode) {
                    return Common.path(path, theNode).matches(pattern);
                }
            };
        }

        public static TreeNodeFilter pathMatches(final Lang.Function<String, Boolean> predicate) {
            return new TreeNodeFilter(){

                @Override
                protected boolean test(List<? extends TreeNode> path, TreeNode theNode) {
                    return (Boolean)predicate.apply((Object)Common.path(path, theNode));
                }
            };
        }

        public static TreeNodeFilter labelMatches(final String pattern) {
            return new TreeNodeFilter(){

                @Override
                protected boolean test(List<? extends TreeNode> path, TreeNode theNode) {
                    return theNode.label().matches(pattern);
                }
            };
        }

        public static TreeNodeFilter labelMatches(final Lang.Function<String, Boolean> predicate) {
            return new TreeNodeFilter(){

                @Override
                protected boolean test(List<? extends TreeNode> path, TreeNode theNode) {
                    return (Boolean)predicate.apply((Object)theNode.label());
                }
            };
        }
    }
}

