/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.conf.AppConfigKey;
import act.conf.ConfigKey;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.UnexpectedNewInstanceException;
import org.osgl.util.Keyword;
import org.osgl.util.S;

public abstract class Config<E extends ConfigKey>
extends DestroyableBase {
    static final String PREFIX = "act.";
    static final int PREFIX_LEN = "act.".length();
    protected Map<String, Object> raw;
    protected Map<ConfigKey, Object> data;
    private static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };

    public Config(Map<String, ?> configuration) {
        this.raw = new HashMap(configuration);
        this.data = new HashMap<ConfigKey, Object>(configuration.size());
    }

    public Config() {
        this(System.getProperties());
    }

    @Override
    protected void releaseResources() {
        this.raw.clear();
        this.data.clear();
        super.releaseResources();
    }

    public <T> T get(ConfigKey key, T def) {
        Object o = this.data.get(key);
        if (null == o) {
            o = key.val(this.raw);
            if (null == o) {
                o = null == def ? NULL : def;
            }
            this.data.put(key, o);
        }
        if (this.isDebugEnabled()) {
            this.debug("config[%s] loaded: %s", key, o);
        }
        if (o == NULL) {
            return null;
        }
        return (T)o;
    }

    public void set(ConfigKey key, Object val) {
        this.data.put(key, val);
    }

    public Integer getInteger(ConfigKey key, Integer def) {
        Integer retVal = this.get(key, def);
        if (null == retVal) {
            return null;
        }
        if (retVal instanceof Number) {
            return ((Number)retVal).intValue();
        }
        String s = S.string((Object)retVal);
        if (s.contains("*")) {
            S.List sl = S.fastSplit((String)s, (String)"*");
            int n = 1;
            for (String sn : sl) {
                n *= Integer.parseInt(sn.trim());
            }
            return n;
        }
        return Integer.parseInt(s);
    }

    boolean hasConfiguration(ConfigKey key) {
        Object o = this.data.get(key);
        if (null != o && NULL != o) {
            return true;
        }
        try {
            o = key.val(this.raw);
            return null != o;
        }
        catch (ConfigurationException e) {
            Throwable t = e.getCause();
            if (t instanceof UnexpectedNewInstanceException) {
                return true;
            }
            throw e;
        }
    }

    public <T> List<T> getList(AppConfigKey key, Class<T> c) {
        Object o = this.data.get(key);
        if (null == o) {
            List<T> l = key.implList(key.key(), this.raw, c);
            this.data.put(key, l);
            return l;
        }
        return (List)o;
    }

    public <T> T get(String key) {
        ConfigKey rk;
        if (key.startsWith(PREFIX)) {
            key = key.substring(PREFIX_LEN);
        }
        if (null != (rk = this.keyOf(key))) {
            return this.get(rk, null);
        }
        return AppConfigKey.helper.getConfiguration(key, null, this.raw);
    }

    public <T> T getIgnoreCase(String key) {
        return this.get(key);
    }

    public Map<String, Object> rawConfiguration() {
        return this.raw;
    }

    public Map<String, Object> subSet(String namespace) {
        if (!(namespace = Config.canonical(namespace)).endsWith(".")) {
            namespace = namespace + ".";
        }
        String prefix2 = PREFIX + namespace;
        HashMap<String, Object> subset = new HashMap<String, Object>();
        for (String key : this.raw.keySet()) {
            Object o;
            if (!key.startsWith(namespace) && !key.startsWith(prefix2) || null == (o = this.raw.get(key))) continue;
            if (o instanceof String) {
                o = AppConfigKey.helper.evaluate(o.toString(), this.raw);
            }
            if (key.startsWith(PREFIX)) {
                key = key.substring(4);
            }
            if (subset.containsKey(key)) continue;
            subset.put(key, o);
        }
        return subset;
    }

    protected abstract ConfigKey keyOf(String var1);

    public static String canonical(String key) {
        return Keyword.of((CharSequence)key).dotted();
    }

    public static boolean matches(String k1, String k2) {
        return $.eq((Object)Keyword.of((CharSequence)k1), (Object)Keyword.of((CharSequence)k2));
    }
}

