/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.app.AppByteCodeScannerBase;
import act.app.event.SysEventId;
import act.asm.AnnotationVisitor;
import act.asm.FieldVisitor;
import act.asm.Type;
import act.inject.DefaultValue;
import act.inject.DependencyInjector;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.inject.annotation.Configuration;
import org.osgl.inject.loader.ConfigurationValueLoader;
import org.osgl.util.C;
import org.osgl.util.Const;
import org.osgl.util.E;
import org.osgl.util.S;

public class ConfigurationByteCodeScanner
extends AppByteCodeScannerBase {
    private static final String CONF_DESC = Type.getType(Configuration.class).getDescriptor();
    private String className;
    private Map<String, String> staticConfigurationFields = new HashMap<String, String>();

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    protected void reset(String className) {
        super.reset(className);
        this.className = className;
        this.staticConfigurationFields.clear();
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new ByteCodeVisitor(){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                FieldVisitor fv = super.visitField(access, name, desc, signature, value);
                boolean isStatic = AsmTypes.isStatic(access);
                if (!isStatic) {
                    return fv;
                }
                final String fieldName = name;
                return new FieldVisitor(327680, fv){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        AnnotationVisitor av = super.visitAnnotation(desc, visible);
                        if (S.eq((String)CONF_DESC, (String)desc)) {
                            return new AnnotationVisitor(327680, av){

                                public void visit(String name, Object value) {
                                    ConfigurationByteCodeScanner.this.staticConfigurationFields.put(fieldName, S.string((Object)value));
                                    super.visit(name, value);
                                }
                            };
                        }
                        return av;
                    }
                };
            }
        };
    }

    @Override
    public void scanFinished(final String className) {
        E.unexpectedIf((boolean)S.neq((String)this.className, (String)className), (String)"oops", (Object[])new Object[0]);
        if (this.staticConfigurationFields.isEmpty()) {
            return;
        }
        Object injector = this.app().injector();
        final HashMap<String, String> staticConfigurationFields = new HashMap<String, String>(this.staticConfigurationFields);
        this.app().jobManager().on(SysEventId.PRE_START, new Runnable((DependencyInjector)injector){
            final /* synthetic */ DependencyInjector val$injector;
            {
                this.val$injector = dependencyInjector;
            }

            @Override
            public void run() {
                Class<?> theClass = ConfigurationByteCodeScanner.this.app().classForName(className);
                for (Map.Entry entry : staticConfigurationFields.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    String conf = (String)entry.getValue();
                    Field field = $.fieldOf(theClass, (String)fieldName, (boolean)false);
                    DefaultValue defaultValue = field.getAnnotation(DefaultValue.class);
                    field.setAccessible(true);
                    Class<?> fieldType = field.getType();
                    boolean isConst = false;
                    boolean isVal = false;
                    BeanSpec valueSpec = BeanSpec.of((Field)field, (Injector)this.val$injector);
                    if (Const.class.isAssignableFrom(fieldType)) {
                        valueSpec = BeanSpec.of((Field)field, (Injector)this.val$injector).componentSpec();
                        isConst = true;
                    } else if (Lang.Val.class.isAssignableFrom(fieldType)) {
                        valueSpec = BeanSpec.of((Field)field, (Injector)this.val$injector).componentSpec();
                        isVal = true;
                    }
                    ConfigurationValueLoader loader = ConfigurationByteCodeScanner.this.app().getInstance(ConfigurationValueLoader.class);
                    C.Map map = C.newMap((Object[])new Object[]{"value", conf});
                    if (null != defaultValue) {
                        map.put("defaultValue", defaultValue.value());
                    }
                    loader.init((Map)map, valueSpec);
                    Object value = loader.get();
                    try {
                        Field fv;
                        Const fieldValue;
                        if (isConst) {
                            fieldValue = (Const)$.cast((Object)field.get(null));
                            if (null == fieldValue) {
                                fieldValue = $.constant((Object)value);
                                field.set(null, fieldValue);
                                continue;
                            }
                            fv = Const.class.getDeclaredField("v");
                            fv.setAccessible(true);
                            fv.set(fieldValue, value);
                            continue;
                        }
                        if (isVal) {
                            fieldValue = (Lang.Val)$.cast((Object)field.get(null));
                            if (null == fieldValue) {
                                fieldValue = $.val((Object)value);
                                field.set(null, fieldValue);
                                continue;
                            }
                            fv = Lang.Var.class.getDeclaredField("v");
                            fv.setAccessible(true);
                            fv.set(fieldValue, value);
                            continue;
                        }
                        field.set(null, value);
                    }
                    catch (Exception e) {
                        throw E.unexpected((Throwable)e, (String)"failed to set configuration value[%] to field[%s]", (Object[])new Object[]{value, field});
                    }
                }
            }
        });
    }
}

