/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.asm.Type;
import act.controller.meta.BindAnnoInfo;
import act.controller.meta.ParamAnnoInfo;
import act.util.AsmTypes;
import act.util.GeneralAnnoInfo;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.S;

public class HandlerParamMetaInfo {
    private String name;
    private Type type;
    private Type componentType;
    private boolean context;
    private ParamAnnoInfo paramAnno;
    private BindAnnoInfo bindAnno;
    private List<GeneralAnnoInfo> generalAnnoInfoList = new ArrayList<GeneralAnnoInfo>();

    public HandlerParamMetaInfo type(Type type) {
        this.type = type;
        if (AsmTypes.isContextType(type)) {
            this.context = true;
        }
        return this;
    }

    public Type type() {
        return this.type;
    }

    public HandlerParamMetaInfo componentType(Type type) {
        this.componentType = type;
        return this;
    }

    public Type componentType() {
        return this.componentType;
    }

    public HandlerParamMetaInfo name(String newName) {
        this.name = newName;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String bindName() {
        String bindName = this.name;
        if (null != this.paramAnno && S.notBlank((String)this.paramAnno.bindName())) {
            bindName = this.paramAnno.bindName();
        }
        return bindName;
    }

    public HandlerParamMetaInfo setContext() {
        this.context = true;
        return this;
    }

    public boolean isContext() {
        return this.context;
    }

    public Object defVal(Class<?> type) {
        if (this.paramAnno != null) {
            return this.paramAnno.defVal(type);
        }
        return null;
    }

    HandlerParamMetaInfo paramAnno(ParamAnnoInfo anno) {
        this.paramAnno = anno;
        return this;
    }

    public BindAnnoInfo bindAnnoInfo() {
        return this.bindAnno;
    }

    HandlerParamMetaInfo bindAnno(BindAnnoInfo anno) {
        this.bindAnno = anno;
        return this;
    }

    public HandlerParamMetaInfo addGeneralAnnotation(GeneralAnnoInfo anno) {
        this.generalAnnoInfoList.add(anno);
        return this;
    }

    public HandlerParamMetaInfo addGeneralAnnotations(List<GeneralAnnoInfo> list) {
        this.generalAnnoInfoList.addAll(list);
        return this;
    }

    public List<GeneralAnnoInfo> generalAnnoInfoList() {
        return C.list(this.generalAnnoInfoList);
    }

    public int hashCode() {
        return $.hc((Object)this.name, (Object)this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HandlerParamMetaInfo) {
            HandlerParamMetaInfo that = (HandlerParamMetaInfo)obj;
            return $.eq((Object)that.name, (Object)this.name) && $.eq((Object)that.type, (Object)this.type);
        }
        return false;
    }

    public String toString() {
        return S.concat((String)this.type.getClassName(), (String)this.name);
    }
}

